/*
 *************************************
 * ig_utility.js
 * Utility workarounds for Vanilla
 *************************************
 */
/**
 * Debounced Scroll, less overhead
 * @param {any} callback - your code in {}
 * @param {int} delay - debounce delay
 */
let smartScroll = (callback, delay = 20, timeout) => {
    // Attach an event listener to the window object
    window.addEventListener("scroll", () => {
        // Clear the timeout if it is already set
        clearTimeout(timeout);

        // Set a new timeout to execute the callback function
        timeout = setTimeout(callback, delay);
    });

    // Return the callback function
    return callback;
};
/**
 * Workaround for jquery.outerHeight()
 * @param {object} element - your code in {}
 * @returns {int}
 */
let outerHeight = (element) => {
    return (
        element.offsetHeight +
        parseInt(getComputedStyle(element).marginTop) +
        parseInt(getComputedStyle(element).marginBottom)
    );
};
/**
 * Responsive Test
 * @returns {boolean}
 */
let isResponsive = () => {
    return window.innerWidth <= breakpoint - 1 ? true : false;
};
/**
 * Get element Parents
 * @param {object} startElement
 * @param {string} selector - parent selector
 * @param {boolean} returnSelf - if startElement is included in parents array
 * @returns {array}
 */
let getParents = (startElement, selector, returnSelf = false) => {
    let parents = [];
    while (startElement) {
        parents.push(startElement);
        startElement = startElement.parentElement.closest(selector);
    }
    parents.reverse();
    if (!returnSelf) parents.pop();
    return parents;
};
class IgJs {
    constructor() {
        this.libs = new Map();
    }
    add(libName, obj) {
        this.libs.set(libName, obj);
    }
    remove(libName) {
        this.libs.delete(libName);
    }
    getLib(libName) {
        return this.libs.get(libName) || false;
    }
    list() {
        this.libs.forEach((lib, libName) => {
            console.log(libName, lib);
        });
    }
    update(libName) {
        if (typeof this.libs.get(libName).update === 'function') {
            console.log(this.libs.get(libName).update());
        }
    }
    updateAll() {
        this.libs.forEach(lib => {
            if (typeof lib.update === 'function') {
                console.log(lib.update());
            }
        });
    }
    call(libName, functionName) {
        if (typeof this.libs.get(libName)[functionName] === 'function') {
            console.log(this.libs.get(libName)[functionName]());
        }
    }
    callAll(functionName) {
        this.libs.forEach(lib => {
            if (typeof lib[functionName] === 'function') {
                console.log(lib[functionName]());
            }
        });
    }
}

let igJs = new IgJs();
window.igJs = igJs;