/*
 *************************************
 * vanilla.nav_autohide.js
 * Navigation automatic hide/show
 *************************************
 */
class Autohide {
    constructor(config) {
        this.defaultConfig = {};
        this.defaultConfig.element = document.querySelector(nav_autohide_container);
        this.config = { ...this.defaultConfig, ...config };
        this.config.containerTop = this.config.element.getBoundingClientRect().top;
        this.config.containerHeight = this.config.element.offsetHeight;
        this.lastScrollTop = 0;
        this.init();
    }
    init() {
        this.checkContainerPos();
        smartScroll(() => {
            var st = window.pageYOffset || document.documentElement.scrollTop;
            if (st > this.lastScrollTop) {
                // downscroll
                this.config.element.classList.remove("showBlock");
            } else {
                // upscroll
                this.config.element.classList.add("showBlock");
            }
            this.checkContainerPos();
            this.lastScrollTop = st <= 0 ? 0 : st;
        });
        smartresize(() => {
            this.config.containerHeight = this.config.element.offsetHeight;
            this.checkContainerPos();
        });
    }
    checkContainerPos() {
        if (isResponsive()) {
            if (window.pageYOffset >= this.config.containerHeight) {
                this.config.element.classList.add("fixedBlock");
                this.config.element.closest("body").style.paddingTop = this.config.containerHeight + "px";
            }
            if (window.pageYOffset == 0 || window.pageYOffset < this.config.containerTop) {
                this.config.element.classList.remove("fixedBlock", "showBlock");
                this.config.element.closest("body").removeAttribute("style");
            }
        } else {
            this.config.element.classList.remove("fixedBlock", "showBlock");
            this.config.element.closest("body").removeAttribute("style");
        }
    }
}

var ig_autohide = document.querySelector(nav_autohide_container);
if (ig_autohide) {
    new Autohide({ element: ig_autohide });
}