(function($) {
  $(document).ready(function() {
    if (nav_autohide_container && $(nav_autohide_container).length) {
      var $container = $(nav_autohide_container);
      var buttonContainerPos = $container.offset().top;
      var lastScrollTop = 0;
      var containerHeight = $container.outerHeight();
      checkContainerPos(containerHeight);
      $(window).scroll(function(event) {
        var st = $(this).scrollTop();
        if (st > lastScrollTop && !$('html').hasClass('responsiveNavOpen')) {
          // scroll down
          $container.removeClass('showBlock');
        } else {
          // scroll up
          $container.addClass('showBlock');
        }
        checkContainerPos(containerHeight);
        lastScrollTop = st;
      });
      $(window).smartresize(function() {
        containerHeight = $container.outerHeight();
        checkContainerPos(containerHeight);
      });
    }
    function checkContainerPos(containerHeight) {
        if($(window).width() < breakpoint) {
          if ($(window).scrollTop() >= parseInt($container.offset().top + containerHeight)) {
            $container.addClass('fixedBlock');
            $container.closest('body').css('padding-top', containerHeight);
          }
          if ($(window).scrollTop() == 0 || $(window).scrollTop() < buttonContainerPos) {
            $container.removeClass('fixedBlock showBlock');
            $container.closest('body').removeAttr("style");
          }
      } else {
          $container.removeClass('fixedBlock showBlock');
          $container.closest('body').removeAttr("style");
      }
    }

  });
})(jQuery);
