/*************************
 * smartresize
 *
 * internetgaliere / SW
 * las mod 07.11.2014
 ************************/

//Add Smart Resize to jQuery

(function($, sr) {
    var debounce = function(func, threshold, execAsap) {
        var smartresizetimeout;

        return function debounced() {
            var obj = this,
                args =
                arguments;
            function delayed() {
                if (!execAsap)
                    func.apply(obj, args);
                smartresizetimeout = null;
            };

            if (smartresizetimeout)
                clearTimeout(smartresizetimeout);
            else if (execAsap)
                func.apply(obj, args);

            smartresizetimeout = setTimeout(delayed, threshold || 200);
        };
    }
    // smartresize
    jQuery.fn[sr] = function(fn) {
        return fn ? this.bind('resize', debounce(fn)) : this.trigger(sr);
    };
})(jQuery, 'smartresize'); 