// Remove default value in table dialog for width (which is 500 by default).
'use strict';

(function() {
    
    CKEDITOR.plugins.add( 'tabledefaultwidth', {
    });

    CKEDITOR.on( 'dialogDefinition', function( ev ) {
	// Take the dialog name and its definition from the event data.
	var dialogName = ev.data.name;
	var dialogDefinition = ev.data.definition;

	// Check if the definition is from the dialog we're
	// interested on (the "Table" dialog).
	if ( dialogName == 'table' ) {
	    // Get a reference to the "Table Info" tab.
	    var infoTab = dialogDefinition.getContents( 'info' );
	    var txtWidth = infoTab.get( 'txtWidth' );
	    txtWidth['default'] = '';
	    var txtBorder = infoTab.get('txtBorder');
	    txtBorder['default'] = '';
	    var txtCellSpace = infoTab.get('txtCellSpace');
	    txtCellSpace['default'] = '';
	    var txtCellPad = infoTab.get('txtCellPad');
	    txtCellPad['default'] = '';
	    
	    var advTab = dialogDefinition.getContents( 'advanced' );
	    var styleClassesField = advTab .get( 'advCSSClasses' );
	    styleClassesField ['default'] = 'rte-contenttable';

	}
    });

})();
