/**
 *************************************
 * jquery.accordion.js
 *
 *************************************
 * @author    : internetgalerie
 *************************************
 * Changelog
 *
 * SK | 13.02.2018 | Add option to enable scrolling after opening.
 * FS | 16.01.2017 | no window load / URL Hash changes / logic less lose
 * FS | 03.02.2015 | Add Table & is-open
 * FS | 29.01.2015 | First Beta Release
 */
jQuery(function($) {
    $(document).ready(function() {
        var tar;
        var oldTar;
        var urlHash = window.location.hash;
        initializeClasses();
        $('.ig-accordion > :first-child').click(function(e) {
            // get the click target
            tar = e.target;

            // get the parent of clicked element
            var $parentTar = $(this).parent();

            // get the next target
            var $nextTar = $(this).next();

            // set hash with pregenerated title
            if( $($parentTar).data('hashid') ) {
		window.location.hash = $($parentTar).data('hashid');
	    }

            // Get the option for scrolling
            var enableAccordionScrolling = !!Accordion.enableScrolling || !!$parentTar.data('enableAccordionScrolling');

            /* the tricky part!
             *
             * IF: as long the element isn't clicked twice,
             * the element can't be toggeled normally
             *
             * ELSE IF: if the the clicked target is different,
             * cleanUP (if activated in constants) or do the rest
             *
             * ELSE: if clicked twice toggle normally
             */
            if (oldTar != tar && $nextTar.hasClass('accordion-show')) {
                $nextTar.removeClass('accordion-show');
                $parentTar.removeClass('is-open');
            } else if (oldTar != tar) {
                if (Accordion.closeOther != '0') {
                    cleanUp($parentTar.parent().parent());
                }
		if( $("#accordion-content:visible").length ) {
		    $("#accordion-content").html($parentTar.html());
		} else {
                    $nextTar.addClass('accordion-show').removeClass('accordion-hide');		
                    $parentTar.addClass('is-open');
		}		    
            } else {
		if( $("#accordion-content:visible").length ) {
		    $("#accordion-content").html($parentTar.html());
		} else {
                    $nextTar.toggleClass('accordion-show');
                    $parentTar.toggleClass('is-open');
		}
		}
            // set the clicked tar into another variable
            oldTar = tar;

            $(window).resize();
            // if google Analytics is active on page and constant is set
            if ( typeof gaEventActive != 'undefined') {
                var title = $(this).find(':header').first().text();

                var gaSettings = {
                    hitType : 'event',
                    eventCategory : 'Accordion',
                    eventLabel : title
                }

                if ($nextTar.hasClass('accordion-show') && $parentTar.hasClass('is-open')) {
                    gaSettings.eventAction = 'show';
                } else {
                    gaSettings.eventAction = 'hide';
                }
                ga('send', gaSettings);
            }

            // Scroll to top if enabled
            if (enableAccordionScrolling) {
                var windowWidth = $(window).outerWidth();
                var extraHeight = 0;

                // Add the height of the header on desktop if it's shown
                if (windowWidth > breakpoint && ($('html').hasClass('scrollHeader') || $('#header').hasClass('templateHeader'))) {
                    extraHeight += $('#header').height();
                }

                // Mobile only when scrolling up
                if (windowWidth <= breakpoint && $('#header').hasClass('fixedBlock')) {
                    var windowOffset = $(window).scrollTop();
                    if (windowOffset >= $(this).offset().top) {
                        extraHeight += $('#header').height();
                    }
                }

                var scrollTop = $(this).offset().top - extraHeight;
                setTimeout(function() {
                    $('html, body').animate({
                        scrollTop : scrollTop
                    });
                }, 50);
            }
        });

        /* cleanUp function
         * if activated in the constants it goes throght the
         * whole html DOM and removes the accordion-show from it.
         *
         * In addition it adds accordion-hide.
         */
        function cleanUp($parentTar) {
            $($parentTar).parent().find('.ig-accordion > :nth-child(2)').each(function() {
                $(this).removeClass('accordion-show').addClass('accordion-hide');
                $(this).parent().removeClass('is-open');
            });
        }

        /* initializeClasses function
         * This function will be called at first. It has the job
         * to place the accordion-show onto the elements which have the
         * Open Dektop / Open Touchscreen in the Backend
         */
        function initializeClasses() {
            $('.no-touch .ig-accordion.desktop1,.touch .ig-accordion.mobile1').each(function() {
                if ($('html').hasClass('no-touch') && $(this).hasClass('desktop1') || $('html').hasClass('touch') && $(this).hasClass('mobile1')) {
                    if( $("#accordion-content:visible").length ) {
                        $("#accordion-content").html($(this).html());
                    } else {
                        $(this).addClass('is-open');
                        $(this).addClass('accordion-show').removeClass('accordion-hide');      
                        //$(this).addClass('is-open');
                    }
                }
                if( $("#accordion-content:visible").length ) {
                    $("#accordion-content").html($(this).html());
                } else {
                    $(this).find('> :nth-child(2)').first().addClass('accordion-show');
                }
            });
        }

        // sets the generated hash in every ig-accordion Element
        function generateHashId() {
            $('.ig-accordion').each(function() {
                element = $(this);
                elementHeader = $(this).find(':header').first().text();
                if(!$(this).data('hashid')) {
                	$(this).attr('data-hashid', preparedHeaderId(elementHeader));
                }
                // set additional class if it has accordion children
                $(this).addClass(($(this).find('.ig-accordion').length ? 'ig-has-accordion-children' : ''));
            });
        }

        /*
         *  replaces everything except - a-z äöü (case sensitive)
         *  tab, whitespace, newline to -
         *  if dash is last, remove
         *  ä to ae, ö to oe and ü to ue
         *  forced to lower case
         */
        function preparedHeaderId(elementHeader) {
            return elementHeader.replace(/[^a-z0-9äöü-\s]/gi, '').replace(/\s+/g, '-').replace(/[äÄ]/g, "ae").replace(/[öÖ]/g, "oe").replace(/[üÜ]/g, "ue").replace(/\-+/g, '-').replace(/\-$/, '').toLowerCase();
        }

        // generate has for url
        generateHashId();
        // only called if urlHash != open accordion
        if (urlHash && urlHash.replace("#", '') != $('.ig-accordion.is-open').attr('data-hashid')) {
            hashElement = $('.ig-accordion[data-hashid="' + urlHash.replace("#", '') + '"]');
            hashElement.children().first().click();
        }
    });
});
