(function($) {

    var start = moment().subtract(1, 'month');
    var end = moment();

	var $filterDateFrom = $('#filterDateFrom');
	var $filterDateTo = $('#filterDateTo');

    var dataObject = $('#newsDaterange');

	if($filterDateFrom.val() && $filterDateTo.val()) {
		start = moment($filterDateFrom.val());
		end = moment($filterDateTo.val());
	}

    function updateDaterange(start, end) {
		let locale = $('html').attr('lang');
		if(start && end) {
			$filterDateFrom.val(start.format('YYYY-MM-DD'));
			$filterDateTo.val(end.format('YYYY-MM-DD'));
	        $('#newsDaterange span').html(start.locale(locale).format(daterangeLocales[locale].locale.format) + ' - ' + end.locale(locale).format(daterangeLocales[locale].locale.format));
		} else {
			$filterDateFrom.val('');
			$filterDateTo.val('');
			$('#newsDaterange span').html(daterangeLocales[locale].label);
		}
    }

    $('#newsDaterange').daterangepicker({
		startDate: start,
		endDate: end,
		alwaysShowCalendars: true,
    	ranges: daterangeLocales[$('html').attr('lang')].ranges,
	   	locale: daterangeLocales[$('html').attr('lang')].locale
    }, function(start, end) {
        updateDaterange(start, end);

        if($('#newsDaterange').parents('form').data('autoSubmit')) {
            $('#newsDaterange').parents('form').trigger('submit');
        }
    });

	if(!$filterDateFrom.val() && !$filterDateTo.val()) {
		updateDaterange(null, null);
	} else {
	    updateDaterange(start, end);
	}

	$('#newsDaterange').on('cancel.daterangepicker', function(ev, picker) {
		updateDaterange(null, null);
        if($('#newsDaterange').parents('form').data('autoSubmit')) {
            $('#newsDaterange').parents('form').trigger('submit');
        }
  	});

})(jQuery);
