<?php

namespace Ig\IgResponsiveImages\ViewHelpers;

use Ig\IgResponsiveImages\Domain\Repository\PageRepository;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;

class PageViewHelper extends \TYPO3Fluid\Fluid\ViewHelpers\ForViewHelper
{
    /**
     * Initialize arguments.
     */
    public function initializeArguments()
    {
        //    parent::initializeArguments();
        $this->registerArgument('pageUid', 'integer', 'pageUid', false);
        $this->registerArgument('as', 'string', 'Name for the page Attribute', false, 'page');
    }

    public function render(): string
    {
        $arguments = $this->arguments;
        $pageRepository = GeneralUtility::makeInstance(PageRepository::class);

        if ($arguments['pageUid']>0) {
            $pageUid=$arguments['pageUid'];
        } else {
            $pageUid=$GLOBALS['TSFE']->id;
        }
        $page=$pageRepository->findByUid($pageUid);

        $templateVariableContainer = $this->renderingContext->getVariableProvider();
        $templateVariableContainer->add($arguments['as'], $page);
        $output = trim($this->renderChildren());
        $templateVariableContainer->remove($arguments['as']);
      
        return $output;
    }
    
    /**
     * @param  array                     $arguments
     * @param  \Closure                  $renderChildrenClosure
     * @param  RenderingContextInterface $renderingContext
     * @return \Ig\IgResponsiveImages\Domain\Model\Page
     * @throws \TYPO3\CMS\Fluid\Core\ViewHelper\Exception
     */
    public static function renderStatic(array $arguments, \Closure $renderChildrenClosure, RenderingContextInterface $renderingContext)
    {
        $pageRepository = GeneralUtility::makeInstance(PageRepository::class);

        if ($arguments['pageUid']>0) {
            $pageUid=$arguments['pageUid'];
        } else {
            $pageUid=$GLOBALS['TSFE']->id;
        }
        $page=$pageRepository->findByUid($pageUid);

        $templateVariableContainer = $renderingContext->getVariableProvider();
        $templateVariableContainer->add($arguments['as'], $page);
        $output = trim($renderChildrenClosure());
        $templateVariableContainer->remove($arguments['as']);
      
        return $output;
    }
}
