<?php

namespace Ig\IgResponsiveImages\ViewHelpers;

use TYPO3\CMS\Core\Utility\GeneralUtility;

class ImageWidthViewHelper extends \TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper
{

    /**
     * Initialize arguments.
     */
    public function initializeArguments()
    {
        parent::initializeArguments();
        $this->registerArgument('maxWidth', 'int', 'maximum width of the image', false, 0);
    }

    /**
     * Render Area Width
     *
     * @return string Widrth of current Area
     */
    public function render()
    {
        $responsiveImageUtility=GeneralUtility::makeInstance('Ig\IgResponsiveImages\Utility\ResponsiveImagesUtility');
        $maxWidth=intval($this->arguments['maxWidth']);
        $imageWidth= $responsiveImageUtility->getImageWidth();
        return $maxWidth>0 && $imageWidth>$maxWidth ? $maxWidth : $imageWidth;
    }
}
