<?php

namespace Ig\IgResponsiveImages\Domain\Repository;

use TYPO3\CMS\Core\Database\Connection;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Database\Query\Restriction\FrontendRestrictionContainer;
use TYPO3\CMS\Core\Database\RelationHandler;
use TYPO3\CMS\Core\Resource\Exception\ResourceDoesNotExistException;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Utility\MathUtility;

/**
 * Repository for accessing only the first file of file references
 */
class FileRepository extends CoreFileRepository
{
    /**
     * Find FileReference objects by relation to other records
     *
     * @param string $tableName Table name of the related record
     * @param string $fieldName Field name of the related record
     * @param int $uid The UID of the related record (needs to be the localized uid, as translated IRRE elements relate to them)
     * @return array An array of objects, empty if no objects found
     * @throws \InvalidArgumentException
     */
    public function findOneByRelation($tableName, $fieldName, $uid)
    {
        $itemList = [];
        if (!MathUtility::canBeInterpretedAsInteger($uid)) {
            throw new \InvalidArgumentException(
                'UID of related record has to be an integer. UID given: "' . $uid . '"',
                1316789798
            );
        }
        $referenceUids = [];
        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)
                      ->getQueryBuilderForTable('sys_file_reference');

        $queryBuilder->setRestrictions(GeneralUtility::makeInstance(FrontendRestrictionContainer::class));
        $res = $queryBuilder
             ->select('uid')
             ->from('sys_file_reference')
             ->where(
                 $queryBuilder->expr()->eq(
                     'uid_foreign',
                     $queryBuilder->createNamedParameter($uid, Connection::PARAM_INT)
                 ),
                 $queryBuilder->expr()->eq(
                     'tablenames',
                     $queryBuilder->createNamedParameter($tableName, Connection::PARAM_STR)
                 ),
                 $queryBuilder->expr()->eq(
                     'fieldname',
                     $queryBuilder->createNamedParameter($fieldName, Connection::PARAM_STR)
                 )
             )
             ->orderBy('sorting_foreign')
             ->executeQuery();

        while ($row = $res->fetchAssociative()) {
            $referenceUids[] = $row['uid'];
        }
        if (!empty($referenceUids)) {
            foreach ($referenceUids as $referenceUid) {
                try {
                    // Just passing the reference uid, the factory is doing workspace
                    // overlays automatically depending on the current environment
                    $item = $this->factory->getFileReferenceObject($referenceUid);
                    return $item;
                } catch (ResourceDoesNotExistException $exception) {
                    // No handling, just omit the invalid reference uid
                }
            }
            //$itemList = $this->reapplySorting($itemList);
        }

        return null;//$itemList;
    }


    /**
     * As sorting might have changed due to workspace overlays, PHP does the sorting again.
     *
     * @param array $itemList
     */
    /*
      protected function reapplySorting(array $itemList): array
      {
      uasort(
      $itemList,
      function (FileReference $a, FileReference $b) {
      $sortA = (int)$a->getReferenceProperty('sorting_foreign');
      $sortB = (int)$b->getReferenceProperty('sorting_foreign');

      if ($sortA === $sortB) {
      return 0;
      }

      return ($sortA < $sortB) ? -1 : 1;
      }
      );
      return $itemList;
      }
    */
}
