<?php

namespace Ig\IgResponsiveImages\Hooks;


use TYPO3\CMS\Core\SingletonInterface;
use TYPO3\CMS\Core\Utility\GeneralUtility;


class GridelementsRenderChildHook //implements SingletonInterface
{

    /**
     * @var \Ig\IgResponsiveImages\Utility\ResponsiveImagesUtility
     */
    protected $responsiveImageUtility = null;

    /**
     * @var boolean
     */
    protected $riPop = false;
  
  
    public function __construct()
    {
        //$this->extentensionConfiguration = unserialize($GLOBALS['TYPO3_CONF_VARS']['EXT']['extConf']['gridelements']);
        $this->responsiveImageUtility=GeneralUtility::makeInstance('Ig\IgResponsiveImages\Utility\ResponsiveImagesUtility');
        $this->riPop=false;
    }

    /**
     * Processes before the items f are rendered
     *
     * @param $columns
     * @param $child
     * @param $parentGridData
     *
     * @return void
     */
    public function preProcess($columns, $child, $parentGridData)
    {
        $this->riPop=false;

        $colNr=1;
        $colRelation = [];
        foreach ($columns as $colKey=>$colVal) {
            $class=null;
            $colWidth=null;
            if (isset($parentGridData['parentgrid_flexform_width_column_normal_'.$colNr])) {
                $class=$parentGridData['parentgrid_flexform_width_column_normal_'.$colNr];
                $colWidth=intval(substr($class, 4)); // ym-gXXX
            } elseif (isset($parentGridData['parentgrid_tx_ig_newsletter_column_normal_'.$colNr])) {
                $class=$parentGridData['parentgrid_tx_ig_newsletter_column_normal_'.$colNr];
                $colWidth=$parentGridData['parentgrid_tx_ig_newsletter_column_normal_'.$colNr];
            }
            $colRelation[$colKey]= [
                'nr' => $colNr,
                'class' => $class,
                'width' => $colWidth,
                ];
            $colNr++;
        }
        $currentCol=$colRelation[$child['tx_gridelements_columns']];
        //echo($parentGridData['parentgrid_tx_gridelements_backend_layout']);
        //var_dump($parentGridData);      exit(0);
        //if( $currentCol['width']>0 || isset($parentGridData['parentgrid_flexform_settingsName']) || isset($parentGridData['parentgrid_flexform_numberOfSlides']) || isset($parentGridData['parentgrid_tx_gridelements_backend_layout']) ) {
        //file_put_contents('/tmp/ri.log', 'parentgrid_tx_gridelements_backend_layout='.$parentGridData['parentgrid_tx_gridelements_backend_layout'] ."    (columns=".count($columns).", width=".$currentCol['width'].")\n", FILE_APPEND);
        $this->riPop=$this->responsiveImageUtility->pushGridelements(count($columns), $currentCol['width'], [$parentGridData['parentgrid_flexform_settingsName'], $parentGridData['parentgrid_flexform_numberOfSlides'], $parentGridData['parentgrid_tx_gridelements_backend_layout']]);
    }


    /**
     * Processes after the items are rendered
     *
     * @param $columns
     * @param $child
     * @param $parentGridData
     *
     * @return void
     */
    public function postProcess($columns, $child, $parentGridData)
    {
        if ($this->riPop) {
            $this->riPop=false;
            $this->responsiveImageUtility->popGridelements();
        }
    }
}
