<?php

namespace Ig\IgResponsiveImages\ViewHelpers;

use Ig\IgResponsiveImages\Domain\Model\ResponsiveImagesConfiguration;
use Ig\IgResponsiveImages\Utility\ResponsiveImagesUtility;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\ViewHelpers\ForViewHelper;

class SetupViewHelper extends ForViewHelper
{
    /**
     * Initialize arguments.
     */
    public function initializeArguments()
    {
        $this->registerArgument('cols', 'mixed', 'Number of cols', false);
        $this->registerArgument('class', 'mixed', 'Class/Configuration Name', false);
        $this->registerArgument('gridClass', 'string', 'Class Name for grids like ym-50', false);
        $this->registerArgument('width', 'mixed', 'width of box e.x. 50', false);
        $this->registerArgument('tagWidth', 'mixed', 'width of image tag width in px', false);
    }

    public function render(): string
    {
        $arguments = $this->arguments;
        $configName = $arguments['class'] ? : $arguments['cols'];
      
        $responsiveImageUtility = GeneralUtility::makeInstance(ResponsiveImagesUtility::class);
      
        if (isset($arguments['gridClass'])) {
            $colWidth = (int)substr($arguments['gridClass'], 4); // ym-gXXX
        } elseif (isset($arguments['width'])) {
            $colWidth = (float)$arguments['width'];  // % 0 - 100
        } else {
            $colWidth = null;
        }
        $responsiveImagesConfiguration = GeneralUtility::makeInstance(ResponsiveImagesConfiguration::class);
        $responsiveImagesConfiguration->setColWidth($colWidth);
        $responsiveImagesConfiguration->setConfigName($configName);
        if (isset($arguments['cols'])) {
            $responsiveImagesConfiguration->setCols($arguments['cols']);
        }
        if (isset($arguments['tagWidth'])) {
            $responsiveImagesConfiguration->setTagWidth($arguments['tagWidth']);
        }
        $responsiveImageUtility->pushContainer($responsiveImagesConfiguration);
        $output = trim($this->renderChildren());
        $responsiveImageUtility->popContainer($responsiveImagesConfiguration);
        return $output;
    }
    
    /**
     * @param  array                     $arguments
     * @param  \Closure                  $renderChildrenClosure
     * @param  RenderingContextInterface $renderingContext
     * @return \Ig\IgResponsiveImages\Domain\Model\Page
     * @throws \TYPO3\CMS\Fluid\Core\ViewHelper\Exception
     */
    public static function renderStatic(array $arguments, \Closure $renderChildrenClosure, RenderingContextInterface $renderingContext)
    {
        $configName = $arguments['class'] ? : $arguments['cols'];
      
        $responsiveImageUtility = GeneralUtility::makeInstance(ResponsiveImagesUtility::class);
      
        if (isset($arguments['gridClass'])) {
            $colWidth = (int)substr($arguments['gridClass'], 4); // ym-gXXX
        } elseif (isset($arguments['width'])) {
            $colWidth = (float)$arguments['width'];  // % 0 - 100
        } else {
            $colWidth = null;
        }
        $responsiveImagesConfiguration = GeneralUtility::makeInstance(ResponsiveImagesConfiguration::class);
        $responsiveImagesConfiguration->setColWidth($colWidth);
        $responsiveImagesConfiguration->setConfigName($configName);
        if (isset($arguments['cols'])) {
            $responsiveImagesConfiguration->setCols($arguments['cols']);
        }
        if (isset($arguments['tagWidth'])) {
            $responsiveImagesConfiguration->setTagWidth($arguments['tagWidth']);
        }
        $responsiveImageUtility->pushContainer($responsiveImagesConfiguration);
        $output = trim($renderChildrenClosure());
        $responsiveImageUtility->popContainer($responsiveImagesConfiguration);
        return $output;
    }
}
