<?php

namespace Ig\IgResponsiveImages\ViewHelpers\Debug;

use Ig\IgResponsiveImages\Utility\ResponsiveImagesUtility;
use TYPO3\CMS\Core\Utility\GeneralUtility;

class TextViewHelper extends \TYPO3Fluid\Fluid\Core\ViewHelper\AbstractTagBasedViewHelper
{
    /**
     * Initialize arguments.
     */
    public function initializeArguments()
    {
        $this->registerArgument('name', 'string', 'Attribute', false);
    }
    /**
     * Render Area Width
     *
     * @return string Widrth of current Area
     */
    public function render()
    {
        $responsiveImageUtility = GeneralUtility::makeInstance(ResponsiveImagesUtility::class);
        $current = $responsiveImageUtility->debugCurrent();
        $stack = $responsiveImageUtility->debugStack();

        $classes = [];
        $c = $current;
      
        foreach ($stack as $c) {
            //$classes[]=$c['configName'] ?? 'IMG';
            $classes[] = $this->addClass($c);
        }
        $classes[] = $this->addClass($current);
        //$classes[]=$current['configName'] ? $current['configName'] .' ('.$current['parent']['class'].')' : 'IMG';
        //$classes[]=$current['configName'] ?? 'IMG';
        /*do {
        $classes[]=$c['configName'] ?? 'IMG';
        $c=isset( $c['parent'] ) ? $c['parent'] : false;
        }while( $c );
        */
        return implode(' » ', $classes);
        return print_r($current, 1);
    }

    private function addClass($c)
    {
        $sizes='';

        foreach ($c['sizes'] ?? [] as $s) {
            $sizes.=(($s['media'] ?? false) ? $s['media'].': ' : '') . $s['width']."\n";
        }
        //$sizes=print_r($c['sizes'],1);
        $class= '<span title="'.$sizes.'">'. ($c['configName'] ??   'IMG') . '</span>';

        if ($c['parent']['class'] ?? false) {
            $class.=' ('.$c['parent']['class'].')';
        }
        if ($c['parent']['width'] ?? false) {
            $class.=' ['.$c['parent']['width'].']';
        }
        return $class;
    }
}
