<?php

namespace Ig\IgResponsiveImages\ViewHelpers;

use Ig\IgResponsiveImages\Utility\ResponsiveImagesUtility;
use TYPO3\CMS\Core\Core\Environment;
use TYPO3\CMS\Core\Imaging\ImageManipulation\CropVariantCollection;
use TYPO3\CMS\Core\Imaging\ImageManipulation\Area;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Resource\FileInterface;
use TYPO3\CMS\Core\Resource\FileReference;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class SrcsetViewHelper extends AbstractViewHelper
{
    /**
     * Initialize arguments.
     */
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('file', 'object', 'File', true);
        $this->overrideArgument('class', 'string', 'Class/Configuration Name', false);
        $this->registerArgument('srcset', 'mixed', 'Image sizes that should be rendered.', false, null);
        $this->registerArgument('imageAspect', 'string', 'IG: Aspect Ratio', false, null);
        $this->registerArgument('cropVariant', 'string', 'select a cropping variant, in case multiple croppings have been specified or stored in FileReference', false, 'default');
    }

    /**
     * Render a given media file.
     *
     * @throws \UnexpectedValueException
     * @throws Exception
     */
    public function render(): string
    {
        $file = $this->arguments['file'];
       // get Resource Object (non ExtBase version)
        if (is_callable([$file, 'getOriginalResource'])) {
            // We have a domain model, so we need to fetch the FAL resource object from there
            $file = $file->getOriginalResource();
        }

        if (!$file instanceof FileInterface) {
            throw new \UnexpectedValueException('Supplied file object type ' . get_class($file) . ' must be FileInterface.', 1454252193);
        }




        $responsiveImageUtility = $this->getResponsiveImagesUtility();
        
        return $this->getResponsiveImagesUtility()->getSrcsetAttribute(
            $file,
            $this->arguments['srcset'],
            $this->arguments['imageAspect'],
            $this->arguments['cropVariant'],
            false
        );
    }

    /**
     * Returns an instance of the responsive images utility
     * This fixes an issue with DI after clearing the cache
     *
     * @return ResponsiveImagesUtility
     */
    protected function getResponsiveImagesUtility()
    {
        return GeneralUtility::makeInstance(ResponsiveImagesUtility::class);
    }
}
