<?php

namespace Ig\IgResponsiveImages\Domain\Model;



class ResponsiveImagesConfiguration
{

    protected $isPushed = false;

    protected $colWidth = null;

    protected $configName = null;

    protected $cols = null;

    protected $tagWidth = null;

    protected $outerTagWidth = null;

    //    protected array $processorConfiguration = [];



    public function push()
    {
        $this->isPushed = true;
    }
    public function isPushed():bool
    {
        return $this->isPushed;
    }

    public function setColWidth(?string $colWidth)
    {
        $this->colWidth = $colWidth;
    }
    public function getColWidth()
    {
        return $this->colWidth;
    }

    public function setConfigName(?string $configName)
    {
        $this->configName = $configName;
    }
    public function getConfigName()
    {
        return $this->configName;
    }


    public function setCols(?string $cols)
    {
        $this->cols = $cols;
    }
    public function getCols()
    {
        return $this->cols;
    }
    
 
    public function setTagWidth(?string $tagWidth)
    {
        $this->tagWidth = $tagWidth;
    }
    public function getTagWidth()
    {
        return $this->tagWidth;
    }

 
    public function setOuterTagWidth(?string $outerTagWidth)
    {
        $this->outerTagWidth = $outerTagWidth;
    }
    public function getOuterTagWidth()
    {
        return $this->outerTagWidth;
    }


    
    public function setProcessorConfiguration(array $processorConfiguration)
    {
        //$this->processorConfiguration = $processorConfiguration;
        if (isset($processorConfiguration['cols'])) {
            $this->setCols($processorConfiguration['cols']);
        }
        if (isset($processorConfiguration['tagWidth'])) {
            $this->setTagWidth($processorConfiguration['tagWidth']);
        }
    }
    /*
    public function getProcessorConfiguration()
    {
        return $this->processorConfiguration;
    }
    */
    
    
}