<?php

namespace Ig\IgResponsiveImages\Domain\Model;


use TYPO3\CMS\Core\Core\Environment;
use TYPO3\CMS\Core\Imaging\ImageManipulation\Area;
use TYPO3\CMS\Core\Imaging\ImageManipulation\CropVariantCollection;
use TYPO3\CMS\Core\Resource\FileInterface;
use TYPO3\CMS\Core\Utility\ExtensionManagementUtility;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Utility\PathUtility;
use TYPO3Fluid\Fluid\Core\ViewHelper\TagBuilder;

class PictureSource
{
    protected string $type = '';
    protected string $media = '';
    protected string $fileExtension = '';
    protected array $srcsetImages = [];
    protected string $cropVariant = '';
    protected int $quality = 0;
    // @todo: individual sizes
    
    public function setType(string $type):void
    {
        $this->type = $type;
    }
    public function getType():string
    {
        return $this->type;
    }
    public function setMedia(string $media):void
    {
        $this->media = $media;
    }
    public function getMedia():string
    {
        return $this->media;
    }

    public function setFileExtension(string $fileExtension):void
    {
        $this->fileExtension = $fileExtension;
    }
    public function getFileExtension():string
    {
        return $this->fileExtension;
    }
    public function setCropVariant(string $cropVariant):void
    {
        $this->cropVariant = $cropVariant;
    }
    public function getCropVariant():string
    {
        return $this->cropVariant;
    }
    
    public function setSrcsetImages(array $srcsetImages):void
    {
        $this->srcsetImages = $srcsetImages;
    }
    public function addSrcsetImage(string $srcsetImage, string $widthDescriptor):void
    {
        $this->srcsetImages[$widthDescriptor] = $srcsetImage;
    }
    public function getSrcsetImages():array
    {
        return $this->srcsetImages;
    }
    public function setQuality(int $quality):void
    {
        $this->quality = $quality;
    }
    public function getQuality():int
    {
        return $this->quality;
    }
}
