<?php
namespace Ig\IgRuckzuckevent\Command;

use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Fluid\View\StandaloneView;

class ReminderCommandController extends \TYPO3\CMS\Extbase\Mvc\Controller\CommandController
{
    /**
     * The repository for events
     *
     * @var \Ig\IgRuckzuckevent\Domain\Repository\EventRepository
     */
    protected $eventRepository = null;
    /**
     * The repository for registrations
     *
     * @var \Ig\IgRuckzuckevent\Domain\Repository\RegistrationRepository
     */
    protected $registrationRepository = null;


    /**
     * @var \TYPO3\CMS\Extbase\Configuration\ConfigurationManager
     */
    protected $configurationManager = null;

    /**
     * @param \Ig\IgRuckzuckevent\Domain\Repository\EventRepository $eventRepository
     */
    public function injectEventRepository(\Ig\IgRuckzuckevent\Domain\Repository\EventRepository $eventRepository)
    {
        $this->eventRepository = $eventRepository;
    }

    /**
     * @param \Ig\IgRuckzuckevent\Domain\Repository\RegistrationRepository $registrationRepository
     */
    public function injectRegistrationRepository(\Ig\IgRuckzuckevent\Domain\Repository\RegistrationRepository $registrationRepository)
    {
        $this->registrationRepository = $registrationRepository;
    }

    /**
     * @param \TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface $configurationManager
     * @return void
     */
    public function injectConfigurationManager(\TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface $configurationManager)
    {
        $this->configurationManager = $configurationManager;
        $this->configurationManager->setConfiguration(array(
                'extensionName' => 'IgRuckzuckevent',
            ));
    }


    public function reminderCommand()
    {
        $events = $this->eventRepository->findForReminder();

        $settings = $this->configurationManager->getConfiguration(
            \TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface::CONFIGURATION_TYPE_SETTINGS
        );

        foreach ($events as $event) {
            $registrations = $event->getRegistrations();

            foreach ($registrations as $registration) {
                if (!$registration->getReminded()) {
                    // Setup fluid template for the confirmation mail
                    if (\TYPO3\CMS\Core\Utility\GeneralUtility::validEmail($registration->getEmail())) {
                        $mailView = $this -> createFluidTemplate('Registration/ReminderMail.html');
                        $mailView -> assign('registration', $registration);

                        // Create mail object and send mail to email address the user who registered to the event entered
                        $mail = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance('TYPO3\\CMS\\Core\\Mail\\MailMessage');
                        $mail -> setSubject('Erinnerung zu Ihrer Kursanmeldung')
                        -> setFrom([$settings['mailFrom']])
                        -> setTo([$registration -> getEmail()])
                        -> setBody($mailView -> render(), 'text/html')
                        -> send();
                    }

                    $registration->setReminded(true);
                    $this->registrationRepository->update($registration);
                }
            }
        }
    }

    /**
     * Create a fluid template
     *
     * @param string $name
     *
     * @return \TYPO3\CMS\Fluid\View\StandaloneView
     */
    private function createFluidTemplate($name)
    {
        $extbaseFrameworkConfiguration = $this -> configurationManager -> getConfiguration(
            \TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface::CONFIGURATION_TYPE_FRAMEWORK
        );

        $view = GeneralUtility::makeInstance(StandaloneView::class);
        $view -> setLayoutRootPaths($extbaseFrameworkConfiguration['view']['layoutRootPaths']);
        $view -> setTemplateRootPaths($extbaseFrameworkConfiguration['view']['templateRootPaths']);
        $view -> setPartialRootPaths($extbaseFrameworkConfiguration['view']['partialRootPaths']);
        $view -> setTemplate($name);

        return $view;
    }

}
