<?php
namespace Ig\IgRuckzuckevent\Controller;

use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Utility\DebuggerUtility;
use Ig\IgRuckzuckevent\Domain\Model\Feedback;
use Internetgalerie\IgDynval\Controller\DynamicValidationActionController;
use Psr\Http\Message\ResponseInterface;

class FeedbackController extends ActionController
{
    use DynamicValidationActionController;

    /**
     * The repository for feedbacks
     *
     * @var \Ig\IgRuckzuckevent\Domain\Repository\FeedbackRepository
     */
    protected $feedbackRepository = null;

    /**
     * @param \Ig\IgRuckzuckevent\Domain\Repository\FeedbackRepository $feedbackRepository
     */
    public function injectFeedbackRepository(\Ig\IgRuckzuckevent\Domain\Repository\FeedbackRepository $feedbackRepository): void
    {
        $this->feedbackRepository = $feedbackRepository;
    }

    public function initializeView($view): void
    {
        $this->view->assign('controller', 'Feedback');
        $this->view->assign('pageUid', $GLOBALS['TSFE']->id);
    }

    /**
     * Liast all events with possibility to sort and filter them
     *
     * @return void
     */
    public function listAction(): ResponseInterface
    {
        $feedbacks = $this->feedbackRepository->findAll();
        $this->view->assign('feedbacks', $feedbacks);

        return $this->htmlResponse();
    }

    /**
     * Liast all events with possibility to sort and filter them
     *
     * @return void
     */
    public function organizerListAction(): ResponseInterface
    {
        $feedbacks = $this->feedbackRepository->findAll();
        $this->view->assign('feedbacks', $feedbacks);

        return $this->htmlResponse();
    }

    /**
     * New action
     *
     * @return void
     */
    public function newAction(): ResponseInterface
    {

        return $this->htmlResponse();
    }

    /**
     * Create action
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\Feedback $newFeedback
     * @TYPO3\CMS\Extbase\Annotation\Validate("Internetgalerie\IgDynval\Validation\Validator\DynamicValidator", param="newFeedback")
     * @return void
     */
    public function createAction(Feedback $newFeedback): ResponseInterface
    {
        $this->feedbackRepository->add($newFeedback);
        return $this->redirect('list');
    }

    /**
     * Edit action
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\Feedback $feedback
     * @return void
     * @TYPO3\CMS\Extbase\Annotation\IgnoreValidation $feedback
     */
    public function editAction(Feedback $feedback): ResponseInterface
    {
        $this->view->assign('feedback', $feedback);

        return $this->htmlResponse();
    }

    /**
     * Update action
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\Feedback $feedback
     * @TYPO3\CMS\Extbase\Annotation\Validate("Internetgalerie\IgDynval\Validation\Validator\DynamicValidator", param="feedback")
     * @return void
     */
    public function updateAction(Feedback $feedback): ResponseInterface
    {
        $this->feedbackRepository->update($feedback);
        return $this->redirect('list');
    }

    /**
     * Delete action
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\Feedback $feedback
     * @return void
     */
    public function deleteAction(Feedback $feedback): ResponseInterface
    {
        $this->feedbackRepository->remove($feedback);
        return $this->redirect('list');
    }

}
