<?php
namespace Ig\IgRuckzuckevent\Controller;

use Ig\IgPayment\Services\BraintreeService;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Utility\ExtensionManagementUtility;
use TYPO3\CMS\Extbase\Utility\DebuggerUtility;
use Ig\IgRuckzuckevent\Utility\UserUtility;
use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Core\Context\Context;
use TYPO3\CMS\Core\Mail\FluidEmail;
use TYPO3\CMS\Core\Mail\Mailer;
use TYPO3\CMS\Fluid\View\StandaloneView;

/**
 * The EventController handles all actions directly related to Events.
 */
class SubscriptionController extends \TYPO3\CMS\Extbase\Mvc\Controller\ActionController
{
    /**
     * subscriptionRepository
     *
     * @var \Ig\IgRuckzuckevent\Domain\Repository\SubscriptionRepository
     */
    protected $subscriptionRepository = null;

    /**
     * feUserRepository
     *
     * @var \Ig\IgRuckzuckevent\Domain\Repository\FeUserRepository
     */
    protected $feUserRepository = null;

    protected $braintreeService = null;

    /**
     * @param \Ig\IgRuckzuckevent\Domain\Repository\SubscriptionRepository $subscriptionRepository
     */
    public function injectSubscriptionRepository(\Ig\IgRuckzuckevent\Domain\Repository\SubscriptionRepository $subscriptionRepository)
    {
        $this->subscriptionRepository = $subscriptionRepository;
    }

    /**
     * @param \Ig\IgRuckzuckevent\Domain\Repository\FeUserRepository $feUserRepository
     */
    public function injectFeUserRepository(\Ig\IgRuckzuckevent\Domain\Repository\FeUserRepository $feUserRepository)
    {
        $this->feUserRepository = $feUserRepository;
    }


    /**
     * Initialize Braintree API
     *
     * @return void
     */
    public function initializeAction(): void
    {
        $this->braintreeService= GeneralUtility::makeInstance(BraintreeService::class);
    }

    public function listAction(): ResponseInterface
    {
        if (!UserUtility::isAdminLoggedIn()) {
            exit(0);
        }
        /*
        if ( $this->request->hasArgument('search')) {
    $search = $this->request->getArgument('search');
        } else {
    $search = [];
        }
        if ( $this->request->hasArgument('user')) {
    $user = $this->request->getArgument('user');
        } else {
    $user = null;
        }
        $this->view->assign('search', $search);
        */
        //$users = $this->feUserRepository->findByUsergroup(4);
        $subscription = $this->subscriptionRepository->findAll();
        $this->view->assign('subscriptions', $subscription);

        return $this->htmlResponse();
    }



    /**
     * Generates client token and shows payment form for product
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\SubscriptionOffer $product
     * @param string $referer
     * @param string $startDate
     *
     * @return void
     */
    public function paymentAction(\Ig\IgRuckzuckevent\Domain\Model\SubscriptionOffer $product, $referer, $startDate): ResponseInterface
    {
        $context = GeneralUtility::makeInstance(Context::class);
        $isLoggedIn = $context->getPropertyFromAspect('frontend.user', 'isLoggedIn');
        // Paypal payment
        if ($isLoggedIn) {
            $this->view->assign('clientToken', $this->braintreeService->generate());
            $this->view->assign('product', $product);
            $this->view->assign('referer', $referer);
            $this->view->assign('startDate', $startDate);
        }

        return $this->htmlResponse();
    }

    /**
     * Performs the transaction if the amount coming per post is the same as the price of the product
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\SubscriptionOffer $product
     * @param string $nonce
     * @param string $startDate
     *
     * @return void
     */
    public function checkoutAction(\Ig\IgRuckzuckevent\Domain\Model\SubscriptionOffer $product, $referer, $startDate): ResponseInterface
    {
        $amount = GeneralUtility::_POST('amount');
        $nonce = GeneralUtility::_POST('payment_method_nonce');

        $context = GeneralUtility::makeInstance(Context::class);
        $isLoggedIn = $context->getPropertyFromAspect('frontend.user', 'isLoggedIn');
        $userId = $context->getPropertyFromAspect('frontend.user', 'id');

        if ($isLoggedIn && $amount == $product->getPrice()) {
            //if($this->braintreeService->sale($product->getPrice(), $amount, $nonce) === true) {
            $result = $this->braintreeService->sale([
                'amount' => $amount,
                'paymentMethodNonce' => $nonce,
                'options' => [
                    'submitForSettlement' => true
                ]
            ]);
            $user = $this->feUserRepository->findByUid($userId);
            if ($this->braintreeService->isResultSuccess($result)) {
                $transaction = $result->transaction;
                $subscription = GeneralUtility::makeInstance('Ig\\IgRuckzuckevent\\Domain\\Model\\Subscription');
                //      var_dump($result);exit(0);
                $subscription->setSubscriptionOffer($product);
                $subscription->setTransactionId($transaction->id);
                $subscription->setTransactionAmount($transaction->amount);
                $subscription->setTransactionCurrency($transaction->currencyIsoCode);
                $subscription->setPaymentMethod($transaction->paymentInstrumentType);
                $subscription->setFeUser($user);

                $startDateObject = new \DateTime();
                $d = explode('.', $startDate);
                $startDateObject->setDate($d[2], $d[1], $d[0]);

                $inThreeMonths = clone $startDateObject;
                $inThreeMonths->modify('+' . $product->getDuration() . ' month');

                $subscription->setStartDate($startDateObject);
                $subscription->setExpirationDate($inThreeMonths);
                $subscription->setDaysLeft($product->getDays());

                $user->addSubscription($subscription);

                $this->subscriptionRepository->add($subscription);
                $persistenceManager = GeneralUtility::makeInstance('TYPO3\\CMS\\Extbase\\Persistence\\Generic\\PersistenceManager');
                $persistenceManager->persistAll();

                $mail = GeneralUtility::makeInstance(FluidEmail::class);

                $mail->from($this->settings['debugMail'] ?: $this->settings['mailFrom'])
                     ->to($this->settings['debugMail'] ?: $user->getEmail())
                     ->subject('Physio-Team Naderi: Ihr neues Abonnement')
                     ->format('html')
                     ->setTemplate('IgRuckzuckevent/Subscription/User')
                     ->assign('subscription', $subscription);

                $mail->setRequest($this->request);
                GeneralUtility::makeInstance(Mailer::class)->send($mail);

                /*$mailView = $this -> createFluidTemplate('Subscription/Mail.html');
                $mailView -> assign('subscription', $subscription);*/

                // Create mail object and send mail to email address the user who registered to the event entered
                /*$mail = GeneralUtility::makeInstance('TYPO3\\CMS\\Core\\Mail\\MailMessage');
                $mail -> setSubject('Physio-Team Naderi: Ihr neues Abonnement')
                    -> setFrom([$this->settings['debugMail'] ? : $this -> settings['mailFrom']])
                    -> setTo([$this->settings['debugMail'] ? : $user -> getEmail()])
                    -> setBody($mailView -> render(), 'text/html')
                    -> send();*/

                // Same for the admin mail
                if ($this->settings['debugMail']) {
                    $adminMailTo = $this->settings['debugMail'];
                } else {
                    $adminMailTo = $this->settings['mailTo'] ?: $this->settings['mailFrom'];
                }

                $adminMail = GeneralUtility::makeInstance(FluidEmail::class);

                $adminMail->from($this->settings['debugMail'] ?: $this->settings['mailFrom'])
                    ->to($adminMailTo)
                    ->subject('Physio-Team Naderi: Neues Abonnement wurde gelöst')
                    ->format('html')
                    ->setTemplate('IgRuckzuckevent/Subscription/Admin')
                    ->assign('subscription', $subscription);

                $adminMail->setRequest($this->request);
                GeneralUtility::makeInstance(Mailer::class)->send($adminMail);

                /*$adminMailView = $this -> createFluidTemplate('Subscription/AdminMail.html');
                $adminMailView -> assign('subscription', $subscription);

                
                $adminMail = GeneralUtility::makeInstance('TYPO3\\CMS\\Core\\Mail\\MailMessage');
                $adminMail -> setSubject('Physio-Team Naderi: Neues Abonnement wurde gelöst')
                    -> setFrom([$this->settings['debugMail'] ? : $this -> settings['mailFrom']])
                    -> setTo([$adminMailTo])
                    -> setBody($adminMailView -> render(), 'text/html')
                    -> send();*/
            }
            return $this->redirect(
                'transaction',
                'Subscription',
                'IgRuckzuckevent',
                [
                    'product' => $product,
                    'referer' => $referer,
                    'transactionId' => $transaction->id,
                    'startDate' => $startDate
                ]
            );
            exit();
        } else {
            $errorString = '';

            foreach ($result->errors->deepAll() as $error) {
                $errorString .= 'Error: ' . $error->code . ': ' . $error->message . "\n";
            }

            $_SESSION['errors'] = $errorString;
        }
        return $this->redirect('payment', 'Subscription', 'IgRuckzuckevent', ['product' => $product, 'referer' => $referer, 'startDate' => $startDate]);
    }

    /**
     * Transaction action shows the user if the transaction was succesful
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\SubscriptionOffer $product
     * @param string $referer
     * @param string $transactionId
     * @param string $startDate
     *
     * @return string
     */
    public function transactionAction(\Ig\IgRuckzuckevent\Domain\Model\SubscriptionOffer $product, $referer, $transactionId, $startDate): ResponseInterface
    {
        $context = GeneralUtility::makeInstance(Context::class);
        $isLoggedIn = $context->getPropertyFromAspect('frontend.user', 'isLoggedIn');

        if ($isLoggedIn && $transactionId !== '') {
            $transaction = $this->braintreeService->find($transactionId);

            if ($this->isTransactionSuccessful($transaction)) {
                $transactionState = 'success';
            } else {
                $transactionState = 'error';
            }

            $this->view->assign('product', $product);
            $this->view->assign('referer', urldecode($referer));
            $this->view->assign('transaction', $transaction);
            $this->view->assign('transactionState', $transactionState);
        }

        return $this->htmlResponse();
    }

    /**
     * Create a fluid template
     *
     * @param string $name
     *
     * @return \TYPO3\CMS\Fluid\View\StandaloneView
     */
    private function createFluidTemplate($name)
    {
        $extbaseFrameworkConfiguration = $this -> configurationManager -> getConfiguration(
            \TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface::CONFIGURATION_TYPE_FRAMEWORK
        );

        $view = GeneralUtility::makeInstance(StandaloneView::class);
        $view -> setLayoutRootPaths($extbaseFrameworkConfiguration['view']['layoutRootPaths']);
        $view -> setTemplateRootPaths($extbaseFrameworkConfiguration['view']['templateRootPaths']);
        $view -> setPartialRootPaths($extbaseFrameworkConfiguration['view']['partialRootPaths']);
        $view -> setTemplate($name);

        return $view;
    }

    protected function isTransactionSuccessful($transaction)
    {
        $transactionSuccessStatuses = [
            \Braintree\Transaction::AUTHORIZED,
            \Braintree\Transaction::AUTHORIZING,
            \Braintree\Transaction::SETTLED,
            \Braintree\Transaction::SETTLING,
            \Braintree\Transaction::SETTLEMENT_CONFIRMED,
            \Braintree\Transaction::SETTLEMENT_PENDING,
            \Braintree\Transaction::SUBMITTED_FOR_SETTLEMENT
        ];

        if (in_array($transaction->status, $transactionSuccessStatuses)) {
            return true;
        }

        return false;
    }
    public function editAction(\Ig\IgRuckzuckevent\Domain\Model\Subscription $subscription): ResponseInterface
    {
        if (!UserUtility::isAdminLoggedIn()) {
            die('permission denied');
        }
        $this->view->assign('subscription', $subscription);

        return $this->htmlResponse();
    }
        public function updateAction(\Ig\IgRuckzuckevent\Domain\Model\Subscription $subscription): ResponseInterface
    {
        if (!UserUtility::isAdminLoggedIn()) {
            die('permission denied');
        }
        $this->subscriptionRepository->update($subscription);
        return $this->redirect('newSubscription', 'User', 'IgRuckzuckevent', ['user' => $subscription->getFeUser()->getUid()]);
    }

}
