<?php
namespace Ig\IgRuckzuckevent\Controller;

use GeorgRinger\News\Pagination\QueryResultPaginator;
use GeorgRinger\NumberedPagination\NumberedPagination;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Utility\DebuggerUtility;
use Ig\IgRuckzuckevent\Utility\UserUtility;
use Internetgalerie\IgDynval\Controller\DynamicValidationActionController;
use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Core\Context\Context;
use TYPO3\CMS\Core\Mail\FluidEmail;
use TYPO3\CMS\Core\Mail\Mailer;
use TYPO3\CMS\Extbase\Persistence\Generic\PersistenceManager;
use TYPO3\CMS\Fluid\View\StandaloneView;

/**
 * The EventController handles all actions directly related to Events.
 */
class UserController extends \TYPO3\CMS\Extbase\Mvc\Controller\ActionController
{
    use DynamicValidationActionController;

    /**
     * feUserRepository
     *
     * @var \Ig\IgRuckzuckevent\Domain\Repository\FeUserRepository
     */
    protected $feUserRepository = null;

    /**
     * feUserGroupRepository
     *
     * @var \Internetgalerie\IgFrontendUser\Domain\Repository\FrontendUserGroupRepository
     */
    protected $feUserGroupRepository = null;

    /**
     * productRepository
     *
     * @var \Ig\IgRuckzuckevent\Domain\Repository\SubscriptionOfferRepository
     */
    protected $subscriptionOfferRepository = null;

    /**
     * subscriptionRepository
     *
     * @var \Ig\IgRuckzuckevent\Domain\Repository\SubscriptionRepository
     */
    protected $subscriptionRepository = null;

    /**
     * @param \Ig\IgRuckzuckevent\Domain\Repository\FeUserRepository $feUserRepository
     */
    public function injectFeUserRepository(\Ig\IgRuckzuckevent\Domain\Repository\FeUserRepository $feUserRepository)
    {
        $this->feUserRepository = $feUserRepository;
    }

    /**
     * @param \Internetgalerie\IgFrontendUser\Domain\Repository\FrontendUserRepository $feUserGroupRepository
     */
    public function injectFeUserGroupRepository(\Internetgalerie\IgFrontendUser\Domain\Repository\FrontendUserGroupRepository $feUserGroupRepository)
    {
        $this->feUserGroupRepository = $feUserGroupRepository;
    }

    /**
     * @param \Ig\IgRuckzuckevent\Domain\Repository\SubscriptionOfferRepository $subscriptionOfferRepository
     */
    public function injectSubscriptionOfferRepository(\Ig\IgRuckzuckevent\Domain\Repository\SubscriptionOfferRepository $subscriptionOfferRepository)
    {
        $this->subscriptionOfferRepository = $subscriptionOfferRepository;
    }

    /**
     * @param \Ig\IgRuckzuckevent\Domain\Repository\SubscriptionRepository $subscriptionRepository
     */
    public function injectSubscriptionRepository(\Ig\IgRuckzuckevent\Domain\Repository\SubscriptionRepository $subscriptionRepository)
    {
        $this->subscriptionRepository = $subscriptionRepository;
    }

    public function initializeAction(): void
    {
        if (isset($this->arguments['subscription']) || isset($this->arguments['newSubscription'])) {
            if (isset($this->arguments['subscription'])) {
                $subscription = $this->arguments['subscription'];
            } else {
                $subscription = $this->arguments['newSubscription'];
            }

            // Set date format of date fields
            foreach (['startDate'] as $dateField) {
                $subscription->getPropertyMappingConfiguration()
                ->forProperty($dateField)
                ->setTypeConverterOption(
                    'TYPO3\\CMS\\Extbase\\Property\\TypeConverter\\DateTimeConverter',
                    \TYPO3\CMS\Extbase\Property\TypeConverter\DateTimeConverter::CONFIGURATION_DATE_FORMAT,
                    'd.m.Y'
                );
            }
        }
    }

    public function listAction(): ResponseInterface
    {
        if (!UserUtility::isAdminLoggedIn()) {
            exit(0);
        }

        if ($this->request->hasArgument('search')) {
            $search = $this->request->getArgument('search');
        } else {
            $search = [];
        }
        if ($this->request->hasArgument('user')) {
            $user = $this->request->getArgument('user');
        } else {
            $user = null;
        }
        $this->view->assign('search', $search);

        //$users = $this->feUserRepository->findByUsergroup(4);
        $users = $this->feUserRepository->findWithSearch(4, $search, $user);

        $currentPage = $this->request->hasArgument('currentPage') ? (int) $this->request->getArgument('currentPage') : 1;
        $paginator = new QueryResultPaginator($users, $currentPage, 20);
        $pagination = new NumberedPagination($paginator, 10); // zweiter Argument: maximal Anzahl Links

        $this->view->assign('pagination', [
            'paginator' => $paginator,
            'pagination' => $pagination,
        ]);

        $this->view->assign('users', $users);

        return $this->htmlResponse();
    }

    /**
     * Shows edit user form
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\FeUser $user
     * @return void
     */
    public function showAction(\Ig\IgRuckzuckevent\Domain\Model\FeUser $user = null): ResponseInterface
    {
        $context = GeneralUtility::makeInstance(Context::class);
        $userId = $context->getPropertyFromAspect('frontend.user', 'id');
        $isLoggedIn = $context->getPropertyFromAspect('frontend.user', 'isLoggedIn');
        if (!$user && $userId) {
            $user = $this->feUserRepository->findByUid($userId);
        }

        if ($isLoggedIn && (UserUtility::isAdminLoggedIn() || $user->getUid() == $userId)) {
            $this->view->assign('user', $user);
        }

        return $this->htmlResponse();
    }

    /**
     * Shows the registration form
     *
     * @param string $referer
     * @return void
     */
    public function newAction($referer = ''): ResponseInterface
    {
        $this->view->assign('referer', $referer);

        return $this->htmlResponse();
    }

    /**
     * Inserts a new user
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\FeUser $newUser
     * @param string $password
     * @param string $passwordConfirmation
     * @param string $referer
     * @return void
     * @TYPO3\CMS\Extbase\Annotation\Validate("Internetgalerie\IgDynval\Validation\Validator\DynamicValidator", param="newUser")
     * @TYPO3\CMS\Extbase\Annotation\Validate("\Ig\IgRuckzuckevent\Domain\Validator\UserExistsValidator", param="newUser")
     * @TYPO3\CMS\Extbase\Annotation\Validate("\Ig\IgRuckzuckevent\Domain\Validator\UserRegistrationFormValidator", param="newUser")
     * @TYPO3\CMS\Extbase\Annotation\Validate("NotEmpty", param="password")
     * @TYPO3\CMS\Extbase\Annotation\Validate("\Ig\IgRuckzuckevent\Domain\Validator\PasswordConfirmationValidator", param="password")
     */
    public function createAction(\Ig\IgRuckzuckevent\Domain\Model\FeUser $newUser, string $password, $passwordConfirmation, $referer = ''): ResponseInterface
    {
        $persistenceManager = GeneralUtility::makeInstance('TYPO3\\CMS\\Extbase\\Persistence\\Generic\\PersistenceManager');
        $newUser->setPid(5);
        $newUser->setUsername($newUser->getEmail());
        $user = $this->feUserRepository->findHiddenByUsername($newUser->getUsername());

        if ($user && $user->getDisable()) {
            $this->feUserRepository->remove($user);
        }

        $hashFactory = GeneralUtility::makeInstance(\TYPO3\CMS\Core\Crypto\PasswordHashing\PasswordHashFactory::class);
        $hashInstance = $hashFactory->getDefaultHashInstance('FE');
        $hashedPassword = $hashInstance->getHashedPassword($password);
        $newUser->setPassword($hashedPassword);

        $newUser->setHash(md5(uniqid()));

        if (UserUtility::isAdminLoggedIn()) {
            $newUser->setDisable(false);
            $newUser->addUsergroup($this->feUserGroupRepository->findByUid(4));
        }

        $this->feUserRepository->add($newUser);
        $persistenceManager->persistAll();

        if (!UserUtility::isAdminLoggedIn()) {
            $mail = GeneralUtility::makeInstance(FluidEmail::class);
            $mail->from($this->settings['debugMail'] ?: $this->settings['mailFrom'])
                ->to($this->settings['debugMail'] ?: $newUser->getEmail())
                ->subject('Physio-Team Naderi: Bestätigung der E-Mail-Adresse')
                ->format('html')
                ->setTemplate('IgRuckzuckevent/User/New/User')
                ->assignMultiple([
                    'user' => $newUser,
                    'referer' => $referer
                ]);

            $mail->setRequest($this->request);
            GeneralUtility::makeInstance(Mailer::class)->send($mail);

            /*$mailView = $this->createFluidTemplate('User/ConfirmationMail.html');
            $mailView->assign('user', $newUser);
            $mailView->assign('referer', $referer);

            $mail = GeneralUtility::makeInstance('TYPO3\\CMS\\Core\\Mail\\MailMessage');
            $mail -> setSubject('Physio-Team Naderi: Bestätigung der E-Mail-Adresse')
            -> setFrom([$this->settings['debugMail'] ? : $this -> settings['mailFrom']])
            -> setTo([$this->settings['debugMail'] ? : $newUser->getEmail()])
            -> setBody($mailView -> render(), 'text/html')
            -> send();*/

            return $this->redirect('reminder', 'User', 'IgRuckzuckevent', ['user' => $newUser->getUid()]);
        } else {
            return $this->redirect('list');
        }
    }

    /**
     * Reminds the user to check his email
     *
     * @param integer $user
     * @return void
     */
    public function reminderAction($user): ResponseInterface
    {
        $this->view->assign('user', $this->feUserRepository->findHiddenByUid($user));

        return $this->htmlResponse();
    }

    /**
     * Inserts a new user and sends mail to admin
     *
     * @param integer $user
     * @param string $hash
     * @param string $referer
     * @return void
     */
    public function confirmationAction($user, $hash, $referer = ''): ResponseInterface
    {
        $user = $this->feUserRepository->findHiddenByUid($user);

        if ($user->getDisable() && $user->getHash() == $hash) {
            $usergroup = $this->feUserGroupRepository->findByUid(4);

            $user->setDisable(false);
            $user->addUsergroup($usergroup);

            $this->feUserRepository->update($user);

            $mail = GeneralUtility::makeInstance(FluidEmail::class);
            $mail->from($this->settings['debugMail'] ?: $this->settings['mailFrom'])
                ->to($this->settings['debugMail'] ?: $this->settings['mailFrom'])
                ->subject('Physio-Team Naderi: Neuer Benutzer hat sich angemeldet')
                ->format('html')
                ->setTemplate('IgRuckzuckevent/User/Create/Admin')
                ->assign('user', $user);

            $mail->setRequest($this->request);
            GeneralUtility::makeInstance(Mailer::class)->send($mail);

            /*$adminMailView = $this->createFluidTemplate('User/AdminConfirmationMail.html');
            $adminMailView->assign('user', $user);

            $adminMail = GeneralUtility::makeInstance('TYPO3\\CMS\\Core\\Mail\\MailMessage');
            $adminMail -> setSubject('Physio-Team Naderi: Neuer Benutzer hat sich angemeldet')
            -> setFrom([$this->settings['debugMail'] ? : $this -> settings['mailFrom']])
            -> setTo([$this->settings['debugMail'] ? : $this -> settings['mailFrom']])
            -> setBody($adminMailView -> render(), 'text/html')
            -> send();*/

            $mail = GeneralUtility::makeInstance(FluidEmail::class);
            $mail->from($this->settings['debugMail'] ?: $this->settings['mailFrom'])
                ->to($this->settings['debugMail'] ?: $user->getEmail())
                ->subject('Physio-Team Naderi: Vielen Dank für Ihre Anmeldung')
                ->format('html')
                ->setTemplate('IgRuckzuckevent/User/Create/User')
                ->assign('user', $user);

            $mail->setRequest($this->request);
            GeneralUtility::makeInstance(Mailer::class)->send($mail);

            /*$mailView = $this->createFluidTemplate('User/OverviewMail.html');
            $mailView->assign('user', $user);

            $mail = GeneralUtility::makeInstance('TYPO3\\CMS\\Core\\Mail\\MailMessage');
            $mail -> setSubject('Physio-Team Naderi: Vielen Dank für Ihre Anmeldung')
            -> setFrom([$this->settings['debugMail'] ? : $this -> settings['mailFrom']])
            -> setTo($this->settings['debugMail'] ? : $user->getEmail())
            -> setBody($mailView -> render(), 'text/html')
            -> send();*/

            $this->view->assign('user', $user);
            $this->view->assign('referer', $referer);
        }

        return $this->htmlResponse();
    }

    /**
     * Shows edit user form
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\FeUser $user
     * @return void
     */
    public function editAction(\Ig\IgRuckzuckevent\Domain\Model\FeUser $user = null): ResponseInterface
    {
        $context = GeneralUtility::makeInstance(Context::class);
        $userId = $context->getPropertyFromAspect('frontend.user', 'id');
        $isLoggedIn = $context->getPropertyFromAspect('frontend.user', 'isLoggedIn');
        if (!$user && $userId) {
            $user = $this->feUserRepository->findByUid($userId);
        }

        if ($isLoggedIn && (UserUtility::isAdminLoggedIn() || $user->getUid() == $userId)) {
            $this->view->assign('user', $user);
        }

        return $this->htmlResponse();
    }

    /**
     * Updates a user
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\FeUser $user
     * @return void
     * @TYPO3\CMS\Extbase\Annotation\Validate("Internetgalerie\IgDynval\Validation\Validator\DynamicValidator", param="user")
     * @TYPO3\CMS\Extbase\Annotation\Validate("\Ig\IgRuckzuckevent\Domain\Validator\UserRegistrationFormValidator", param="user")
     */
    public function updateAction(\Ig\IgRuckzuckevent\Domain\Model\FeUser $user): ResponseInterface
    {
        $context = GeneralUtility::makeInstance(Context::class);
        $userId = $context->getPropertyFromAspect('frontend.user', 'id');
        $isLoggedIn = $context->getPropertyFromAspect('frontend.user', 'isLoggedIn');
        if ($isLoggedIn && (UserUtility::isAdminLoggedIn() || $user->getUid() == $userId)) {
            $user->setUsername($user->getEmail());
            $this->feUserRepository->update($user);
        }
        if (!UserUtility::isAdminLoggedIn()) {
            return $this->redirect('show', 'User');
        } else {
            return $this->redirect('list', 'User');
        }
    }

    /**
     * Shows password change form for a user
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\FeUser $user
     * @return void
     */
    public function passwordChangeAction(\Ig\IgRuckzuckevent\Domain\Model\FeUser $user = null): ResponseInterface
    {
        $context = GeneralUtility::makeInstance(Context::class);
        $userId = $context->getPropertyFromAspect('frontend.user', 'id');
        $isLoggedIn = $context->getPropertyFromAspect('frontend.user', 'isLoggedIn');
        if (!$user && $userId) {
            $user = $this->feUserRepository->findByUid($userId);
        }

        if ($isLoggedIn && (UserUtility::isAdminLoggedIn() || $user->getUid() == $userId)) {
            $this->view->assign('user', $user);
        }

        return $this->htmlResponse();
    }

    /**
     * Updates the password of a user
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\FeUser $user
     * @param string $oldPassword
     * @param string $newPassword
     * @param string $passwordConfirmation
     * @return void
     * @TYPO3\CMS\Extbase\Annotation\Validate("Internetgalerie\IgDynval\Validation\Validator\DynamicValidator", param="user")
     * @TYPO3\CMS\Extbase\Annotation\Validate("\Ig\IgRuckzuckevent\Domain\Validator\PasswordChangeValidator", param="user")
     * @TYPO3\CMS\Extbase\Annotation\Validate("NotEmpty", param="oldPassword")
     * @TYPO3\CMS\Extbase\Annotation\Validate("NotEmpty", param="newPassword")
     * @TYPO3\CMS\Extbase\Annotation\Validate("\Ig\IgRuckzuckevent\Domain\Validator\PasswordConfirmationValidator", param="newPassword")
     */
    public function updatePasswordAction(\Ig\IgRuckzuckevent\Domain\Model\FeUser $user, string $oldPassword, string $newPassword, string $passwordConfirmation): ResponseInterface
    {
        $context = GeneralUtility::makeInstance(Context::class);
        $userId = $context->getPropertyFromAspect('frontend.user', 'id');
        $isLoggedIn = $context->getPropertyFromAspect('frontend.user', 'isLoggedIn');
        if ($isLoggedIn && (UserUtility::isAdminLoggedIn() || $user->getUid() == $userId)) {
            $hashFactory = GeneralUtility::makeInstance(\TYPO3\CMS\Core\Crypto\PasswordHashing\PasswordHashFactory::class);
            $hashInstance = $hashFactory->getDefaultHashInstance('FE');
            $hashedPassword = $hashInstance->getHashedPassword($newPassword);
            $user->setPassword($hashedPassword);
            $this->feUserRepository->update($user);
        }
        if (!UserUtility::isAdminLoggedIn()) {
            return $this->redirect('show', 'User');
        } else {
            return $this->redirect('list', 'User');
        }
    }

    public function deleteAction(\Ig\IgRuckzuckevent\Domain\Model\FeUser $user): ResponseInterface
    {
        $context = GeneralUtility::makeInstance(Context::class);
        $userId = $context->getPropertyFromAspect('frontend.user', 'id');
        $isLoggedIn = $context->getPropertyFromAspect('frontend.user', 'isLoggedIn');
        if ($isLoggedIn && (UserUtility::isAdminLoggedIn() || $user->getUid() == $userId)) {
            if ($user->getActiveSubscriptions()->count() == 0) {
                $this->feUserRepository->remove($user);
            }
        }
        return $this->redirect('list');
    }

    public function newSubscriptionAction(\Ig\IgRuckzuckevent\Domain\Model\FeUser $user): ResponseInterface
    {
        $context = GeneralUtility::makeInstance(Context::class);
        $userId = $context->getPropertyFromAspect('frontend.user', 'id');
        $isLoggedIn = $context->getPropertyFromAspect('frontend.user', 'isLoggedIn');
        if ($isLoggedIn && (UserUtility::isAdminLoggedIn() || $user->getUid() == $userId)) {
            $this->view->assign('user', $user);
            $this->view->assign('subscriptionOffers', $this->subscriptionOfferRepository->findAll());
        }

        return $this->htmlResponse();
    }

    public function createSubscriptionAction(\Ig\IgRuckzuckevent\Domain\Model\Subscription $subscription): ResponseInterface
    {
        /*
        if( !$this->request->hasArgument('agb') || $this->request->getArgument('agb')==0)
    $this->forward('newSubscription');
        */
        $context = GeneralUtility::makeInstance(Context::class);
        $userId = $context->getPropertyFromAspect('frontend.user', 'id');
        $isLoggedIn = $context->getPropertyFromAspect('frontend.user', 'isLoggedIn');
        if ($isLoggedIn && (UserUtility::isAdminLoggedIn() || $subscription->getFeUser()->getUid() == $userId)) {
            $inThreeMonths = clone $subscription->getStartDate();
            $inThreeMonths->modify('+' . $subscription->getSubscriptionOffer()->getDuration() . ' month');

            $subscription->setExpirationDate($inThreeMonths);
            $subscription->setDaysLeft($subscription->getSubscriptionOffer()->getDays());

            $subscription->getFeUser()->addSubscription($subscription);

            $this->subscriptionRepository->add($subscription);
            $persistenceManager = GeneralUtility::makeInstance(PersistenceManager::class);
            $persistenceManager->persistAll();
        }
        if (UserUtility::isAdminLoggedIn()) {
            $uriBuilder = $this->uriBuilder;
            $uri = $uriBuilder->setTargetPageUid(168)->setArguments(['tx_igruckzuckevent_managementuser' => ['user' => $subscription->getFeUser()]])->build();
            return $this->redirectToURI($uri, $delay=0, $statusCode=303);
        } else {
            return $this->redirect('list');
        }
    }

    public function deleteSubscriptionAction(\Ig\IgRuckzuckevent\Domain\Model\Subscription $subscription): ResponseInterface
    {
        if (UserUtility::isAdminLoggedIn() ) {
            if( $subscription->getDaysLeft() == $subscription->getSubscriptionOffer()->getDays() ||$subscription->getDaysLeft()==0) {
                $this->subscriptionRepository->remove($subscription);
                $persistenceManager = GeneralUtility::makeInstance(PersistenceManager::class);
                $persistenceManager->persistAll();
            }
        }
        return $this->redirect('newSubscription', 'User', 'IgRuckzuckevent', ['user' => $subscription->getFeUser()]);
    }

    public function exportXlsAction(\Ig\IgRuckzuckevent\Domain\Model\FeUser $user): ResponseInterface
    {
        $registrations = $user->getPassedRegistrations()->toArray();

        //$phpExcelService = GeneralUtility::makeInstanceService('phpexcel');
        $phpExcel = new \PhpOffice\PhpSpreadsheet\Spreadsheet();
        $phpExcel->setActiveSheetIndex(0);
        $row = 1;

        $phpExcel->getActiveSheet()->SetCellValue('A' . $row, 'Name');
        $phpExcel->getActiveSheet()->SetCellValue('B' . $row, 'Vorname');
        $phpExcel->getActiveSheet()->SetCellValue('C' . $row, 'E-Mail-Adresse');
        $phpExcel->getActiveSheet()->SetCellValue('D' . $row, 'Telefon');

        $phpExcel->getActiveSheet()->getStyle('A' . $row . ':D' . $row)->getFont()->setBold(true);

        $row++;

        $phpExcel->getActiveSheet()->SetCellValue('A' . $row, $user->getLastName());
        $phpExcel->getActiveSheet()->SetCellValue('B' . $row, $user->getFirstName());
        $phpExcel->getActiveSheet()->SetCellValue('C' . $row, $user->getEmail());
        $phpExcel->getActiveSheet()->SetCellValueExplicit('D' . $row, $user->getTelephone(), \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING);

        $row++;
        $row++;

        $phpExcel->getActiveSheet()->SetCellValue('A' . $row, 'Kurs');
        $phpExcel->getActiveSheet()->SetCellValue('B' . $row, 'Datum');
        $phpExcel->getActiveSheet()->SetCellValue('C' . $row, 'Zeit von');
        $phpExcel->getActiveSheet()->SetCellValue('D' . $row, 'Zeit bis');
        $phpExcel->getActiveSheet()->SetCellValue('E' . $row, 'Bezahlmethode/Abo');
        $phpExcel->getActiveSheet()->getStyle('A' . $row . ':E' . $row)->getFont()->setBold(true);

        $row++;

        usort($registrations, function ($a, $b) {
            return $a->getEvent()->getDateTimeFrom() > $b->getEvent()->getDateTimeFrom();
        });

        foreach ($registrations as $registration) {
            // First row: Output event title and registration count
            $phpExcel->getActiveSheet()->SetCellValue('A' . $row, $registration->getEvent()->getTitle());

            // Output registration count
            $phpExcel->getActiveSheet()->SetCellValue('B' . $row, html_entity_decode($registration->getEvent()->getDateFrom()->format('d.m.Y')));
            $phpExcel->getActiveSheet()->SetCellValue('C' . $row, html_entity_decode($registration->getEvent()->getDateTimeFrom()->format('H:i')));
            $phpExcel->getActiveSheet()->SetCellValue('D' . $row, html_entity_decode($registration->getEvent()->getDateTimeTo()->format('H:i')));

            // Output registration count
            if ($registration->getPaymentMethod() == 'office') {
                $phpExcel->getActiveSheet()->SetCellValue('E' . $row, 'Sekretariat');
            } else {
                $phpExcel->getActiveSheet()->SetCellValue('E' . $row, html_entity_decode(
                    $registration->getSubscription()->getSubscriptionOffer()->getName() . ', '
                    . $registration->getSubscription()->getStartDate()->format('d.m.Y')
                    . ' bis '
                    . $registration->getSubscription()->getExpirationDate()->format('d.m.Y')
                ));
            }
            $row++;
        }

        // Set column width automatically according to their content
        foreach (range('A', 'E') as $column) {
            $phpExcel->getActiveSheet()->getColumnDimension($column)->setAutoSize(true);
        }

        // Temporary fielname
        $fileName = 'typo3temp/events-user-' . $user->getUid() . '-' . time() . '.xlsx';

        // Create an Excel Writer
        $excelWriter = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($phpExcel); // Create an Excel Writer
        // Save to temporary file
        $excelWriter->save($fileName);

        // Set headers
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="' . str_replace('typo3temp/', '', $fileName) . '"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');
        // If you're serving to IE over SSL, then the following may be needed
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
        // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
        // always modified
        header('Cache-Control: cache, must-revalidate');
        // HTTP/1.1
        header('Pragma: public');
        // HTTP/1.0
        header('Content-Length: ' . filesize($fileName));
        //header('Pragma: no-cache');

        echo file_get_contents($fileName);
        // Output file

        unlink($fileName);
        // Delete temporary file

        exit();

        return $this->htmlResponse();
    }

    /**
     * Create a fluid template
     *
     * @param string $name
     *
     * @return \TYPO3\CMS\Fluid\View\StandaloneView
     */
    private function createFluidTemplate($name)
    {
        $extbaseFrameworkConfiguration = $this -> configurationManager -> getConfiguration(
            \TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface::CONFIGURATION_TYPE_FRAMEWORK
        );

        $view = GeneralUtility::makeInstance(StandaloneView::class);
        $view -> setLayoutRootPaths($extbaseFrameworkConfiguration['view']['layoutRootPaths']);
        $view -> setTemplateRootPaths($extbaseFrameworkConfiguration['view']['templateRootPaths']);
        $view -> setPartialRootPaths($extbaseFrameworkConfiguration['view']['partialRootPaths']);
        $view -> setTemplate($name);

        return $view;
    }

}
