<?php

namespace Ig\IgRuckzuckevent\Domain\Model;

use TYPO3\CMS\Core\DataHandling\SlugHelper;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\DataHandling\Model\RecordStateFactory;
use Ig\IgRuckzuckevent\Domain\Repository\RegistrationRepository;
use Ig\IgRuckzuckevent\Utility\JsonUtility;
use TYPO3\CMS\Extbase\Object\ObjectManager;
use TYPO3\CMS\Extbase\Utility\LocalizationUtility;

/**
 * The Event model class is representing an entity of the table tx_igruckzuckevent_domain_model_event
 */
class Event extends \TYPO3\CMS\Extbase\DomainObject\AbstractEntity
{
    /**
     * The title of the event
     *
     * @var string
     * @TYPO3\CMS\Extbase\Annotation\Validate("NotEmpty")
     */
    protected $title = '';

    /**
     * subtitle
     *
     * @var string
     */
    protected $subtitle = '';

    /**
     * The teaser text for the event
     *
     * @var string
     */
    protected $teaser = '';

    /**
     * The event description text
     *
     * @var string
     */
    protected $description = '';

    /**
     * The start date of the event
     *
     * @var \DateTime
     */
    protected $dateFrom = null;

    /**
     * The start time of the event
     *
     * @var string
     */
    protected $timeFrom = null;

    /**
     * The end date of the event
     *
     * @var \DateTime
     */
    protected $dateTo = null;

    /**
     * The end time for the event
     *
     * @var string
     */
    protected $timeTo = null;

    /**
     * The street where the event is happening
     *
     * @var string
     */
    protected $street = '';

    /**
     * The additional address where the event is happening
     *
     * @var string
     */
    protected $address2 = '';

    /**
     * The zip code of the place where the event is happening
     *
     * @var string
     */
    protected $zip = '';

    /**
     * The city name of the place where the event is happening
     *
     * @var string
     */
    protected $city = '';

    /**
     * The country where the event is happening
     *
     * @var string
     */
    protected $country = '';

    /**
     * The date of the deadline for registrations
     *
     * @var \DateTime
     */
    protected $dateDeadline = null;

    /**
     * The time of the deadline for registrations
     *
     * @var string
     */
    protected $timeDeadline = null;

    /**
     * Minimum count of registrations needed for the event to happen
     *
     * @var int
     */
    protected $minRegistrations = null;

    /**
     * Maximum cout of registrations allowed for the event
     *
     * @var int
     */
    protected $maxRegistrations = null;

    /**
     * Booked out
     *
     * @var boolean
     */
    protected $bookedOut = false;

    /**
     * Registrations Info
     *
     * @var string
     */
    protected $registrationsInfo = '';

    /**
     * Postponed
     *
     * @var boolean
     */
    protected $postponed = false;

    /**
     * Postponed Text
     *
     * @var string
     */
    protected $postponedText = '';

    /**
     * Canceled
     *
     * @var boolean
     */
    protected $canceled = false;

    /**
     * Canceled Text
     *
     * @var string
     */
    protected $canceledText = '';

    /**
     * Are registrations possible?
     *
     * @var bool
     */
    protected $registrationsPossible = false;

    /**
     * The price for the participation to an event
     *
     * @var float
     */
    protected $price = null;

    /**
     * The images related to the event
     *
     * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\TYPO3\CMS\Extbase\Domain\Model\FileReference>
     * @TYPO3\CMS\Extbase\Annotation\ORM\Cascade("remove")
     */
    protected $images = null;

    /**
     * targetgroup
     *
     * @var string
     */
    protected $targetgroup = '';

    /**
     * targets
     *
     * @var string
     */
    protected $targets = '';

    /**
     * contents
     *
     * @var string
     */
    protected $contents = '';

    /**
     * workingmethods
     *
     * @var string
     */
    protected $workingmethods = '';

    /**
     * numParticipants
     *
     * @var int
     */
    protected $numParticipants = 0;

    /**
     * courseOrganizer
     *
     * @var string
     */
    protected $courseOrganizer = '';

    /**
     * datetimelabel
     *
     * @var string
     */
    protected $datetimelabel = '';

    /**
     * dateFromLabel
     *
     * @var string
     */
    protected $dateFromLabel = '';

    /**
     * dateToLabel
     *
     * @var string
     */
    protected $dateToLabel = '';

    /**
     * duration
     *
     * @var string
     */
    protected $duration = '';

    /**
     * place
     *
     * @var string
     */
    protected $place = '';

    /**
     * costs
     *
     * @var string
     */
    protected $costs = '';

    /**
     * note
     *
     * @var string
     * @TYPO3\CMS\Extbase\Annotation\ORM\Cascade("remove")
     */
    protected $note = null;

    /**
     * file
     *
     * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\TYPO3\CMS\Extbase\Domain\Model\FileReference>
     * @TYPO3\CMS\Extbase\Annotation\ORM\Cascade("remove")
     */
    protected $file = null;

    /**
     * competences
     *
     * @var string
     */
    protected $competences = '';

    /**
     * diplomiert
     *
     * @var bool
     */
    protected $diplomiert = false;

    /**
     * hebamme
     *
     * @var bool
     */
    protected $hebamme = false;

    /**
     * dni
     *
     * @var bool
     */
    protected $dni = false;

    /**
     * fage
     *
     * @var bool
     */
    protected $fage = false;

    /**
     * fabe
     *
     * @var bool
     */
    protected $fabe = false;

    /**
     * ags
     *
     * @var bool
     */
    protected $ags = false;

    /**
     * assistent
     *
     * @var bool
     */
    protected $assistent = false;

    /**
     * otherJobMed
     *
     * @var bool
     */
    protected $otherJobMed = false;

    /**
     * otherJob
     *
     * @var bool
     */
    protected $otherJob = false;

    /**
     * coursNo
     *
     * @var string
     */
    protected $coursNo = '';

    /**
     * logoSbk
     *
     * @var bool
     */
    protected $logoSbk = false;

    /**
     * logoEduqua
     *
     * @var bool
     */
    protected $logoEduqua = false;

    /**
     * phone
     *
     * @var string
     */
    protected $phone = '';

    /**
     * fax
     *
     * @var string
     */
    protected $fax = '';

    /**
     * email
     *
     * @var string
     */
    protected $email = '';

    /**
     * adminEmail
     *
     * @var string
     */
    protected $adminEmail = '';

    /**
     * url
     *
     * @var string
     */
    protected $url = '';

    /**
     * active
     *
     * @var bool
     */
    protected $active = false;

    /**
     * contactPerson
     *
     * @var string
     */
    protected $contactPerson = '';

    /**
     * registrationUrl
     *
     * @var string
     */
    protected $registrationUrl = '';

    /**
     * detailUrl
     *
     * @var string
     */
    protected $detailUrl = '';

    /**
     * languageCode
     *
     * @var string
     */
    protected $languageCode = 0;

    /**
     * objective
     *
     * @var string
     */
    protected $objective = '';

    /**
     * company
     *
     * @var string
     */
    protected $company = '';

    /**
     * The registrations for the event
     *
     * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Ig\IgRuckzuckevent\Domain\Model\Registration>
     * @TYPO3\CMS\Extbase\Annotation\ORM\Lazy
     */
    //protected $registrations = null;


    /**
     * The organizer of the event
     *
     * @var \Internetgalerie\IgFrontendUser\Domain\Model\FrontendUser
     */
    protected $organizer = null;

    /**
     * The organizer of the event
     *
     * @var \Ig\IgRuckzuckevent\Domain\Model\Eventgroup
     */
    protected $eventgroup = null;

    /**
     * categories
     *
     * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Ig\IgRuckzuckevent\Domain\Model\Category>
     * @TYPO3\CMS\Extbase\Annotation\ORM\Lazy
     */
    protected $categories = null;

    /**
     * qualifications
     *
     * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Ig\IgRuckzuckevent\Domain\Model\Qualification>
     * @TYPO3\CMS\Extbase\Annotation\ORM\Lazy
     */
    protected $qualifications = null;

    /**
     * sponsors
     *
     * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Ig\IgRuckzuckevent\Domain\Model\Sponsor>
     * @TYPO3\CMS\Extbase\Annotation\ORM\Lazy
     */
    protected $sponsors = null;

    /**
     * organizers
     *
     * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Ig\IgRuckzuckevent\Domain\Model\Organizer>
     * @TYPO3\CMS\Extbase\Annotation\ORM\Lazy
     */
    protected $organizers = null;

    /**
     * isNew
     *
     * @var bool
     */
    protected $isNew = false;

    /**
     * meeting
     *
     * @var bool
     */
    protected $meeting = false;

    /**
     * eventOrganizer
     *
     * @var \Ig\IgRuckzuckevent\Domain\Model\Organizer
     */
    protected $eventOrganizer = null;

    /**
     * additionalFormFields
     *
     * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Ig\IgRuckzuckevent\Domain\Model\FormField>
     * @TYPO3\CMS\Extbase\Annotation\ORM\Cascade("remove")
     */
    protected $additionalFormFields = null;

    /**
     * pathSegment
     *
     * @var string
     */
    protected $pathSegment = '';

    /**
     * Registrations Count
     *
     * @var int
     */
    protected $registrationsCount = null;

    //protected $registrations;


    public function __construct()
    {
        //Do not remove the next line: It would break the functionality
        $this->initStorageObjects();
    }

    /**
     * @return bool
     * @throws NoSuchArgumentException
     * @throws \TYPO3\CMS\Core\Exception\SiteNotFoundException
     */
    public function _isNew(): bool
    {
        // run whatever Parent needs to do for this
        $isnew = parent::_isNew();
        if ($isnew && !$this->getPathSegment()) {
            // this is a new record, lets roll
            $this->makeSlug();
        }
        return $isnew;
    }

    /**
     * Initializes all ObjectStorage properties
     * Do not modify this method!
     * It will be rewritten on each save in the extension builder
     * You may modify the constructor of this class instead
     *
     * @return void
     */
    protected function initStorageObjects()
    {
        $this->images = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
        $this->file = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
        //$this->registrations = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
        $this->registrations = null;
        $this->categories = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
        $this->sponsors = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
        $this->organizers = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
        $this->additionalFormFields = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
    }

    /**
     * Returns the title
     *
     * @return string $title
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Sets the title
     *
     * @param string $title
     * @return void
     */
    public function setTitle($title)
    {
        $this->title = $title;
    }

    /**
     * Returns the teaser
     *
     * @return string $teaser
     */
    public function getTeaser()
    {
        return $this->teaser;
    }

    /**
     * Sets the teaser
     *
     * @param string $teaser
     * @return void
     */
    public function setTeaser($teaser)
    {
        $this->teaser = $teaser;
    }

    /**
     * Returns the description
     *
     * @return string $description
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Sets the description
     *
     * @param string $description
     * @return void
     */
    public function setDescription($description)
    {
        $this->description = $description;
    }

    /**
     * Returns the dateFrom
     *
     * @return \DateTime $dateFrom
     */
    public function getDateFrom()
    {
        return $this->dateFrom;
    }
    public function getDateFromFormatted()
    {
        if (!is_object($this->dateFrom)) {
            return '';
        }
        // Get the date and time from and format it accordingly
        if ($this->timeFrom) {
            $timelabel = LocalizationUtility::translate('timelabel', 'IgRuckzuckevent');
            return $this->getDateTimeFrom()->format('d.m.Y, H:i') . $timelabel;
        } else {
            return $this->getDateTimeFrom()->format('d.m.Y');
        }
    }

    public function getDateFromText()
    {
        return $this->dateFromLabel ?: $this->dateFrom;
    }

    /**
     * Sets the dateFrom
     *
     * @param \DateTime|null $dateFrom
     * @return void
     */
    public function setDateFrom($dateFrom)
    {
        $this->dateFrom = $dateFrom;
    }

    /**
     * Returns the timeFrom
     *
     * @return string $timeFrom
     */
    public function getTimeFrom()
    {
        return $this->timeFrom;
    }
    public function getTimeFromHour()
    {
        return explode(':', $this->getTimeFrom())[0];
    }
    public function getTimeFromMinute()
    {
        return explode(':', $this->getTimeFrom())[1];
    }
    public function getTimeFromText()
    {
        if (!$this->getTimeFrom()) {
            return null;
        }
        $ret = new \DateTime();
        $ret->setTime($this->getTimeFromHour(), $this->getTimeFromMinute(), 0);
        return $ret->format('H:i');
    }
    /**
     * Returns the inPast
     *
     * @return boolean $inPast
     */
    public function getIsDateFromInPast()
    {
        $now = new \DateTime();
        $now->setTime(0, 0, 0);
        return $this->dateFrom < $now; //->diff(new \DateTime())>0;
    }

    /**
     * Sets the timeFrom
     *
     * @param \DateTime $timeFrom
     * @return void
     */
    public function setTimeFrom($timeFrom = null)
    {
        $this->timeFrom = $timeFrom;
    }

    /**
     * Returns the dateTo
     *
     * @return \DateTime $dateTo
     */
    public function getDateTo()
    {
        return $this->dateTo;
    }
    public function getDateToText()
    {
        return $this->dateToLabel ?: $this->dateTo;
    }
    public function getDateToFormatted()
    {
        if (!is_object($this->dateTo)) {
            return '';
        }
        // If we have set a time to we have to check if we have set the date to too
        if ($this->timeTo) {
            // If we have set the date to too and if it is not the same as the date from,
            // we are going to output date and time to formatted accordingly, else just the time
            $timelabel = LocalizationUtility::translate('timelabel', 'IgRuckzuckevent');
            if ($this->dateTo != $this->dateFrom) {
                return $this->getDateTimeTo()->format('d.m.Y, H:i') . $timelabel;
            } else {
                return $this->getDateTimeTo()->format('H:i') . $timelabel;
            }
        }
        if ($this->dateTo && $this->dateTo != $this->dateFrom) {
            return $this->getDateTimeTo()->format('d.m.Y');
        }
        return '';
    }

    /**
     * Sets the dateTo
     *
     * @param \DateTime|null $dateTo
     * @return void
     */
    public function setDateTo($dateTo)
    {
        $this->dateTo = $dateTo;
    }

    /**
     * Returns the timeTo
     *
     * @return string $timeTo
     */
    public function getTimeTo()
    {
        return $this->timeTo;
    }

    public function getTimeToHour()
    {
        return explode(':', $this->getTimeTo())[0];
    }
    public function getTimeToMinute()
    {
        return explode(':', $this->getTimeTo())[1];
    }

    public function getTimeToText()
    {
        if (!$this->getTimeTo()) {
            return null;
        }
        $ret = new \DateTime();
        $ret->setTime($this->getTimeToHour(), $this->getTimeToMinute(), 0);
        return $ret->format('H.i');
    }

    /**
     * Sets the timeTo
     *
     * @param \DateTime $timeTo
     * @return void
     */
    public function setTimeTo($timeTo = null)
    {
        $this->timeTo = $timeTo;
    }

    /**
     * Returns the street
     *
     * @return string $street
     */
    public function getStreet()
    {
        return $this->street;
    }

    /**
     * Sets the street
     *
     * @param string $street
     * @return void
     */
    public function setStreet($street)
    {
        $this->street = $street;
    }

    /**
     * Returns the address2
     *
     * @return string $address2
     */
    public function getAddress2()
    {
        return $this->address2;
    }

    /**
     * Sets the address2
     *
     * @param string $address2
     * @return void
     */
    public function setAddress2($address2)
    {
        $this->address2 = $address2;
    }

    /**
     * Returns the zip
     *
     * @return string $zip
     */
    public function getZip()
    {
        return $this->zip;
    }

    /**
     * Sets the zip
     *
     * @param string $zip
     * @return void
     */
    public function setZip($zip)
    {
        $this->zip = $zip;
    }

    /**
     * Returns the city
     *
     * @return string $city
     */
    public function getCity()
    {
        return $this->city;
    }

    /**
     * Sets the city
     *
     * @param string $city
     * @return void
     */
    public function setCity($city)
    {
        $this->city = $city;
    }

    /**
     * Returns the country
     *
     * @return string $country
     */
    public function getCountry()
    {
        return $this->country;
    }

    /**
     * Sets the country
     *
     * @param string $country
     * @return void
     */
    public function setCountry($country)
    {
        $this->country = $country;
    }

    /**
     * Returns the dateDeadline
     *
     * @return string $dateDeadline
     */
    public function getDateDeadline()
    {
        return $this->dateDeadline;
    }
    public function getIsBeforeDeadline()
    {
        $now = new \DateTime();
        return $this->dateDeadline &&  $this->dateDeadline->getTimestamp() + 86400 - $now->getTimestamp() > 0;
    }

    /**
     * Sets the dateDeadline
     *
     * @param \DateTime|null $dateDeadline
     * @return void
     */
    public function setDateDeadline($dateDeadline)
    {
        $this->dateDeadline = $dateDeadline;
    }

    /**
     * Returns the timeDeadline
     *
     * @return \DateTime $timeDeadline
     */
    public function getTimeDeadline()
    {
        return $this->timeDeadline;
    }

    /**
     * Sets the timeDeadline
     *
     * @param \DateTime $timeDeadline
     * @return void
     */
    public function setTimeDeadline($timeDeadline = null)
    {
        $this->timeDeadline = $timeDeadline;
    }

    /**
     * Returns the minRegistrations
     *
     * @return int $minRegistrations
     */
    public function getMinRegistrations()
    {
        return $this->minRegistrations;
    }

    /**
     * Sets the minRegistrations
     *
     * @param int $minRegistrations
     * @return void
     */
    public function setMinRegistrations($minRegistrations)
    {
        $this->minRegistrations = $minRegistrations;
    }

    /**
     * Returns the maxRegistrations
     *
     * @return int $maxRegistrations
     */
    public function getMaxRegistrations()
    {
        return $this->maxRegistrations;
    }

    /**
     * Sets the maxRegistrations
     *
     * @param int $maxRegistrations
     * @return void
     */
    public function setMaxRegistrations($maxRegistrations)
    {
        $this->maxRegistrations = $maxRegistrations;
    }

    /**
     * Returns the registrationsPossible
     *
     * @return bool $registrationsPossible
     */
    public function getRegistrationsPossible()
    {
        return $this->registrationsPossible;
    }

    /**
     * Sets the registrationsPossible
     *
     * @param bool $registrationsPossible
     * @return void
     */
    public function setRegistrationsPossible($registrationsPossible)
    {
        $this->registrationsPossible = $registrationsPossible;
    }

    /**
     * Returns the boolean state of registrationsPossible
     *
     * @return bool
     */
    public function isRegistrationsPossible()
    {
        return $this->registrationsPossible;
    }

    /**
     * Returns the price
     *
     * @return float $price
     */
    public function getPrice()
    {
        return $this->price;
    }

    /**
     * Sets the price
     *
     * @param float $price
     * @return void
     */
    public function setPrice($price)
    {
        $this->price = $price;
    }

    /**
     * Returns the images
     *
     * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\TYPO3\CMS\Extbase\Domain\Model\FileReference> $images
     */
    public function getImages()
    {
        return $this->images;
    }

    /**
     * Sets the images
     *
     * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\TYPO3\CMS\Extbase\Domain\Model\FileReference> $images
     * @return void
     */
    public function setImages(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $images)
    {
        $this->images = $images;
    }

    /**
     * Adds an image
     *
     * @param \TYPO3\CMS\Extbase\Domain\Model\FileReference $image
     * @return void
     */
    public function addImage(\TYPO3\CMS\Extbase\Domain\Model\FileReference $image)
    {
        $this->images->attach($image);
    }

    /**
     * Removes an image
     *
     * @param \TYPO3\CMS\Extbase\Domain\Model\FileReference $imageToRemove The Image to be removed
     * @return void
     */
    public function removeImage(\TYPO3\CMS\Extbase\Domain\Model\FileReference $imageToRemove)
    {
        $this->images->detach($imageToRemove);
    }

    /**
     * Returns the registrations
     *
     * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Ig\IgRuckzuckevent\Domain\Model\Registration> $registrations
     */
    public function getRegistrations()
    {
        if (!$this->registrations) {
            $registrationRepository = GeneralUtility::makeInstance(RegistrationRepository::class);
            $this->registrations = $registrationRepository->findByEvent($this);
        }
        return $this->registrations;
    }
    public function getRegistrationsCount()
    {
        if ($this->registrationsCount === null) {
            $registrationRepository = GeneralUtility::makeInstance(RegistrationRepository::class);
            $this->registrationsCount = $registrationRepository->countByEvent($this);
        }
        return $this->registrationsCount;
    }
    /**
     * Sets the registrations
     *
     * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Ig\IgRuckzuckevent\Domain\Model\Registration> $registrations
     * @return void
     */
    public function setRegistrations(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $registrations)
    {
        $this->registrations = $registrations;
    }

    /**
     * Returns the organizer
     *
     * @return \Internetgalerie\IgFrontendUser\Domain\Model\FrontendUser $organizer
     */
    public function getOrganizer()
    {
        return $this->organizer;
    }

    /**
     * Sets the organizer
     *
     * @param \Internetgalerie\IgFrontendUser\Domain\Model\FrontendUser $organizer
     * @return void
     */
    public function setOrganizer(\Internetgalerie\IgFrontendUser\Domain\Model\FrontendUser $organizer = null)
    {
        $this->organizer = $organizer;
    }

    /**
     * Returns the eventgroup
     *
     * @return \Ig\IgRuckzuckevent\Domain\Model\Eventgroup $eventgroup
     */
    public function getEventgroup()
    {
        return $this->eventgroup;
    }

    /**
     * Sets the eventgroup
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\Eventgroup $eventgroup
     * @return void
     */
    public function setEventgroup(\Ig\IgRuckzuckevent\Domain\Model\Eventgroup $eventgroup = null)
    {
        $this->eventgroup = $eventgroup;
    }

    /**
     * Returns the combined date and time for the start of the event
     *
     * @return \DateTime $dateTimeFrom
     */
    public function getDateTimeFrom()
    {
        if ($this->dateFrom && $this->timeFrom) {
            $dateTimeFrom = new \DateTime($this->dateFrom->format('Y-m-d') . 'T' . $this->timeFrom); //->format('H:i:s'));
            return $dateTimeFrom;
        } else {
            if ($this->dateFrom) {
                $dateTimeFrom = clone $this->dateFrom;
                $dateTimeFrom->setTime(0, 0, 0);
                return $dateTimeFrom;
            }
        }
        return null;
    }

    /**
     * Returns the combined date and time for the end of the event
     *
     * @return \DateTime $dateTimeTo
     */
    public function getDateTimeTo()
    {
        if ($this->timeTo) {
            if (!$this->dateTo || $this->dateTo == $this->dateFrom) {
                $dateTimeEnd = new \DateTime($this->dateFrom->format('Y-m-d') . 'T' . $this->timeTo); //->format('H:i:s'));
            } elseif ($this->dateTo) {
                $dateTimeEnd = new \DateTime($this->dateTo->format('Y-m-d') . 'T' . $this->timeTo); //->format('H:i:s'));
            }
            return $dateTimeEnd;
        } elseif ($this->dateTo) {
            return $this->dateTo;
        }
        return null;
    }

    /**
     * Returns the date and time string for the output
     *
     * @return string $date
     */
    public function getDate()
    {
        $dateFromString = $this->getDateFromFormatted();
        $dateToString = $this->getDateToFormatted();
        return $dateFromString . ($dateToString ? ' - ' . $dateToString : '');
    }

    public function getDateText()
    {
        if ($this->datetimelabel) {
            return $this->datetimelabel;
        }
        $dateFromString = $this->dateFromLabel ?: $this->getDateFromFormatted();

        $dateToString = $this->dateToLabel ?: $this->getDateToFormatted();
        return $dateFromString . ($dateToString ? ' - ' . $dateToString : '');
    }

    /**
     * Returns the combined date and time for the deadline for registrations
     *
     * @return \DateTime $dateTimeDeadline
     */
    public function getDateTimeDeadline()
    {
        $dateTimeDeadline = null;
        if ($this->dateDeadline && $this->timeDeadline) {
            $dateTimeDeadline = new \DateTime($this->dateDeadline->format('Y-m-d') . 'T' . $this->timeDeadline); //->format('H:i:s'));
        } else {
            if ($this->dateDeadline) {
                $dateTimeDeadline = clone $this->dateDeadline;
                $dateTimeDeadline->setTime(0, 0, 0);
            }
        }
        return $dateTimeDeadline;
    }

    /**
     * Returns the deadline string for the output
     *
     * @return string $date
     */
    public function getDeadline()
    {
        $dateTimeDeadline = $this->getDateTimeDeadline();
        if ($dateTimeDeadline) {
            $deadline = $this->getDateTimeDeadline()->format('d.m.y H:i');
        }
        return $deadline;
    }

    /**
     * Returns true if the deadline has been reached
     *
     * @return bool
     */
    public function getDeadlineReached()
    {
        $dateTimeDeadline = $this->getDateTimeDeadline();
        if ($dateTimeDeadline) {
            $now = new \DateTime();
            return $this->getDateTimeDeadline() < $now;
        }
        return false;
    }

    /**
     * Returns the event state telling if already the maximum of registrations is reached
     * or if there are too less registrations
     *
     * @return string $state The state as a string
     */
    public function getState()
    {
        if ($this->registrationsPossible) {
            // If we reached the deadline, the state is "deadline reached"
            if ($this->getDeadlineReached()) {
                return 'deadlineReached';
            }
            // If there are no limits set, registrations are possible
            if ($this->minRegistrations == 0 && $this->maxRegistrations == 0 && !$this->bookedOut) {
                return 'registrationsPossible';
            }
            // If we reached the maximum of registrations, the state is "booked up"
            if (($this->maxRegistrations > 0 && $this->getFreePlaces() == 0) || $this->bookedOut) {
                return 'bookedUp';
            }
            // If we don't have enought registrations, the state is "not enough registrations"
            if ($this->registrations->count() < $this->minRegistrations) {
                return 'notEnoughRegistrations';
            }
            // If there are enough registrations but still more possible, the state is "registrations possible"
            if ($this->registrations->count() >= $this->minRegistrations && $this->registrations->count() < $this->maxRegistrations) {
                return 'registrationsPossible';
            }
        }
        // If no registrations are possible anyway, the state is "no registrations possible"
        return 'noRegistrationsPossible';
    }
    public function getIsRegistrationActive(): bool
    {
        if (!$this->registrationsPossible) {
            return false;
        }
        if ($this->bookedOut || $this->postponed || $this->canceled) {
            return false;
        }
        if ($this->getDeadlineReached()) {
            return false;
        }
        if ($this->maxRegistrations > 0 && $this->getFreePlaces() == 0) {
            return false;
        }
        return true;
    }

    /**
     * Returns the subtitle
     *
     * @return string $subtitle
     */
    public function getSubtitle()
    {
        return $this->subtitle;
    }

    /**
     * Sets the subtitle
     *
     * @param string $subtitle
     * @return void
     */
    public function setSubtitle($subtitle)
    {
        $this->subtitle = $subtitle;
    }

    /**
     * Returns the targetgroup
     *
     * @return string $targetgroup
     */
    public function getTargetgroup()
    {
        return $this->targetgroup;
    }

    /**
     * Sets the targetgroup
     *
     * @param string $targetgroup
     * @return void
     */
    public function setTargetgroup($targetgroup)
    {
        $this->targetgroup = $targetgroup;
    }

    /**
     * Returns the targets
     *
     * @return string $targets
     */
    public function getTargets()
    {
        return $this->targets;
    }

    /**
     * Sets the targets
     *
     * @param string $targets
     * @return void
     */
    public function setTargets($targets)
    {
        $this->targets = $targets;
    }

    /**
     * Returns the contents
     *
     * @return string $contents
     */
    public function getContents()
    {
        return $this->contents;
    }

    /**
     * Sets the contents
     *
     * @param string $contents
     * @return void
     */
    public function setContents($contents)
    {
        $this->contents = $contents;
    }

    /**
     * Returns the workingmethods
     *
     * @return string $workingmethods
     */
    public function getWorkingmethods()
    {
        return $this->workingmethods;
    }

    /**
     * Sets the workingmethods
     *
     * @param string $workingmethods
     * @return void
     */
    public function setWorkingmethods($workingmethods)
    {
        $this->workingmethods = $workingmethods;
    }

    /**
     * Returns the numParticipants
     *
     * @return int $numParticipants
     */
    public function getNumParticipants()
    {
        return $this->numParticipants;
    }

    /**
     * Sets the numParticipants
     *
     * @param int $numParticipants
     * @return void
     */
    public function setNumParticipants($numParticipants)
    {
        $this->numParticipants = $numParticipants;
    }

    /**
     * Returns the courseOrganizer
     *
     * @return string $courseOrganizer
     */
    public function getCourseOrganizer()
    {
        return $this->courseOrganizer;
    }

    /**
     * Sets the courseOrganizer
     *
     * @param string $courseOrganizer
     * @return void
     */
    public function setCourseOrganizer($courseOrganizer)
    {
        $this->courseOrganizer = $courseOrganizer;
    }

    /**
     * Returns the datetimelabel
     *
     * @return string $datetimelabel
     */
    public function getDatetimelabel()
    {
        return $this->datetimelabel;
    }

    /**
     * Sets the datetimelabel
     *
     * @param string $datetimelabel
     * @return void
     */
    public function setDatetimelabel($datetimelabel)
    {
        $this->datetimelabel = $datetimelabel;
    }

    /**
     * Returns the dateFromLabel
     *
     * @return string $dateFromLabel
     */
    public function getDateFromLabel()
    {
        return $this->dateFromLabel;
    }

    /**
     * Sets the dateFromLabel
     *
     * @param string $dateFromLabel
     * @return void
     */
    public function setDateFromLabel($dateFromLabel)
    {
        $this->dateFromLabel = $dateFromLabel;
    }

    /**
     * Returns the dateToLabel
     *
     * @return string $dateToLabel
     */
    public function getDateToLabel()
    {
        return $this->dateToLabel;
    }

    /**
     * Sets the dateToLabel
     *
     * @param string $dateToLabel
     * @return void
     */
    public function setDateToLabel($dateToLabel)
    {
        $this->dateToLabel = $dateToLabel;
    }

    /**
     * Returns the duration
     *
     * @return string $duration
     */
    public function getDuration()
    {
        return $this->duration;
    }

    /**
     * Sets the duration
     *
     * @param string $duration
     * @return void
     */
    public function setDuration($duration)
    {
        $this->duration = $duration;
    }

    /**
     * Returns the place
     *
     * @return string $place
     */
    public function getPlace()
    {
        return $this->place;
    }

    public function getPlaceSingleLine()
    {
        return strip_tags(str_replace("\n", ',', trim(preg_replace('/\<br(\s*)?\/?\>/i', "\n", $this->getPlace()))));
    }

    /**
     * Sets the place
     *
     * @param string $place
     * @return void
     */
    public function setPlace($place)
    {
        $this->place = $place;
    }

    /**
     * Returns the costs
     *
     * @return string $costs
     */
    public function getCosts()
    {
        return $this->costs;
    }

    /**
     * Sets the costs
     *
     * @param string $costs
     * @return void
     */
    public function setCosts($costs)
    {
        $this->costs = $costs;
    }

    /**
     * Returns the file
     *
     * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\TYPO3\CMS\Extbase\Domain\Model\FileReference> $file
     */
    public function getFile()
    {
        return $this->file;
    }

    /**
     * Sets the file
     *
     * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\TYPO3\CMS\Extbase\Domain\Model\FileReference> $file
     * @return void
     */
    public function setFile(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $file)
    {
        $this->file = $file;
    }

    /**
     * Adds an file
     *
     * @param \TYPO3\CMS\Extbase\Domain\Model\FileReference $file
     * @return void
     */
    public function addFile(\TYPO3\CMS\Extbase\Domain\Model\FileReference $file)
    {
        $this->file->attach($file);
    }

    /**
     * Removes an file
     *
     * @param \TYPO3\CMS\Extbase\Domain\Model\FileReference $fileToRemove The file to be removed
     * @return void
     */
    public function removeFile(\TYPO3\CMS\Extbase\Domain\Model\FileReference $fileToRemove)
    {
        $this->file->detach($fileToRemove);
    }

    /**
     * Returns the competences
     *
     * @return string $competences
     */
    public function getCompetences()
    {
        return $this->competences;
    }

    /**
     * Sets the competences
     *
     * @param string $competences
     * @return void
     */
    public function setCompetences($competences)
    {
        $this->competences = $competences;
    }

    /**
     * Returns the diplomiert
     *
     * @return bool $diplomiert
     */
    public function getDiplomiert()
    {
        return $this->diplomiert;
    }

    /**
     * Sets the diplomiert
     *
     * @param bool $diplomiert
     * @return void
     */
    public function setDiplomiert($diplomiert)
    {
        $this->diplomiert = $diplomiert;
    }

    /**
     * Returns the boolean state of diplomiert
     *
     * @return bool
     */
    public function isDiplomiert()
    {
        return $this->diplomiert;
    }

    /**
     * Returns the coursNo
     *
     * @return string $coursNo
     */
    public function getCoursNo()
    {
        return $this->coursNo;
    }

    /**
     * Sets the coursNo
     *
     * @param string $coursNo
     * @return void
     */
    public function setCoursNo($coursNo)
    {
        $this->coursNo = $coursNo;
    }

    /**
     * Returns the note
     *
     * @return string note
     */
    public function getNote()
    {
        return $this->note;
    }

    /**
     * Sets the note
     *
     * @param string $note
     * @return void
     */
    public function setNote($note)
    {
        $this->note = $note;
    }

    /**
     * Adds a Sponsor
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\Sponsor $sponsor
     * @return void
     */
    public function addSponsor(\Ig\IgRuckzuckevent\Domain\Model\Sponsor $sponsor)
    {
        $this->sponsors->attach($sponsor);
    }

    /**
     * Removes a Sponsor
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\Sponsor $sponsorToRemove The Sponsor to be removed
     * @return void
     */
    public function removeSponsor(\Ig\IgRuckzuckevent\Domain\Model\Sponsor $sponsorToRemove)
    {
        $this->sponsors->detach($sponsorToRemove);
    }

    /**
     * Returns the sponsors
     *
     * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Ig\IgRuckzuckevent\Domain\Model\Sponsor> $sponsors
     */
    public function getSponsors()
    {
        return $this->sponsors;
    }

    /**
     * Sets the sponsors
     *
     * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Ig\IgRuckzuckevent\Domain\Model\Sponsor> $sponsors
     * @return void
     */
    public function setSponsors(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $sponsors)
    {
        $this->sponsors = $sponsors;
    }

    /**
     * Returns the logoSbk
     *
     * @return bool $logoSbk
     */
    public function getLogoSbk()
    {
        return $this->logoSbk;
    }

    /**
     * Sets the logoSbk
     *
     * @param bool $logoSbk
     * @return void
     */
    public function setLogoSbk($logoSbk)
    {
        $this->logoSbk = $logoSbk;
    }

    /**
     * Returns the boolean state of logoSbk
     *
     * @return bool
     */
    public function isLogoSbk()
    {
        return $this->logoSbk;
    }

    /**
     * Returns the logoEduqua
     *
     * @return bool $logoEduqua
     */
    public function getLogoEduqua()
    {
        return $this->logoEduqua;
    }

    /**
     * Sets the logoEduqua
     *
     * @param bool $logoEduqua
     * @return void
     */
    public function setLogoEduqua($logoEduqua)
    {
        $this->logoEduqua = $logoEduqua;
    }

    /**
     * Returns the boolean state of logoEduqua
     *
     * @return bool
     */
    public function isLogoEduqua()
    {
        return $this->logoEduqua;
    }

    /**
     * Returns the phone
     *
     * @return string $phone
     */
    public function getPhone()
    {
        return $this->phone;
    }

    /**
     * Sets the phone
     *
     * @param string $phone
     * @return void
     */
    public function setPhone($phone)
    {
        $this->phone = $phone;
    }

    /**
     * Returns the fax
     *
     * @return string $fax
     */
    public function getFax()
    {
        return $this->fax;
    }

    /**
     * Sets the fax
     *
     * @param string $fax
     * @return void
     */
    public function setFax($fax)
    {
        $this->fax = $fax;
    }

    /**
     * Returns the email
     *
     * @return string $email
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * Sets the email
     *
     * @param string $email
     * @return void
     */
    public function setEmail($email)
    {
        $this->email = $email;
    }

    /**
     * Returns the adminEmail
     *
     * @return string $adminEmail
     */
    public function getAdminEmail()
    {
        return $this->adminEmail;
    }

    /**
     * Sets the adminEmail
     *
     * @param string $adminEmail
     * @return void
     */
    public function setAdminEmail($adminEmail)
    {
        $this->adminEmail = $adminEmail;
    }

    /**
     * Returns the url
     *
     * @return string $url
     */
    public function getUrl()
    {
        return $this->url;
    }

    /**
     * Sets the url
     *
     * @param string $url
     * @return void
     */
    public function setUrl($url)
    {
        $this->url = $url;
    }

    /**
     * Returns the active
     *
     * @return bool $active
     */
    public function getActive()
    {
        return $this->active;
    }

    /**
     * Sets the active
     *
     * @param bool $active
     * @return void
     */
    public function setActive($active)
    {
        $this->active = $active;
    }

    /**
     * Returns the boolean state of active
     *
     * @return bool
     */
    public function isActive()
    {
        return $this->active;
    }

    /**
     * Returns the contactPerson
     *
     * @return string $contactPerson
     */
    public function getContactPerson()
    {
        return $this->contactPerson;
    }

    /**
     * Sets the contactPerson
     *
     * @param string $contactPerson
     * @return void
     */
    public function setContactPerson($contactPerson)
    {
        $this->contactPerson = $contactPerson;
    }

    /**
     * Returns the registrationUrl
     *
     * @return string $registrationUrl
     */
    public function getRegistrationUrl()
    {
        return $this->registrationUrl;
    }
    /**
     * Returns the registrationUrl if needed add http://
     *
     * @return string $registrationUrl
     */
    public function getRegistrationUrlFull()
    {
        return strpos($this->registrationUrl, '://') > 0 ? $this->registrationUrl : 'http://' . $this->registrationUrl;
    }

    /**
     * Sets the registrationUrl
     *
     * @param string $registrationUrl
     * @return void
     */
    public function setRegistrationUrl($registrationUrl)
    {
        $this->registrationUrl = $registrationUrl;
    }

    /**
     * Returns the detailUrl
     *
     * @return string $detailUrl
     */
    public function getDetailUrl()
    {
        return $this->detailUrl;
    }

    /**
     * Sets the detailUrl
     *
     * @param string $detailUrl
     * @return void
     */
    public function setDetailUrl($detailUrl)
    {
        $this->detailUrl = $detailUrl;
    }

    /**
     * Returns the languageCode
     *
     * @return string $languageCode
     */
    public function getLanguageCode()
    {
        return $this->languageCode;
    }

    public function getLanguageText()
    {
        switch ($this->languageCode) {
            case 'de':
                return 'Deutsch';
            case 'fr':
                return 'Français';
            case 'en':
                return 'English';
            default:
                return 'andere';
        }
    }

    /**
     * Sets the languageCode
     *
     * @param string $languageCode
     * @return void
     */
    public function setLanguageCode($languageCode)
    {
        $this->languageCode = $languageCode;
    }

    /**
     * Returns the objective
     *
     * @return string $objective
     */
    public function getObjective()
    {
        return $this->objective;
    }

    /**
     * Sets the objective
     *
     * @param string $objective
     * @return void
     */
    public function setObjective($objective)
    {
        $this->objective = $objective;
    }

    /**
     * Returns the company
     *
     * @return string $company
     */
    public function getCompany()
    {
        return $this->company;
    }

    /**
     * Sets the company
     *
     * @param string $company
     * @return void
     */
    public function setCompany($company)
    {
        $this->company = $company;
    }

    /**
     * Adds a Category
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\Category $category
     * @return void
     */
    public function addCategory(\Ig\IgRuckzuckevent\Domain\Model\Category $category)
    {
        $this->categories->attach($category);
    }

    /**
     * Removes a Category
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\Category $categoryToRemove The Category to be removed
     * @return void
     */
    public function removeCategory(\Ig\IgRuckzuckevent\Domain\Model\Category $categoryToRemove)
    {
        $this->categories->detach($categoryToRemove);
    }

    /**
     * Returns the categories
     *
     * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Ig\IgRuckzuckevent\Domain\Model\Category> $categories
     */
    public function getCategories()
    {
        return $this->categories;
    }

    /**
     * Sets the categories
     *
     * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Ig\IgRuckzuckevent\Domain\Model\Category> $categories
     * @return void
     */
    public function setCategories(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $categories)
    {
        $this->categories = $categories;
    }

    /**
     * Sets the isNew
     *
     * @param bool $isNew
     * @return void
     */
    public function setIsNew($isNew)
    {
        $this->isNew = $isNew;
    }

    /**
     * Returns the isNew
     *
     * @return bool $isNew
     */
    public function isIsNew()
    {
        return $this->isNew;
    }

    /**
     * Returns the eventOrganizer
     *
     * @return \Ig\IgRuckzuckevent\Domain\Model\Organizer $eventOrganizer
     */
    public function getEventOrganizer()
    {
        return $this->eventOrganizer;
    }

    /**
     * Sets the eventOrganizer
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\Organizer $eventOrganizer
     * @return void
     */
    public function setEventOrganizer(\Ig\IgRuckzuckevent\Domain\Model\Organizer $eventOrganizer)
    {
        $this->eventOrganizer = $eventOrganizer;
    }

    public function getFreePlaces()
    {
        $freePlaces = $this->getMaxRegistrations() - (int)$this->getRegistrations()->count();
        return $freePlaces > 0 ? $freePlaces : 0;
    }

    /**
     * Sets the pathSegment
     *
     * @param string $pathSegment
     */
    public function setPathSegment($pathSegment)
    {
        $this->pathSegment = $pathSegment;
    }

    /**
     * Returns the pathSegment
     *
     * @return string $pathSegment
     */
    public function getPathSegment()
    {
        return $this->pathSegment;
    }

    /**
     * Adds a FormField
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\FormField $additionalFormField
     * @return void
     */
    public function addAdditionalFormField(\Ig\IgRuckzuckevent\Domain\Model\FormField $additionalFormField)
    {
        $this->additionalFormFields->attach($additionalFormField);
    }

    /**
     * Removes a FormField
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\FormField $additionalFormFieldToRemove The FormField to be removed
     * @return void
     */
    public function removeAdditionalFormField(\Ig\IgRuckzuckevent\Domain\Model\FormField $additionalFormFieldToRemove)
    {
        $this->additionalFormFields->detach($additionalFormFieldToRemove);
    }

    /**
     * Returns the additionalFormFields
     *
     * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Ig\IgRuckzuckevent\Domain\Model\FormField> $additionalFormFields
     */
    public function getAdditionalFormFields()
    {
        return $this->additionalFormFields;
    }

    /**
     * Sets the additionalFormFields
     *
     * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Ig\IgRuckzuckevent\Domain\Model\FormField> $additionalFormFields
     * @return void
     */
    public function setAdditionalFormFields(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $additionalFormFields)
    {
        $this->additionalFormFields = $additionalFormFields;
    }

    /**
     * @throws \TYPO3\CMS\Core\Exception\SiteNotFoundException
     */
    public function makeSlug($value = ''): void
    {
        if (\TYPO3\CMS\Core\Utility\VersionNumberUtility::convertVersionNumberToInteger(\TYPO3\CMS\Core\Utility\VersionNumberUtility::getNumericTypo3Version()) < 9000000) {
            return;
        }

        // we assume TCA is loaded, should be true for anything greater Typo3 7
        $tcaConfig = $GLOBALS['TCA']['tx_igruckzuckevent_domain_model_event']['columns']['path_segment']['config'];

        $helper = GeneralUtility::makeInstance(SlugHelper::class, 'tx_igruckzuckevent_domain_model_event', 'path_segment', $tcaConfig, 0);

        // get the whole model so far as an array, keys in camelCase
        $properties = $this->_getProperties();
        $record = [];

        //convert the camelCase Properties into something that resembles the incomingFieldArray
        //used by the DataHandler faciliy
        foreach ($properties as $k => $v) {
            $field = GeneralUtility::camelCaseToLowerCaseUnderscored($k);
            // simple relation resolver with uid. we just want to prevent hickups
            $v = \is_object($v) && \method_exists($v, 'getUid') ? $v->getUid() : $v;
            //populate the record array
            $record[$field] = $v;
        }

        $pid = (int) $this->getPid() > 0 ? (int) $this->getPid() : 1; // defintion of realPid


        if (!$value) {
            // we do not use Workspaces for this, this is frontend
            $value = $helper->generate($record, $pid);
        }

        // get state Object
        $state = RecordStateFactory::forName('tx_igruckzuckevent_domain_model_event')
            ->fromArray($record, $pid, (!$this->getUid() ? 'NEW' : $this->getUid()));

        $evalCodesArray = GeneralUtility::trimExplode(',', $tcaConfig['eval'], true);

        if (in_array('unique', $evalCodesArray, true)) {
            $value = $helper->buildSlugForUniqueInTable($value, $state);
        }
        if (in_array('uniqueInSite', $evalCodesArray, true)) {
            $value = $helper->buildSlugForUniqueInSite($value, $state);
        }
        if (in_array('uniqueInPid', $evalCodesArray, true)) {
            $value = $helper->buildSlugForUniqueInPid($value, $state);
        }

        // generate the path segment field in camelcase notation
        $this->pathSegment = $value;
    }

    /**
     * Get the value of meeting
     *
     * @return bool
     */
    public function getMeeting()
    {
        return $this->meeting;
    }

    /**
     * Set the value of meeting
     *
     * @param bool $meeting
     *
     * @return self
     */
    public function setMeeting($meeting)
    {
        $this->meeting = $meeting;

        return $this;
    }
    public function getDay()
    {
        return $this->getDateFrom()->format('w');
    }
    public function getIsoDay()
    {
        return $this->getDateFrom()->format('N');
    }

    public function getDaytime()
    {
        /*
        $timeFrom = new \DateTime();
          $timeFrom->setTimestamp($this->timeFrom);
          $hour = new \DateTime($timeFrom->format('H.i'));
    */
        $hour = explode(':', $this->getTimeFrom())[0];
        if ($hour < 12) {
            return 'morning';
        }
        if ($hour < 17) {
            return 'afternoon';
        }
        return 'eve';
    }

    /**
     * Get the value of fage
     *
     * @return bool
     */
    public function getFage()
    {
        return $this->fage;
    }

    /**
     * Set the value of fage
     *
     * @param bool $fage
     *
     * @return self
     */
    public function setFage($fage)
    {
        $this->fage = $fage;

        return $this;
    }

    /**
     * Get the value of ags
     *
     * @return bool
     */
    public function getAgs()
    {
        return $this->ags;
    }

    /**
     * Set the value of ags
     *
     * @param bool $ags
     *
     * @return self
     */
    public function setAgs($ags)
    {
        $this->ags = $ags;

        return $this;
    }

    /**
     * Get the value of assistent
     *
     * @return bool
     */
    public function getAssistent()
    {
        return $this->assistent;
    }

    /**
     * Set the value of assistent
     *
     * @param bool $assistent
     *
     * @return self
     */
    public function setAssistent($assistent)
    {
        $this->assistent = $assistent;

        return $this;
    }


    /**
     * Get the value of hebamme
     *
     * @return bool
     */
    public function getHebamme()
    {
        return $this->hebamme;
    }

    /**
     * Set the value of hebamme
     *
     * @param bool $hebamme
     *
     * @return self
     */
    public function setHebamme($hebamme)
    {
        $this->hebamme = $hebamme;

        return $this;
    }

    /**
     * Get the value of dni
     *
     * @return bool
     */
    public function getDni()
    {
        return $this->dni;
    }

    /**
     * Set the value of dni
     *
     * @param bool $dni
     *
     * @return self
     */
    public function setDni($dni)
    {
        $this->dni = $dni;

        return $this;
    }

    /**
     * Get the value of fabe
     *
     * @return bool
     */
    public function getFabe()
    {
        return $this->fabe;
    }

    /**
     * Set the value of fabe
     *
     * @param bool $fabe
     *
     * @return self
     */
    public function setFabe($fabe)
    {
        $this->fabe = $fabe;

        return $this;
    }

    /**
     * Get the value of otherJobMed
     *
     * @return bool
     */
    public function getOtherJobMed()
    {
        return $this->otherJobMed;
    }

    /**
     * Set the value of otherJobMed
     *
     * @param bool $otherJobMed
     *
     * @return self
     */
    public function setOtherJobMed($otherJobMed)
    {
        $this->otherJobMed = $otherJobMed;

        return $this;
    }

    /**
     * Get the value of otherJob
     *
     * @return bool
     */
    public function getOtherJob()
    {
        return $this->otherJob;
    }

    /**
     * Set the value of otherJob
     *
     * @param bool $otherJob
     *
     * @return self
     */
    public function setOtherJob($otherJob)
    {
        $this->otherJob = $otherJob;

        return $this;
    }


    /**
     * Get the value of Booked out
     *
     * @return boolean
     */
    public function getBookedOut()
    {
        return $this->bookedOut;
    }

    /**
     * Set the value of Booked out
     *
     * @param boolean $bookedOut
     *
     * @return self
     */
    public function setBookedOut($bookedOut)
    {
        $this->bookedOut = $bookedOut;

        return $this;
    }

    /**
     * Get the value of Registrations Info
     *
     * @return string
     */
    public function getRegistrationsInfo()
    {
        return $this->registrationsInfo;
    }

    /**
     * Set the value of Registrations Info
     *
     * @param string $registrationsInfo
     *
     * @return self
     */
    public function setRegistrationsInfo($registrationsInfo)
    {
        $this->registrationsInfo = $registrationsInfo;

        return $this;
    }


    /**
     * Get the value of Postponed
     *
     * @return boolean
     */
    public function getPostponed()
    {
        return $this->postponed;
    }

    /**
     * Set the value of Postponed
     *
     * @param boolean $postponed
     *
     * @return self
     */
    public function setPostponed($postponed)
    {
        $this->postponed = $postponed;

        return $this;
    }

    /**
     * Get the value of Postponed Text
     *
     * @return string
     */
    public function getPostponedText()
    {
        return $this->postponedText;
    }

    /**
     * Set the value of Postponed Text
     *
     * @param string $postponedText
     *
     * @return self
     */
    public function setPostponedText($postponedText)
    {
        $this->postponedText = $postponedText;

        return $this;
    }

    /**
     * Get the value of Canceled
     *
     * @return boolean
     */
    public function getCanceled()
    {
        return $this->canceled;
    }

    /**
     * Set the value of Canceled
     *
     * @param boolean $canceled
     *
     * @return self
     */
    public function setCanceled($canceled)
    {
        $this->canceled = $canceled;

        return $this;
    }

    /**
     * Get the value of Canceled Text
     *
     * @return string
     */
    public function getCanceledText()
    {
        return $this->canceledText;
    }

    /**
     * Set the value of Canceled Text
     *
     * @param string $canceledText
     *
     * @return self
     */
    public function setCanceledText($canceledText)
    {
        $this->canceledText = $canceledText;

        return $this;
    }

    /**
     * Adds a Qualification
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\Qualification $qualification
     * @return void
     */
    public function addQualification(\Ig\IgRuckzuckevent\Domain\Model\Qualification $qualification)
    {
        $this->qualifications->attach($qualification);
    }

    /**
     * Removes a Qualification
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\Qualification $qualificationToRemove The Category to be removed
     * @return void
     */
    public function removeQualification(\Ig\IgRuckzuckevent\Domain\Model\Qualification $qualificationToRemove)
    {
        $this->qualifications->detach($qualificationToRemove);
    }


    /**
     * Get the value of qualifications
     *
     * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Ig\IgRuckzuckevent\Domain\Model\Qualification>
     */
    public function getQualifications()
    {
        return $this->qualifications;
    }

    /**
     * Set the value of qualifications
     *
     * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Ig\IgRuckzuckevent\Domain\Model\Qualification> $qualifications
     *
     * @return self
     */
    public function setQualifications(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $qualifications)
    {
        $this->qualifications = $qualifications;

        return $this;
    }

    /**
     * Adds a Organizer
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\Organizer $qualification
     * @return void
     */
    public function addOrganizer(\Ig\IgRuckzuckevent\Domain\Model\Organizer $organizer)
    {
        $this->organizers->attach($organizer);
    }

    /**
     * Removes a Organizer
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\Organizer $qualificationToRemove The Category to be removed
     * @return void
     */
    public function removeOrganizer(\Ig\IgRuckzuckevent\Domain\Model\Organizer $organizerToRemove)
    {
        $this->organizers->detach($organizerToRemove);
    }


    /**
     * Get the value of Organizers
     *
     * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Ig\IgRuckzuckevent\Domain\Model\Organizer>
     */
    public function getOrganizers()
    {
        return $this->organizers;
    }

    /**
     * Set the value of Organizers
     *
     * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Ig\IgRuckzuckevent\Domain\Model\Organizer> $organizers
     *
     * @return self
     */
    public function setOrganizers(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $organizers)
    {
        $this->organizers = $organizers;

        return $this;
    }

    public function getJson()
    {
        $json = JsonUtility::getJsonForProperties($this->_getProperties());
        $json['placeSingleLine'] = $this->getPlaceSingleLine();
        $json['registrationUrlFull'] = $this->getRegistrationUrlFull();
        $json['freePlaces'] = $this->getFreePlaces();

        return $json;
    }
}
