<?php
namespace Ig\IgRuckzuckevent\Domain\Model;

use Ig\IgRuckzuckevent\Domain\Repository\EventRepository;
use Ig\IgRuckzuckevent\Utility\JsonUtility;
use TYPO3\CMS\Core\Utility\GeneralUtility;

/***
 *
 * This file is part of the "Ruck Zuck Event" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2017 Simon Häsler <sh@internetgalerie.ch>, Internetgalerie AG
 *
 ***/

/**
 * The Eventgroup model class is representing a group of events
 */
class Eventgroup extends \TYPO3\CMS\Extbase\DomainObject\AbstractEntity
{
    /**
     * @var boolean $repeated
     */
    protected $repeated = false;

    /**
     * @var \DateTime $firstDate
     */
    protected $firstDate = null;

    /**
     * @var \DateTime $repeatTill
     */
    protected $repeatTill = null;

    /**
     * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Ig\IgRuckzuckevent\Domain\Model\Event> $events
     * @TYPO3\CMS\Extbase\Annotation\ORM\Cascade remove
     */
    //protected $events = null;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->initStorageObjects();
        $this->firstEvent=null;
    }

    /**
     * Initializes all ObjectStorage properties
     *
     * @return void
     */
    protected function initStorageObjects()
    {
        // $this -> events = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
    }

    /**
     * Sets the events
     *
     * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Ig\IgRuckzuckevent\Domain\Model\Event> $events
     *
     * @return void
     */
    public function setEvents($events)
    {
        //$this->events = $events;
    }

    /**
     * Returns the events
     *
     * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Ig\IgRuckzuckevent\Domain\Model\Event> $events
     */
    public function getEvents()
    {
        $eventRepository = GeneralUtility::makeInstance(EventRepository::class);
        return $eventRepository->findByEventgroup($this);
        //return $this->events;
    }

    public function getCurrentEvent()
    {
        $eventRepository = GeneralUtility::makeInstance(EventRepository::class);
        return $eventRepository->findCurrentEvent($this);
    }

    /**
     * Adds an event
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\Event $event
     *
     * @return void
     */
    public function addEvent($event)
    {
        //$this->events->attach($event);
    }

    /**
     * Removes an event
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\Event $event
     *
     * @return void
     */
    public function removeEvent($event)
    {
        //$this->events->detach($event);
    }

    /**
     * Sets the repeated
     *
     * @param boolean $repeated
     *
     * @return void
     */
    public function setRepeated($repeated)
    {
        $this->repeated = $repeated;
    }

    /**
     * Returns the repeated
     *
     * @return boolean $repeated
     */
    public function getRepeated()
    {
        return $this->repeated;
    }
    public function isRepeated()
    {
        return $this->getRepeated();
    }

    /**
     * Sets the firstDate
     *
     * @param \DateTime $firstDate
     *
     * @return void
     */
    public function setFirstDate($firstDate)
    {
        $this->firstDate = $firstDate;
    }

    /**
     * Returns the firstDate
     *
     * @return \DateTime $firstDate
     */
    public function getFirstDate()
    {
        return $this->firstDate;
    }

    /**
     * Sets the repeatTill
     *
     * @param \DateTime $repeatTill
     *
     * @return void
     */
    public function setRepeatTill($repeatTill)
    {
        $this->repeatTill = $repeatTill;
    }

    /**
     * Returns the repeatTill
     *
     * @return \DateTime $repeatTill
     */
    public function getRepeatTill()
    {
        return $this->repeatTill;
    }


    /**
     * Returns the firstDate
     *
     * @return \DateTime $firstDate
     */
    public function getTitle()
    {
        $eventRepository = GeneralUtility::makeInstance(EventRepository::class);
        $event = $eventRepository->findByEventgroup($this)->getFirst();

        if (!$event) {
            return null;
        }

        return $event->getTitle();
    }



    /**
     * Returns the fromDate of next Event
     *
     * @return \DateTime $fromDate
     */
    public function getEventDateFrom()
    {
        $eventRepository = GeneralUtility::makeInstance(EventRepository::class);
        if ($this->firstEvent == null) {
            $this->firstEvent = $eventRepository->findEventInNextYear($this)->getFirst();
        }

        if (!$this->firstEvent) {
            return null;
        }

        return $this->firstEvent->getDateFrom();
    }

    /**
     * Returns the title of next Event
     *
     * @return \DateTime $fromDate
     */
    public function getEventTitle()
    {
        $eventRepository = GeneralUtility::makeInstance(EventRepository::class);
        if ($this->firstEvent == null) {
            $this->firstEvent = $eventRepository->findEventInNextYear($this)->getFirst();
        }

        if (!$this->firstEvent) {
            return null;
        }

        return $this->firstEvent->getTitle();
    }

    // get numbers of events of this group in next year
    public function getEventsCount()
    {
        $eventRepository = GeneralUtility::makeInstance(EventRepository::class);
        return $eventRepository->countEventInNextYear($this);
    }

    public function __toString()
    {
        return $this->getTitle() . ': '. strftime('%a', $this->getEventDateFrom()->getTimestamp()) .' ' . $this->getEventDateFrom()->format('d.m.Y'). ' - '.($this->getRepeatTill ? $this->getRepeatTill()->format('d.m.Y') : '').' (' .$this->getEventsCount() . ')';
    }

    public function getJson()
    {
        return JsonUtility::getJsonForProperties($this->_getProperties());
    }

}
