<?php
namespace Ig\IgRuckzuckevent\Domain\Model;

use Ig\IgRuckzuckevent\Utility\JsonUtility;
use Ig\IgRuckzuckevent\Utility\UserUtility;

/***
 *
 * This file is part of the "Ruck Zuck Event" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2017 Simon Häsler <sh@internetgalerie.ch>, Internetgalerie AG
 *
 ***/

/**
 * The Registration model represents entities of the table tx_igruckzuckevent_domain_model_registration.
 */
class Registration extends \TYPO3\CMS\Extbase\DomainObject\AbstractEntity
{
    /**
     * crdate
     * @var \DateTime
     */
    protected $crdate = null;

    /**
     * The gender of the registrant
     *
     * @var string
     */
    protected $gender = '';

    /**
     * The name of the registratant
     *
     * @var string
     */
    protected $name = '';

    /**
     * First name of the registrant
     *
     * @var string
     */
    protected $firstName = '';

    /**
     * E-Mail address of the registrant
     *
     * @var string
     */
    protected $email = '';

    /**
     * Phone number of the registrant
     *
     * @var string
     */
    protected $phone = '';

    /**
     * street
     *
     * @var string
     */
    protected $street = '';

    /**
     * zip
     *
     * @var string
     */
    protected $zip = '';

    /**
     * city
     *
     * @var string
     */
    protected $city = '';

    /**
     * phoneWork
     *
     * @var string
     */
    protected $phoneWork = '';

    /**
     * function
     *
     * @var string
     */
    protected $function = '';

    /**
     * deputy
     *
     * @var string
     */
    protected $deputy = '';

    /**
     * comment
     *
     * @var string
     */
    protected $comment = '';

    /**
     * company
     *
     * @var string
     */
    protected $company = '';

    /**
     * companyStreet
     *
     * @var string
     */
    protected $companyStreet = '';

    /**
     * companyZip
     *
     * @var string
     */
    protected $companyZip = '';

    /**
     * companyCity
     *
     * @var string
     */
    protected $companyCity = '';

    /**
     * bill
     *
     * @var string
     */
    protected $bill = '';

    /**
     * accept
     *
     * @var bool
     */
    protected $accept = false;

    /**
     * infosMembership
     *
     * @var bool
     */
    protected $infosMembership = false;

    /**
     * apprenticeship
     *
     * @var string
     */
    protected $apprenticeship = '';

    /**
     * workspace
     *
     * @var string
     */
    protected $workspace = '';

    /**
     * phoneMobile
     *
     * @var string
     */
    protected $phoneMobile = '';

    /**
     * discount
     *
     * @var string
     */
    protected $discount = '';

    /**
     * voucher
     *
     * @var string
     */
    protected $voucher = '';

    /**
     * The event the registration is for
     *
     * @var \Ig\IgRuckzuckevent\Domain\Model\Event
     */
    protected $event = null;

    /**
     * feUser
     *
     * @var \Ig\IgRuckzuckevent\Domain\Model\FeUser
     */
    protected $feUser = null;

    /**
     * subscription
     *
     * @var \Ig\IgRuckzuckevent\Domain\Model\Subscription
     */
    protected $subscription = null;

    /**
     * @var string
     */
    protected $paymentMethod = '';

    /**
     * attention
     *
     * @var \Ig\IgRuckzuckevent\Domain\Model\Attention
     */
    protected $attention = null;

    /**
     * workarea
     *
     * @var \Ig\IgRuckzuckevent\Domain\Model\Workarea
     */
    protected $workarea = null;

    /**
     * status
     *
     * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Ig\IgRuckzuckevent\Domain\Model\Status>
     */
    protected $status = null;

    /**
     * additionalFields
     *
     * @var string
     */
    protected $additionalFields = '';

    /**
     * captcha
     *
     * @var string
     */
    protected $captcha = '';


    /**
     * __construct
     */
    public function __construct()
    {
        //Do not remove the next line: It would break the functionality
        $this->initStorageObjects();
    }

    /**
     * Initializes all ObjectStorage properties
     * Do not modify this method!
     * It will be rewritten on each save in the extension builder
     * You may modify the constructor of this class instead
     *
     * @return void
     */
    protected function initStorageObjects()
    {
        $this->status = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
    }


    /**
     * Returns the gender
     *
     * @return string $gender
     */
    public function getGender()
    {
        return $this->gender;
    }

    /**
     * Sets the gender
     *
     * @param string $gender
     * @return void
     */
    public function setGender($gender)
    {
        $this->gender = $gender;
    }

    /**
     * Returns the name
     *
     * @return string $name
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Sets the name
     *
     * @param string $name
     * @return void
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     * Returns the firstName
     *
     * @return string $firstName
     */
    public function getFirstName()
    {
        return $this->firstName;
    }

    /**
     * Sets the firstName
     *
     * @param string $firstName
     * @return void
     */
    public function setFirstName($firstName)
    {
        $this->firstName = $firstName;
    }

    /**
     * Returns the email
     *
     * @return string $email
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * Sets the email
     *
     * @param string $email
     * @return void
     */
    public function setEmail($email)
    {
        $this->email = $email;
    }

    /**
     * Returns the phone
     *
     * @return string $phone
     */
    public function getPhone()
    {
        return $this->phone;
    }

    /**
     * Sets the phone
     *
     * @param string $phone
     * @return void
     */
    public function setPhone($phone)
    {
        $this->phone = $phone;
    }

    /**
     * Returns the event
     *
     * @return \Ig\IgRuckzuckevent\Domain\Model\Event $event
     */
    public function getEvent()
    {
        return $this->event;
    }

    /**
     * Sets the event
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\Event $event
     * @return void
     */
    public function setEvent(\Ig\IgRuckzuckevent\Domain\Model\Event $event)
    {
        $this->event = $event;
    }

    /**
     * Returns the feUser
     *
     * @return \Ig\IgRuckzuckevent\Domain\Model\FeUser $feUser
     */
    public function getFeUser()
    {
        return $this->feUser;
    }

    /**
     * Sets the feUser
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\FeUser $feUser
     *
     * @return void
     */
    public function setFeUser(\Ig\IgRuckzuckevent\Domain\Model\FeUser $feUser)
    {
        $this->feUser = $feUser;
    }

    /**
     * Returns the subscription
     *
     * @return \Ig\IgRuckzuckevent\Domain\Model\Subscription $subscription
     */
    public function getSubscription()
    {
        return $this->subscription;
    }

    /**
     * Sets the subscription
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\Subscription $subscription
     *
     * @return void
     */
    public function setSubscription(\Ig\IgRuckzuckevent\Domain\Model\Subscription $subscription)
    {
        $this->subscription = $subscription;
    }

    /**
     * @return string $paymentMethod
     */
    public function getPaymentMethod()
    {
        return $this->paymentMethod;
    }

    /**
     * @param string $paymentMethod
     * @return void
     */
    public function setPaymentMethod($paymentMethod)
    {
        $this->paymentMethod = $paymentMethod;
    }

    /**
     * Returns the street
     *
     * @return string $street
     */
    public function getStreet()
    {
        return $this->street;
    }

    /**
     * Sets the street
     *
     * @param string $street
     * @return void
     */
    public function setStreet($street)
    {
        $this->street = $street;
    }

    /**
     * Returns the zip
     *
     * @return string $zip
     */
    public function getZip()
    {
        return $this->zip;
    }

    /**
     * Sets the zip
     *
     * @param string $zip
     * @return void
     */
    public function setZip($zip)
    {
        $this->zip = $zip;
    }

    /**
     * Returns the city
     *
     * @return string $city
     */
    public function getCity()
    {
        return $this->city;
    }

    /**
     * Sets the city
     *
     * @param string $city
     * @return void
     */
    public function setCity($city)
    {
        $this->city = $city;
    }

    /**
     * Returns the phoneWork
     *
     * @return string $phoneWork
     */
    public function getPhoneWork()
    {
        return $this->phoneWork;
    }

    /**
     * Sets the phoneWork
     *
     * @param string $phoneWork
     * @return void
     */
    public function setPhoneWork($phoneWork)
    {
        $this->phoneWork = $phoneWork;
    }

    /**
     * Returns the function
     *
     * @return string $function
     */
    public function getFunction()
    {
        return $this->function;
    }

    /**
     * Sets the function
     *
     * @param string $function
     * @return void
     */
    public function setFunction($function)
    {
        $this->function = $function;
    }

    /**
     * Returns the comment
     *
     * @return string $comment
     */
    public function getComment()
    {
        return $this->comment;
    }

    /**
     * Sets the comment
     *
     * @param string $comment
     * @return void
     */
    public function setComment($comment)
    {
        $this->comment = $comment;
    }

    /**
     * Returns the company
     *
     * @return string $company
     */
    public function getCompany()
    {
        return $this->company;
    }

    /**
     * Sets the company
     *
     * @param string $company
     * @return void
     */
    public function setCompany($company)
    {
        $this->company = $company;
    }

    /**
     * Returns the companyStreet
     *
     * @return string $companyStreet
     */
    public function getCompanyStreet()
    {
        return $this->companyStreet;
    }

    /**
     * Sets the companyStreet
     *
     * @param string $companyStreet
     * @return void
     */
    public function setCompanyStreet($companyStreet)
    {
        $this->companyStreet = $companyStreet;
    }

    /**
     * Returns the companyZip
     *
     * @return string $companyZip
     */
    public function getCompanyZip()
    {
        return $this->companyZip;
    }

    /**
     * Sets the companyZip
     *
     * @param string $companyZip
     * @return void
     */
    public function setCompanyZip($companyZip)
    {
        $this->companyZip = $companyZip;
    }

    /**
     * Returns the companyCity
     *
     * @return string $companyCity
     */
    public function getCompanyCity()
    {
        return $this->companyCity;
    }

    /**
     * Sets the companyCity
     *
     * @param string $companyCity
     * @return void
     */
    public function setCompanyCity($companyCity)
    {
        $this->companyCity = $companyCity;
    }

    /**
     * Returns the bill
     *
     * @return string $bill
     */
    public function getBill()
    {
        return $this->bill;
    }

    /**
     * Sets the bill
     *
     * @param string $bill
     * @return void
     */
    public function setBill($bill)
    {
        $this->bill = $bill;
    }

    /**
     * Returns the accept
     *
     * @return bool $accept
     */
    public function getAccept()
    {
        return $this->accept;
    }

    /**
     * Sets the accept
     *
     * @param bool $accept
     * @return void
     */
    public function setAccept($accept)
    {
        $this->accept = $accept;
    }

    /**
     * Returns the boolean state of accept
     *
     * @return bool
     */
    public function isAccept()
    {
        return $this->accept;
    }

    /**
     * Returns the infosMembership
     *
     * @return bool $infosMembership
     */
    public function getInfosMembership()
    {
        return $this->infosMembership;
    }

    /**
     * Sets the infosMembership
     *
     * @param bool $infosMembership
     * @return void
     */
    public function setInfosMembership($infosMembership)
    {
        $this->infosMembership = $infosMembership;
    }

    /**
     * Returns the boolean state of infosMembership
     *
     * @return bool
     */
    public function isInfosMembership()
    {
        return $this->infosMembership;
    }

    /**
     * Returns the apprenticeship
     *
     * @return string $apprenticeship
     */
    public function getApprenticeship()
    {
        return $this->apprenticeship;
    }

    /**
     * Sets the apprenticeship
     *
     * @param string $apprenticeship
     * @return void
     */
    public function setApprenticeship($apprenticeship)
    {
        $this->apprenticeship = $apprenticeship;
    }

    /**
     * Returns the workspace
     *
     * @return string $workspace
     */
    public function getWorkspace()
    {
        return $this->workspace;
    }

    /**
     * Sets the workspace
     *
     * @param string $workspace
     * @return void
     */
    public function setWorkspace($workspace)
    {
        $this->workspace = $workspace;
    }

    /**
     * Returns the phoneMobile
     *
     * @return string $phoneMobile
     */
    public function getPhoneMobile()
    {
        return $this->phoneMobile;
    }

    /**
     * Sets the phoneMobile
     *
     * @param string $phoneMobile
     * @return void
     */
    public function setPhoneMobile($phoneMobile)
    {
        $this->phoneMobile = $phoneMobile;
    }

    /**
     * Returns the discount
     *
     * @return string $discount
     */
    public function getDiscount()
    {
        return $this->discount;
    }

    /**
     * Sets the discount
     *
     * @param string $discount
     * @return void
     */
    public function setDiscount($discount)
    {
        $this->discount = $discount;
    }

    /**
     * Returns the voucher
     *
     * @return string $voucher
     */
    public function getVoucher()
    {
        return $this->voucher;
    }

    /**
     * Sets the voucher
     *
     * @param string $voucher
     * @return void
     */
    public function setVoucher($voucher)
    {
        $this->voucher = $voucher;
    }

    /**
     * Returns the attention
     *
     * @return \Ig\IgRuckzuckevent\Domain\Model\Attention $attention
     */
    public function getAttention()
    {
        return $this->attention;
    }

    /**
     * Sets the attention
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\Attention $attention
     * @return void
     */
    public function setAttention(\Ig\IgRuckzuckevent\Domain\Model\Attention $attention = null)
    {
        $this->attention = $attention;
    }

    /**
     * Adds a Status
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\Status $status
     * @return void
     */
    public function addStatus(\Ig\IgRuckzuckevent\Domain\Model\Status $status)
    {
        $this->status->attach($status);
    }

    /**
     * Removes a Status
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\Status $statusToRemove The Status to be removed
     * @return void
     */
    public function removeStatus(\Ig\IgRuckzuckevent\Domain\Model\Status $statusToRemove)
    {
        $this->status->detach($statusToRemove);
    }

    /**
     * Returns the status
     *
     * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Ig\IgRuckzuckevent\Domain\Model\Status> $status
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Sets the status
     *
     * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Ig\IgRuckzuckevent\Domain\Model\Status> $status
     * @return void
     */
    public function setStatus(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $status)
    {
        $this->status = $status;
    }

    /**
     * Returns the captcha
     *
     * @return string $captcha
     */
    public function getCaptcha()
    {
        return $this->captcha;
    }

    /**
     * Sets the captcha
     *
     * @param string $captcha
     * @return void
     */
    public function setCaptcha($captcha)
    {
        $this->captcha = $captcha;
    }

    /**
     * Returns the additionalFields
     *
     * @return array $additionalFields
     */
    public function getAdditionalFields()
    {
        if(!$this->additionalFields) {
            return [];
        }
        return unserialize($this->additionalFields);
    }

    /**
     * Sets the additionalFields
     *
     * @param array $additionalFields
     * @return void
     */
    public function setAdditionalFields($additionalFields)
    {
        $this->additionalFields = serialize($additionalFields);
    }

    public function getIconWithLink()
    {
        $tableName = 'tx_igruckzuckevent_domain_model_registration';
        $entry = ['uid' => $this->getUid()];
        $iconFactory = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance(\TYPO3\CMS\Core\Imaging\IconFactory::class);
        $iconHtml=$iconFactory->getIconForRecord($tableName, $entry, \TYPO3\CMS\Core\Imaging\Icon::SIZE_SMALL)->render();
        return \TYPO3\CMS\Backend\Utility\BackendUtility::wrapClickMenuOnIcon($iconHtml, $tableName, $entry['uid']);
    }

    /**
     * Get the value of crdate
     *
     * @return \DateTime
     */
    public function getCrdate()
    {
        //TODO HERE var_dump($this->crdate);die();
        return $this->crdate;
    }

    /**
     * Set the value of crdate
     *
     * @param \DateTime $crdate
     *
     * @return self
     */
    public function setCrdate(\DateTime $crdate)
    {
        $this->crdate = $crdate;

        return $this;
    }
    /**
     * Returns the canDelete
     *
     * @return boolean
     */
    public function getCanDelete()
    {
        $now=new \DateTime();
        if (UserUtility::isAdminLoggedIn()) {
            $now->modify('-2 month');
        } else {
            $now->modify('+ 24 hour');
        }
        if ($this->event->getDatetimeFrom()>$now) {
            return true;
        } else {
            return false;
        }
    }


    /**
     * Returns the canDeleteUser
     *
     * @return boolean
     */
    public function getCanDeleteUser()
    {
        $now=new \DateTime();
        $now->modify('+ 24 hour');
        if ($this->event->getDatetimeFrom()>$now) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * Get the value of deputy
     *
     * @return string
     */
    public function getDeputy()
    {
        return $this->deputy;
    }

    /**
     * Set the value of deputy
     *
     * @param string $deputy
     *
     * @return self
     */
    public function setDeputy($deputy)
    {
        $this->deputy = $deputy;

        return $this;
    }


    /**
     * Get the value of workarea
     *
     * @return \Ig\IgRuckzuckevent\Domain\Model\Workarea
     */
    public function getWorkarea()
    {
        return $this->workarea;
    }

    /**
     * Set the value of workarea
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\Workarea $workarea
     *
     * @return self
     */
    public function setWorkarea(\Ig\IgRuckzuckevent\Domain\Model\Workarea $workarea)
    {
        $this->workarea = $workarea;

        return $this;
    }

    public function getJson()
    {
        return JsonUtility::getJsonForProperties($this->_getProperties());
    }

    public function getRegistrationCount()
    {
        return 1;
    }

}
