<?php
namespace Ig\IgRuckzuckevent\Domain\Repository;

/***
 *
 * This file is part of the "Ruck Zuck Event" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2017 Simon Häsler <sh@internetgalerie.ch>, Internetgalerie AG
 *
 ***/

/**
 * The repository for Eventgroups
 */
class EventgroupRepository extends \TYPO3\CMS\Extbase\Persistence\Repository
{
    public function findCurrent()
    {
        $query = $this -> createQuery();
        $now = new \DateTime();
    
        $query->matching(
        $query->logicalAnd(
                 $query->logicalOr(
                            $query->equals('repeatTill', null),
                            $query->equals('repeatTill', '0000-00-00'),
                            $query->greaterThanOrEqual('repeatTill', $now)
                        ),
                 $query->logicalOr(
                            $query->greaterThanOrEqual('firstDate', $now),
                            $query->equals('repeated', true)
                        )
                        //					    $query->greaterThan('events',0)
             )
    );
    
        return $query->execute();
    }
}
