<?php
namespace Ig\IgRuckzuckevent\Domain\Repository;

use Internetgalerie\IgFrontendUser\Domain\Repository\FrontendUserRepository;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Persistence\Generic\Typo3QuerySettings;

/***
 *
 * This file is part of the "Ruck Zuck Event" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2017 Simon Häsler <sh@internetgalerie.ch>, Internetgalerie AG
 *
 ***/

/**
 * The repository for FeUsers
 */
class FeUserRepository extends FrontendUserRepository
{
    protected $defaultOrderings = array(
                                      'last_name' => \TYPO3\CMS\Extbase\Persistence\QueryInterface::ORDER_ASCENDING,
                                      'first_name' => \TYPO3\CMS\Extbase\Persistence\QueryInterface::ORDER_ASCENDING
                                      );
    
    /**
     * Disable respecting of a storage pid within queries globally.
     */
    public function initializeObject()
    {
        $defaultQuerySettings = GeneralUtility::makeInstance(Typo3QuerySettings::class);
        $defaultQuerySettings->setRespectStoragePage(false);
        $defaultQuerySettings->setIgnoreEnableFields(true);
        //$defaultQuerySettings->setIncludeDeleted(true);
        $defaultQuerySettings->setEnableFieldsToBeIgnored(array('disabled'));
        $this->setDefaultQuerySettings($defaultQuerySettings);
    }
    
    public function findHiddenByUid($uid)
    {
        $query = $this->createQuery();
        $query->matching($query->equals('uid', $uid));
        return $query->execute()->getFirst();
    }
    
    public function findHiddenByUsername($username)
    {
        $query = $this->createQuery();
        $query->matching($query->equals('username', $username));
        return $query->execute()->getFirst();
    }


    public function findWithSearch($usergroup, $search, $user)
    {
        $query = $this->createQuery();
        $constraints = [];
        $keywords= isset($search['keywords']) ? $search['keywords'] : '';
        foreach (array_filter(explode(' ', $keywords)) as $k) {
            $keyword='%'. trim($k) .'%';
            $constraints[] = $query->logicalOr(
          $query->like('username', $keyword),
          $query->like('email', $keyword),
          $query->like('firstName', $keyword),
          $query->like('lastName', $keyword),
          $query->like('telephone', $keyword)
      );
        }
        if (isset($user)) {
            $constraints[] = $query->equals('uid', $user);
        }
    
        $query->matching(
            $query->logicalAnd(
                 $query->equals('usergroup', 4),
                 $query->logicalAnd(...$constraints)
             )
        );
        return $query->execute();
    }
}
