<?php
namespace Ig\IgRuckzuckevent\Domain\Repository;

/***
 *
 * This file is part of the "Ruck Zuck Event" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2017 Simon Häsler <sh@internetgalerie.ch>, Internetgalerie AG
 *
 ***/

/**
 * The repository for Registrations
 */
class RegistrationRepository extends \TYPO3\CMS\Extbase\Persistence\Repository
{
    /**
     * @var array
     */
    protected $defaultOrderings = [
        'crdate' => \TYPO3\CMS\Extbase\Persistence\QueryInterface::ORDER_DESCENDING
    ];

    public function initializeObject()
    {
        $querySettings = $this->createQuery()->getQuerySettings();

        //$querySettings->setLanguageUid(0);
        $querySettings->setRespectSysLanguage(false);
        $querySettings->setRespectStoragePage(false);

        $this->setDefaultQuerySettings($querySettings);
    }

    public function setStoragePid($pid)
    {
        $querySettings = $this->createQuery()->getQuerySettings();

        $querySettings->setStoragePageIds([$pid]);

        $this->setDefaultQuerySettings($querySettings);
    }

    public function findByEventAndFilter($event, array $filter = [])
    {
        $query = $this->createQuery();

        $constraints = [];
        $constraints[] = $query->equals('event', $event);

        if ($filter['searchword'] ?? null) {
            $constraints[] = $query->logicalOr(
                $query->like('name', '%' . $filter['searchword'] . '%'),
                $query->like('firstName', '%' . $filter['searchword'] . '%'),
                $query->like('street', '%' . $filter['searchword'] . '%'),
                $query->like('zip', '%' . $filter['searchword'] . '%'),
                $query->like('city', '%' . $filter['searchword'] . '%'),
                $query->like('email', '%' . $filter['searchword'] . '%')
            );
        }

        $query->matching($query->logicalAnd(...$constraints));

        return $query->execute();
    }


    /*
     * Funktionen fuer Physio Team
     */

    public function findNextRegistrations($user)
    {
        $query = $this->createQuery();

        $today = new \DateTime();
        $constraints = [];

        $constraints[] = $query->equals('feUser', $user);
        $constraints[] = $query->greaterThanOrEqual('event.dateFrom', $today->format('Y-m-d'));

        $query->matching($query->logicalAnd(...$constraints));
        $query->setLimit(3);
        $query->setOrderings(array('event.dateFrom' => 'ASC', 'event.timeFrom' => 'ASC'));

        return $query->execute();
    }


    public function findPassedRegistrations($user)
    {
        $query = $this->createQuery();

        $today = new \DateTime();
        $aYearAgo = clone $today;
        $aYearAgo->modify('-1 year');

        $constraints = [];

        $constraints[] = $query->equals('feUser', $user);
        $constraints[] = $query->greaterThanOrEqual('event.dateFrom', $aYearAgo->format('Y-m-d'));
        $constraints[] = $query->lessThanOrEqual('event.dateFrom', $today->format('Y-m-d'));

        $query->matching($query->logicalAnd(...$constraints));
        $query->setLimit(3);
        $query->setOrderings(array('event.dateFrom' => 'ASC', 'event.timeFrom' => 'ASC'));

        return $query->execute();
    }
}
