<?php
namespace Ig\IgRuckzuckevent\Domain\Validator;

use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Utility\DebuggerUtility;

/***
 *
 * This file is part of the "Ruck Zuck Event" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2017 Simon Häsler <sh@internetgalerie.ch>, Internetgalerie AG
 *
 ***/

 /**
  * The password confirmation validator validates a password with its confirmation for registration and password update forms
  */
class PasswordChangeValidator extends \TYPO3\CMS\Extbase\Validation\Validator\AbstractValidator
{
    /**
     * Checks if the password is valid with its confirmation
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\FeUser $user
     * @return void
     */
    public function isValid($user): void
    {
        $oldPassword = GeneralUtility::_POST('tx_igruckzuckevent_events')['oldPassword'];
        
        if (!$oldPassword) {
            $oldPassword = GeneralUtility::_POST('tx_igruckzuckevent_management')['oldPassword'];
        }
        if (!$oldPassword) {
            $oldPassword = GeneralUtility::_POST('tx_igruckzuckevent_user')['oldPassword'];
        }
        
        $hashFactory = GeneralUtility::makeInstance(\TYPO3\CMS\Core\Crypto\PasswordHashing\PasswordHashFactory::class);
        if (!$hashFactory->get($user->getPassword(), 'FE')->checkPassword($oldPassword, $user->getPassword())) {
            $this->addError('Old password is wrong', 149121114);
        }
    }
}
