<?php
namespace Ig\IgRuckzuckevent\Domain\Validator;

use TYPO3\CMS\Extbase\Utility\DebuggerUtility;
use Ig\IgRuckzuckevent\Utility\UserUtility;

/***
 *
 * This file is part of the "Ruck Zuck Event" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2017 Simon Häsler <sh@internetgalerie.ch>, Internetgalerie AG
 *
 ***/

 /**
  * The EventFormValidator validates the input of the forms for creating and editing events and throws errors if inputs are wrong.
  * The actual error messages in german are stored in the Resources/Private/Language/locallang.xlf-File.
  * We are outputting them in fluid by property path and error code.
  */
class UserRegistrationFormValidator extends \TYPO3\CMS\Extbase\Validation\Validator\AbstractValidator
{
    /**
     * Checks if the event is valid
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\FeUser $user
     * @return void
     */
    public function isValid($user): void
    {
        if ($user -> getFirstName() == '') {
            $this -> addError('No first name entered', 1491210092);
        }
        if ($user -> getLastName() == '') {
            $this -> addError('No last name entered', 1491210091);
        }
        if ($user -> getEmail() == '') {
            if (UserUtility::isAdminLoggedIn()) {
                $user->setEmail('USR' . time());
                $user->setPassword('kedIDj3-dLJ' . time());
            } else {
                $this -> addError('No email entered', 1491210094);
            }
        } elseif (!\TYPO3\CMS\Core\Utility\GeneralUtility::validEmail($user -> getEmail())) {
            $this -> addError('Email entered is wrong', 1491210093);
        }
        if ($user -> getTelephone() == '') {
            $this -> addError('No phone number entered', 14912100102);
        }
    }
}
