<?php

namespace Ig\IgRuckzuckevent\Event;

use Psr\EventDispatcher\StoppableEventInterface;
use TYPO3\CMS\Fluid\View\TemplateView;
use Ig\IgRuckzuckevent\Domain\Model\Event;


final class BeforeRenderDetailViewEvent implements StoppableEventInterface {

    private TemplateView $view;
    private Event $event;
 
    public function __construct(TemplateView $view, Event $event)
    {
        $this->view = $view;
        $this->event = $event;
    }
 
    public function getView(): ?TemplateView
    {
        return $this->view;
    }

 
    public function setView(TemplateView $view): void
    {
        $this->view = $view;
    }
    public function isPropagationStopped(): bool
    {
        return false;
	// return !empty($this->data);
    }
 
    public function getEvent(): Event
    {
        return $this->event;
    }

    public function setEvent(Event $event)
    {
        $this->event = $event;

        return $this;
    }
}