<?php


return [
    'igruckzuckevent_main' => [
        'extensionName' => 'IgRuckzuckevent',
        'position' => ['after' => 'file'],
        'access' => 'user',
        'icon' => 'EXT:ig_ruckzuckevent/Resources/Public/Icons/folder-module-igruckzuckevent.svg',
        'labels' => 'LLL:EXT:ig_ruckzuckevent/Resources/Private/Language/locallang_nav.xlf'
    ],
    'igruckzuckevent_events' => [
        'parent' => 'igruckzuckevent_main',
        'extensionName' => 'IgRuckzuckevent',
        'position' => ['top'],
        'access' => 'user',
        'icon' => 'EXT:ig_backend_helpers/Resources/Public/Icons/module-db-entry.svg',
        'labels' => 'LLL:EXT:ig_ruckzuckevent/Resources/Private/Language/locallang_nav_event.xlf',
        'path' => '/igruckzuckevent/events',
        'navigationComponent' => '@internetgalerie/igruckzuckevent/category-tree/category-tree-element',
        'controllerActions' => [
            \Ig\IgRuckzuckevent\Controller\EventBackendController::class => ['index', 'listParticipants', 'exportRegistrations', 'deleteRegistration', 'deleteRegistrations', 'deleteEvent'],
        ]
    ],
    'igruckzuckevent_categories' => [
        'parent' => 'igruckzuckevent_main',
        'extensionName' => 'IgRuckzuckevent',
        'position' => ['top'],
        'access' => 'user',
        'icon' => 'EXT:ig_backend_helpers/Resources/Public/Icons/module-db-entry.svg',
        'labels' => 'LLL:EXT:ig_ruckzuckevent/Resources/Private/Language/locallang_nav_category.xlf',
        'path' => '/igruckzuckevent/categories',
        'navigationComponent' => '@internetgalerie/igruckzuckevent/category-tree/category-tree-element',
        'controllerActions' => [
            \Ig\IgRuckzuckevent\Controller\CategoryBackendController::class => ['index'],
        ]
    ],
];
