<?php
return [
    'ctrl' => [
        'title' => 'LLL:EXT:ig_ruckzuckevent/Resources/Private/Language/locallang_db.xlf:tx_igruckzuckevent_domain_model_organizer',
        'label' => 'name',
        'tstamp' => 'tstamp',
        'crdate' => 'crdate',
        'cruser_id' => 'cruser_id',
        'sortby' => 'sorting',
        'versioningWS' => true,
        'languageField' => 'sys_language_uid',
        'transOrigPointerField' => 'l10n_parent',
        'transOrigDiffSourceField' => 'l10n_diffsource',
        'delete' => 'deleted',
        'enablecolumns' => [
            'disabled' => 'hidden',
            'starttime' => 'starttime',
            'endtime' => 'endtime',
        ],
        'searchFields' => 'name,address,zip,city,phone,email,url',
        'iconfile' => 'EXT:ig_ruckzuckevent/Resources/Public/Icons/tx_igruckzuckevent_domain_model_organizer.gif'
    ],
    'interface' => [
        'showRecordFieldList' => 'sys_language_uid, l10n_parent, l10n_diffsource, hidden, name, address, zip, city, phone, fax, email, admin_email, url, logo',
    ],
    'types' => [
        '1' => ['showitem' => 'sys_language_uid, l10n_parent, l10n_diffsource, hidden, name, address, zip, city, phone, fax, email, admin_email, url, logo, --div--;LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:tabs.access, starttime, endtime'],
    ],
    'columns' => [
        'sys_language_uid' => [
            'exclude' => true,
            'label' => 'LLL:EXT:lang/locallang_general.xlf:LGL.language',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'special' => 'languages',
                'items' => [
                    [
                        'LLL:EXT:lang/locallang_general.xlf:LGL.allLanguages',
                        -1,
                        'flags-multiple'
                    ]
                ],
                'default' => 0,
            ],
        ],
        'l10n_parent' => [
            'displayCond' => 'FIELD:sys_language_uid:>:0',
            'exclude' => true,
            'label' => 'LLL:EXT:lang/locallang_general.xlf:LGL.l18n_parent',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'default' => 0,
                'items' => [
                    ['', 0],
                ],
                'foreign_table' => 'tx_igruckzuckevent_domain_model_organizer',
                'foreign_table_where' => 'AND tx_igruckzuckevent_domain_model_organizer.pid=###CURRENT_PID### AND tx_igruckzuckevent_domain_model_organizer.sys_language_uid IN (-1,0)',
            ],
        ],
        'l10n_diffsource' => [
            'config' => [
                'type' => 'passthrough',
            ],
        ],
        't3ver_label' => [
            'label' => 'LLL:EXT:lang/locallang_general.xlf:LGL.versionLabel',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'max' => 255,
            ],
        ],
        'hidden' => [
            'exclude' => true,
            'label' => 'LLL:EXT:lang/locallang_general.xlf:LGL.hidden',
            'config' => [
                'type' => 'check',
                'renderType' => 'checkboxToggle',
                'items' => [
                    '1' => [
                        '0' => 'LLL:EXT:lang/locallang_core.xlf:labels.enabled'
                    ]
                ],
            ],
        ],
        'starttime' => [
            'exclude' => true,
            'behaviour' => [
                'allowLanguageSynchronization' => true
            ],
            'label' => 'LLL:EXT:lang/locallang_general.xlf:LGL.starttime',
            'config' => [
                'type' => 'input',
                'renderType' => 'inputDateTime',
                'size' => 13,
                'eval' => 'datetime',
                'default' => 0,
            ],
        ],
        'endtime' => [
            'exclude' => true,
            'behaviour' => [
                'allowLanguageSynchronization' => true
            ],
            'label' => 'LLL:EXT:lang/locallang_general.xlf:LGL.endtime',
            'config' => [
                'type' => 'input',
                'renderType' => 'inputDateTime',
                'size' => 13,
                'eval' => 'datetime',
                'default' => 0,
                'range' => [
                    'upper' => mktime(0, 0, 0, 1, 1, 2038)
                ],
            ],
        ],

        'name' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_ruckzuckevent/Resources/Private/Language/locallang_db.xlf:tx_igruckzuckevent_domain_model_organizer.name',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'address' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_ruckzuckevent/Resources/Private/Language/locallang_db.xlf:tx_igruckzuckevent_domain_model_organizer.address',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'zip' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_ruckzuckevent/Resources/Private/Language/locallang_db.xlf:tx_igruckzuckevent_domain_model_organizer.zip',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'city' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_ruckzuckevent/Resources/Private/Language/locallang_db.xlf:tx_igruckzuckevent_domain_model_organizer.city',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'phone' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_ruckzuckevent/Resources/Private/Language/locallang_db.xlf:tx_igruckzuckevent_domain_model_organizer.phone',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'fax' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_ruckzuckevent/Resources/Private/Language/locallang_db.xlf:tx_igruckzuckevent_domain_model_event.fax',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'email' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_ruckzuckevent/Resources/Private/Language/locallang_db.xlf:tx_igruckzuckevent_domain_model_organizer.email',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'nospace,email'
            ]
        ],
        'admin_email' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_ruckzuckevent/Resources/Private/Language/locallang_db.xlf:tx_igruckzuckevent_domain_model_event.admin_email',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'url' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_ruckzuckevent/Resources/Private/Language/locallang_db.xlf:tx_igruckzuckevent_domain_model_organizer.url',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'logo' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_ruckzuckevent/Resources/Private/Language/locallang_db.xlf:tx_igruckzuckevent_domain_model_sponsor.logo',
            'config' => [
                'type' => 'file',
                'foreign_match_fields' => [
                    'tablenames' => 'tx_igruckzuckevent_domain_model_organizer',
                ],
                'maxitems' => 1,
                'allowed' => 'common-image-types',

            ],
        ],

    ],
];
