<?php
return [
    'ctrl' => [
        'title'	=> 'LLL:EXT:ig_ruckzuckevent/Resources/Private/Language/locallang_db.xlf:tx_igruckzuckevent_domain_model_subscription',
        'label' => 'fe_user',
        'tstamp' => 'tstamp',
        'crdate' => 'crdate',
        'cruser_id' => 'cruser_id',
        'versioningWS' => true,
        'languageField' => 'sys_language_uid',
        'transOrigPointerField' => 'l10n_parent',
        'transOrigDiffSourceField' => 'l10n_diffsource',
        'delete' => 'deleted',
        'enablecolumns' => [
            'disabled' => 'hidden',
            'starttime' => 'starttime',
            'endtime' => 'endtime',
        ],
        'searchFields' => 'days_left, start_date, expiration_date, subscription_offer, fe_user, payment_method, transaction_id, transaction_amount, transaction_currency',
        'iconfile' => 'EXT:ig_ruckzuckevent/Resources/Public/Icons/tx_igruckzuckevent_domain_model_subscription.gif'
    ],
    'interface' => [
        'showRecordFieldList' => 'sys_language_uid, l10n_parent, l10n_diffsource, hidden, days_left, start_date, expiration_date, subscription_offer, fe_user, payment_method, transaction_id, transaction_amount, transaction_currency',
    ],
    'types' => [
        '1' => ['showitem' => 'sys_language_uid, l10n_parent, l10n_diffsource, hidden, days_left, start_date, expiration_date, subscription_offer, fe_user, payment_method, transaction_id, transaction_amount, transaction_currency, --div--;LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:tabs.access, starttime, endtime'],
    ],
    'columns' => [
        'sys_language_uid' => [
            'exclude' => true,
            'label' => 'LLL:EXT:lang/locallang_general.xlf:LGL.language',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'special' => 'languages',
                'items' => [
                    [
                        'LLL:EXT:lang/locallang_general.xlf:LGL.allLanguages',
                        -1,
                        'flags-multiple'
                    ]
                ],
                'default' => 0,
            ],
        ],
        'l10n_parent' => [
            'displayCond' => 'FIELD:sys_language_uid:>:0',
            'exclude' => true,
            'label' => 'LLL:EXT:lang/locallang_general.xlf:LGL.l18n_parent',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'items' => [
                    ['', 0],
                ],
                'foreign_table' => 'tx_igruckzuckevent_domain_model_subscription',
                'foreign_table_where' => 'AND tx_igruckzuckevent_domain_model_subscription.pid=###CURRENT_PID### AND tx_igruckzuckevent_domain_model_subscription.sys_language_uid IN (-1,0)',
            ],
        ],
        'l10n_diffsource' => [
            'config' => [
                'type' => 'passthrough',
            ],
        ],
        't3ver_label' => [
            'label' => 'LLL:EXT:lang/locallang_general.xlf:LGL.versionLabel',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'max' => 255,
            ],
        ],
        'hidden' => [
            'exclude' => true,
            'label' => 'LLL:EXT:lang/locallang_general.xlf:LGL.hidden',
            'config' => [
                'type' => 'check',
                'renderType' => 'checkboxToggle',
                'items' => [
                    '1' => [
                        '0' => 'LLL:EXT:lang/locallang_core.xlf:labels.enabled'
                    ]
                ],
            ],
        ],
        'starttime' => [
            'exclude' => true,
            'l10n_mode' => 'mergeIfNotBlank',
            'label' => 'LLL:EXT:lang/locallang_general.xlf:LGL.starttime',
            'config' => [
                'type' => 'input',
                'size' => 13,
                'eval' => 'datetime',
                'default' => 0,
            ]
        ],
        'endtime' => [
            'exclude' => true,
            'l10n_mode' => 'mergeIfNotBlank',
            'label' => 'LLL:EXT:lang/locallang_general.xlf:LGL.endtime',
            'config' => [
                'type' => 'input',
                'size' => 13,
                'eval' => 'datetime',
                'default' => 0,
                'range' => [
                    'upper' => mktime(0, 0, 0, 1, 1, 2038)
                ]
            ],
        ],
        'days_left' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_ruckzuckevent/Resources/Private/Language/locallang_db.xlf:tx_igruckzuckevent_domain_model_subscription.days_left',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'integer',
            ],
        ],
        'start_date' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_ruckzuckevent/Resources/Private/Language/locallang_db.xlf:tx_igruckzuckevent_domain_model_subscription.start_date',
            'config' => [
                'dbType' => 'date',
                'type' => 'input',
                'renderType' => 'inputDateTime',
                'size' => 7,
                'eval' => 'date,null',
                'default' => '0000-00-00'
            ],
        ],
        'expiration_date' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_ruckzuckevent/Resources/Private/Language/locallang_db.xlf:tx_igruckzuckevent_domain_model_subscription.expiration_date',
            'config' => [
                'dbType' => 'date',
                'type' => 'input',
                'renderType' => 'inputDateTime',
                'size' => 7,
                'eval' => 'date,null',
                'default' => '0000-00-00'
            ],
        ],
        'subscription_offer' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_ruckzuckevent/Resources/Private/Language/locallang_db.xlf:tx_igruckzuckevent_domain_model_subscription.subscription_offer',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'foreign_table' => 'tx_igruckzuckevent_domain_model_subscriptionoffer',
                'minitems' => 0,
                'maxitems' => 1,
            ],
        ],
        'fe_user' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_ruckzuckevent/Resources/Private/Language/locallang_db.xlf:tx_igruckzuckevent_domain_model_subscription.fe_user',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'foreign_table' => 'fe_users',
                'minitems' => 0,
                'maxitems' => 1,
            ],
        ],
        'payment_method' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_ruckzuckevent/Resources/Private/Language/locallang_db.xlf:tx_igruckzuckevent_domain_model_registration.payment_method',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'transaction_id' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_ruckzuckevent/Resources/Private/Language/locallang_db.xlf:tx_igruckzuckevent_domain_model_registration.transaction_id',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'transaction_amount' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_ruckzuckevent/Resources/Private/Language/locallang_db.xlf:tx_igruckzuckevent_domain_model_registration.transaction_amount',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'transaction_currency' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_ruckzuckevent/Resources/Private/Language/locallang_db.xlf:tx_igruckzuckevent_domain_model_registration.transaction_currency',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
    ],
];
