<?php
defined('TYPO3') or die();

use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Information\Typo3Version;
use Ig\IgRuckzuckevent\Controller\CategoryBackendController;

$versionInformation = GeneralUtility::makeInstance(Typo3Version::class);
if($versionInformation->getMajorVersion() < 12) {
\Internetgalerie\IgBackendHelpers\Utility\ExtensionUtility::registerMainModule(
    'IgRuckzuckevent',
    'after:file',
    [
        'routeName' => 'IgRuckzuckeventFrame',
        'access' => 'group,user',
        'workspaces'=> 'online',
        'icon' => 'EXT:ig_ruckzuckevent/Resources/Public/Icons/folder-module-igruckzuckevent.svg',
        'labels' => 'LLL:EXT:ig_ruckzuckevent/Resources/Private/Language/locallang_nav.xlf'
    ]
);

\TYPO3\CMS\Extbase\Utility\ExtensionUtility::registerModule(
    'IgRuckzuckevent',
    'IgRuckzuckevent', // Make module a submodule of
    'tx_IgRuckzuckeventBackendCategory', // Submodule key
    'top',
    [
           CategoryBackendController::class => 'index',
    ],
    [
        'access' => 'user,group',
        'workspaces'=> 'online',
        'icon' => 'EXT:ig_backend_helpers/Resources/Public/Icons/module-db-entry.svg',
        'labels' => 'LLL:EXT:ig_ruckzuckevent/Resources/Private/Language/locallang_nav_category.xlf',
        'navigationComponentId' => 'TYPO3/CMS/IgRuckzuckevent/Tree/CategoryTreeElement',

    ]
);

\TYPO3\CMS\Extbase\Utility\ExtensionUtility::registerModule(
    'IgRuckzuckevent',
    'IgRuckzuckevent', // Make module a submodule of
    'tx_IgRuckzuckeventBackendEvent', // Submodule key
    'after:tx_IgRuckzuckeventBackendCategory',
    [
           \Ig\IgRuckzuckevent\Controller\EventBackendController::class => 'index,listParticipants,exportRegistrations,deleteRegistration,deleteRegistrations,deleteEvent',
    ],
    [
        'access' => 'user,group',
        'workspaces'=> 'online',
        'icon' => 'EXT:ig_backend_helpers/Resources/Public/Icons/module-db-entry.svg',
        'labels' => 'LLL:EXT:ig_ruckzuckevent/Resources/Private/Language/locallang_nav_event.xlf',
        'navigationComponentId' => 'TYPO3/CMS/IgRuckzuckevent/Tree/CategoryTreeElement',

    ]
);
}
