<?php

namespace Ig\IgRuckzuckevent\Controller;

use Ig\IgRuckzuckevent\Controller\TYPO3\CMS\Extbase\Annotation\IgnoreValidation;
use Ig\IgRuckzuckevent\Controller\TYPO3\CMS\Extbase\Annotation\Validate;
use Ig\IgRuckzuckevent\Domain\Model\Organizer;
use Ig\IgRuckzuckevent\Domain\Repository\OrganizerRepository;
use Internetgalerie\IgDynval\Controller\DynamicValidationActionController;
use Internetgalerie\IgDynval\Validation\Validator\DynamicValidator;
use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Extbase\Annotation\IgnoreValidation as AnnotationIgnoreValidation;
use TYPO3\CMS\Extbase\Annotation\Validate as AnnotationValidate;

class OrganizerController extends \Internetgalerie\IgDatapoolFe\Controller\ActionController
{
    use DynamicValidationActionController;

    /**
     * The repository for organizers
     *
     * @var OrganizerRepository
     */
    protected $organizerRepository = null;

    public function injectOrganizerRepository(OrganizerRepository $organizerRepository): void
    {
        $this->organizerRepository = $organizerRepository;
    }

    public function initializeView($view): void
    {
        $this->view->assign('controller', 'Organizer');
        $this->view->assign('pageUid', $this->request->getAttribute('frontend.page.information')?->getId());
    }

    /**
     * Liast all events with possibility to sort and filter them
     */
    public function listAction(): ResponseInterface
    {
        $organizers = $this->organizerRepository->findAll();
        $this->view->assign('organizers', $organizers);

        return $this->htmlResponse();
    }

    /**
     * Liast all events with possibility to sort and filter them
     */
    public function organizerListAction(): ResponseInterface
    {
        $organizers = $this->organizerRepository->findAll();
        $this->view->assign('organizers', $organizers);

        return $this->htmlResponse();
    }

    /**
     * New action
     */
    public function newAction(): ResponseInterface
    {
        return $this->htmlResponse();
    }

    /**
     * Create action
     */
    #[AnnotationValidate([
        'validator' => DynamicValidator::class,
        'param' => 'newOrganizer',
    ])]
    public function createAction(Organizer $newOrganizer): ResponseInterface
    {
        $this->organizerRepository->add($newOrganizer);
        return $this->redirect('list');
    }

    /**
     * Edit action
     */
    #[AnnotationIgnoreValidation([])] // $organizer
    public function editAction(Organizer $organizer): ResponseInterface
    {
        $this->view->assign('organizer', $organizer);

        return $this->htmlResponse();
    }

    /**
     * Update action
     */
    #[AnnotationValidate([
        'validator' => DynamicValidator::class,
        'param' => 'organizer',
    ])]
    public function updateAction(Organizer $organizer): ResponseInterface
    {
        $this->organizerRepository->update($organizer);
        return $this->redirect('list');
    }

    /**
     * Delete action
     */
    public function deleteAction(Organizer $organizer): ResponseInterface
    {
        $this->organizerRepository->remove($organizer);
        return $this->redirect('list');
    }
}
