<?php

namespace Ig\IgRuckzuckevent\Controller;

use Ig\IgRuckzuckevent\Domain\Model\Event;
use Ig\IgRuckzuckevent\Domain\Repository\CategoryRepository;
use Internetgalerie\IgRecurrenceDate\Domain\Repository\EventgroupRepository;
use Ig\IgRuckzuckevent\Domain\Repository\EventRepository;
use Ig\IgRuckzuckevent\Domain\Repository\OrganizerRepository;
use Ig\IgRuckzuckevent\Domain\Repository\QualificationRepository;
use Ig\IgRuckzuckevent\Domain\Repository\SponsorRepository;
use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;

/***
 *
 * This file is part of the "Ruck Zuck Event" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2017 Simon Häsler <sh@internetgalerie.ch>, Internetgalerie AG
 *
 ***/

/**
 * The RestController offers a RESTful API for retrieving events.
 */
class RestController extends ActionController
{
    /**
     * The repository for events
     *
     * @var EventRepository
     */
    protected $eventRepository = null;

    /**
     * The repository for eventgroups
     *
     * @var EventgroupRepository
     */
    protected $eventgroupRepository = null;

    /**
     * The repository for categories
     *
     * @var CategoryRepository
     */
    protected $categoryRepository = null;

    /**
     * The repository for sponsors
     *
     * @var SponsorRepository
     */
    protected $sponsorRepository = null;

    /**
     * The repository for organizers
     *
     * @var OrganizerRepository
     */
    protected $organizerRepository = null;

    /**
     * The repository for qualifications
     *
     * @var QualificationRepository
     */
    protected $qualificationRepository = null;

    /**
     * Upload file service for handling uploaded files
     */
    protected $uploadFileService = null;

    public function injectEventRepository(EventRepository $eventRepository): void
    {
        $this->eventRepository = $eventRepository;
    }

    public function injectEventgroupRepository(EventgroupRepository $eventgroupRepository): void
    {
        $this->eventgroupRepository = $eventgroupRepository;
    }

    public function injectCategoryRepository(CategoryRepository $categoryRepository): void
    {
        $this->categoryRepository = $categoryRepository;
    }

    public function injectSponsorRepository(SponsorRepository $sponsorRepository): void
    {
        $this->sponsorRepository = $sponsorRepository;
    }

    public function injectOrganizerRepository(OrganizerRepository $organizerRepository): void
    {
        $this->organizerRepository = $organizerRepository;
    }

    public function injectQualificationRepository(QualificationRepository $qualificationRepository): void
    {
        $this->qualificationRepository = $qualificationRepository;
    }

    public function eventListAction(): ResponseInterface
    {
        //$currentPage = $this->request->hasArgument('currentPage') ? (int) $this->request->getArgument('currentPage') : 1;

        $events = $this->eventRepository->findBySearchAndSorting($this->getSearch(), $this->getSorting());

        //$paginator = new QueryResultPaginator($events, $currentPage, 20);
        //$pagination = new NumberedPagination($paginator, 10); // zweiter Argument: maximal Anzahl Links

        $site = $GLOBALS['TYPO3_REQUEST']->getAttribute('site');

        $json = [];
        foreach ($events as $item) {
            $row = $item->getJson();
            $row['detailLink'] = $this->uriBuilder
                ->reset()
                ->setCreateAbsoluteUri(true)
                ->setTargetPageUid($this->settings['detailPageUid'])
                ->uriFor('show', [
                    'event' => $item->getUid(),
                ], 'Event', 'IgRuckzuckevent', 'EventDetail');
            $row['registrationLink'] = $this->uriBuilder
                ->reset()
                ->setCreateAbsoluteUri(true)
                ->setTargetPageUid($this->settings['registrationPageUid'])
                ->uriFor('new', [
                    'event' => $item->getUid(),
                ], 'Registration', 'IgRuckzuckevent', 'Registration');
            $json[] = $row;
        }

        return $this->jsonResponse(json_encode($json));
    }

    public function eventShowAction(Event $event): ResponseInterface
    {
        $json = $event->getJson();
        $json['detailLink'] = $this->uriBuilder
            ->reset()
            ->setCreateAbsoluteUri(true)
            ->setTargetPageUid($this->settings['detailPageUid'])
            ->uriFor('show', [
                'event' => $event->getUid(),
            ], 'Event', 'IgRuckzuckevent', 'EventDetail');
        $json['registrationLink'] = $this->uriBuilder
            ->reset()
            ->setCreateAbsoluteUri(true)
            ->setTargetPageUid($this->settings['registrationPageUid'])
            ->uriFor('new', [
                'event' => $event->getUid(),
            ], 'Registration', 'IgRuckzuckevent', 'Registration');

        return $this->jsonResponse(json_encode($json));
    }

    /**
     * Get the search array
     *
     * @return array
     */
    private function getSearch()
    {
        $search = [];
        if ($this->request) {
            $arguments = $this->request->getArguments();
        } elseif (($this->request->getParsedBody()['tx_igruckzuckevent_events'] ?? $this->request->getQueryParams()['tx_igruckzuckevent_events'] ?? null) && ($this->request->getParsedBody()['tx_igruckzuckevent_events'] ?? $this->request->getQueryParams()['tx_igruckzuckevent_events'] ?? null)['search']) {
            $arguments = ($this->request->getParsedBody()['tx_igruckzuckevent_events'] ?? $this->request->getQueryParams()['tx_igruckzuckevent_events'] ?? null)['search'];
        } elseif (($this->request->getParsedBody()['tx_igruckzuckevent_eventsarchive'] ?? $this->request->getQueryParams()['tx_igruckzuckevent_eventsarchive'] ?? null) && ($this->request->getParsedBody()['tx_igruckzuckevent_eventsarchive'] ?? $this->request->getQueryParams()['tx_igruckzuckevent_eventsarchive'] ?? null)['search']) {
            $arguments = [];
        }
        if (isset($arguments['search'])) {
            $search = $arguments['search'];
        }
        $this->view->assign('search', $search);
        return $search;
    }

    /**
     * Get the sorting array for the repository
     *
     * @return array
     */
    private function getSorting()
    {
        $sorting = [];
        if ($this->request) {
            $arguments = $this->request->getArguments();
        } else {
            $arguments = [];
        }
        if (isset($arguments['sorting'])) {
            $sorting = $arguments['sorting'];
        } elseif (($this->request->getParsedBody()['tx_igruckzuckevent_events'] ?? $this->request->getQueryParams()['tx_igruckzuckevent_events'] ?? null) && ($this->request->getParsedBody()['tx_igruckzuckevent_events'] ?? $this->request->getQueryParams()['tx_igruckzuckevent_events'] ?? null)['sorting']) {
            $arguments = ($this->request->getParsedBody()['tx_igruckzuckevent_events'] ?? $this->request->getQueryParams()['tx_igruckzuckevent_events'] ?? null)['sorting'];
        } else {
            // If no sorting was requested, use default sorting
            $sorting = [];
            $sorting['field'] = 'dateFrom';
            $sorting['direction']['dateFrom'] = 'ASC';
            $sorting['direction']['title'] = 'ASC';
        }
        // This is the sorting array given to the repository
        $sortingArr = [
            $sorting['field'] => $sorting['direction'][$sorting['field']],
        ];
        if ($sorting['field'] == 'dateFrom') {
            $sortingArr['timeFrom'] = $sorting['direction'][$sorting['field']];
        }
        // If the current sorting direction of the current sorting field is ASC, switch it  to DESC, but all others stay at ASC
        // Else switch all sorting directions to ASC
        $currentSorting = $sorting;
        if ($sorting['direction'][$sorting['field']] == 'ASC') {
            foreach ($sorting['direction'] as &$sortingDirection) {
                $sortingDirection = 'ASC';
            }
            $sorting['direction'][$sorting['field']] = 'DESC';
        } else {
            foreach ($sorting['direction'] as &$sortingDirection) {
                $sortingDirection = 'ASC';
            }
        }
        $this->view->assign('currentSorting', $currentSorting);
        $this->view->assign('sorting', $sorting);
        return $sortingArr;
    }
}
