<?php

namespace Ig\IgRuckzuckevent\Controller;

use Ig\IgRuckzuckevent\Controller\TYPO3\CMS\Extbase\Annotation\IgnoreValidation;
use Ig\IgRuckzuckevent\Controller\TYPO3\CMS\Extbase\Annotation\Validate;
use Ig\IgRuckzuckevent\Domain\Model\Sponsor;
use Ig\IgRuckzuckevent\Domain\Repository\SponsorRepository;
use Internetgalerie\IgDynval\Controller\DynamicValidationActionController;
use Internetgalerie\IgDynval\Validation\Validator\DynamicValidator;
use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Extbase\Annotation\IgnoreValidation as AnnotationIgnoreValidation;
use TYPO3\CMS\Extbase\Annotation\Validate as AnnotationValidate;

/***
 *
 * This file is part of the "Ruck Zuck Event" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2017 Simon Häsler <sh@internetgalerie.ch>, Internetgalerie AG
 *
 ***/

/**
 * The EventController handles all actions directly related to Events.
 */
class SponsorController extends \Internetgalerie\IgDatapoolFe\Controller\ActionController
{
    use DynamicValidationActionController;

    /**
     * The repository for sponsors
     *
     * @var SponsorRepository
     */
    protected $sponsorRepository = null;

    public function injectSponsorRepository(SponsorRepository $sponsorRepository): void
    {
        $this->sponsorRepository = $sponsorRepository;
    }

    public function initializeView($view): void
    {
        $this->view->assign('controller', 'Sponsor');
        $this->view->assign('pageUid', $this->request->getAttribute('frontend.page.information')?->getId());
    }

    public function listAction(): ResponseInterface
    {
        $sponsors = $this->sponsorRepository->findAll();
        $this->view->assign('sponsors', $sponsors);

        return $this->htmlResponse();
    }

    /**
     * New action
     */
    public function newAction(): ResponseInterface
    {
        return $this->htmlResponse();
    }

    /**
     * Create action
     */
    #[AnnotationValidate([
        'validator' => DynamicValidator::class,
        'param' => 'newSponsor',
    ])]
    public function createAction(Sponsor $newSponsor): ResponseInterface
    {
        $this->sponsorRepository->add($newSponsor);
        return $this->redirect('list');
    }

    /**
     * Edit action
     */
    #[AnnotationIgnoreValidation([])] // $sponsor
    public function editAction(Sponsor $sponsor): ResponseInterface
    {
        $this->view->assign('sponsor', $sponsor);

        return $this->htmlResponse();
    }

    /**
     * Update action
     */
    #[AnnotationValidate([
        'validator' => DynamicValidator::class,
        'param' => 'sponsor',
    ])]
    public function updateAction(Sponsor $sponsor): ResponseInterface
    {
        $this->sponsorRepository->update($sponsor);
        return $this->redirect('list');
    }

    /**
     * Delete action
     */
    #[AnnotationIgnoreValidation([])] // $sponsor
    public function deleteAction(Sponsor $sponsor): ResponseInterface
    {
        $this->sponsorRepository->remove($sponsor);
        return $this->redirect('list');
    }
}
