<?php

namespace Ig\IgRuckzuckevent\Domain\Model;

use Ig\IgRuckzuckevent\Domain\Model\TYPO3\CMS\Extbase\Annotation\ORM\Cascade;
use Ig\IgRuckzuckevent\Utility\JsonUtility;
use TYPO3\CMS\Extbase\Annotation\ORM\Cascade as ORMCascade;
use TYPO3\CMS\Extbase\Domain\Model\FileReference;
use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;

/***
 *
 * This file is part of the "Ruck Zuck Event" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2018 Simon Häsler <sh@internetgalerie.ch>, Internetgalerie AG
 *
 ***/


class Sponsor extends AbstractEntity
{
    /**
     * title
     *
     * @var string
     */
    protected $title = '';

    /**
     * link
     *
     * @var string
     */
    protected $link = '';

    /**
     * logo
     *
     * @var FileReference
     */
    #[ORMCascade([
        'value' => 'remove',
    ])]
    protected $logo = null;

    /**
     * Returns the title
     *
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Sets the title
     *
     * @param string $title
     */
    public function setTitle($title): void
    {
        $this->title = $title;
    }

    /**
     * Returns the link
     *
     * @return string
     */
    public function getLink()
    {
        return $this->link;
    }

    /**
     * Sets the link
     *
     * @param string $link
     */
    public function setLink($link): void
    {
        $this->link = $link;
    }

    /**
     * Returns the logo
     *
     * @return FileReference
     */
    public function getLogo()
    {
        return $this->logo;
    }

    /**
     * Sets the logo
     *
     * @param FileReference $logo
     */
    public function setLogo($logo): void
    {
        $this->logo = $logo;
    }

    /**
     * Returns the logo
     *
     * @return ObjectStorage<FileReference> $logo
     */
    public function getLogos()
    {
        return $this->logo;
    }

    /**
     * Sets the logo
     *
     * @param ObjectStorage<FileReference> $logo
     */
    public function setLogos(ObjectStorage $logo): void
    {
        $this->logo = $logo;
    }

    /**
     * Adds an logo
     */
    public function addLogo(FileReference $logo): void
    {
        $this->logo->attach($logo);
    }

    /**
     * Removes an logo
     *
     * @param FileReference $logoToRemove The file to be removed
     */
    public function removeLogo(FileReference $logoToRemove): void
    {
        $this->logo->detach($logoToRemove);
    }

    public function getJson()
    {
        return JsonUtility::getJsonForProperties($this->_getProperties());
    }
}
