<?php

namespace Ig\IgRuckzuckevent\Domain\Repository;

use DateTime;
use Ig\IgRuckzuckevent\Domain\Model\Event;
use Internetgalerie\IgRecurrenceDate\Domain\Model\Eventgroup;
use Ig\IgRuckzuckevent\Utility\UserUtility;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Persistence\QueryInterface;
use TYPO3\CMS\Extbase\Persistence\Repository;

/**
 * The repository for Events
 */
class EventRepository extends Repository
{
    /**
     * @var array
     */
    protected $defaultOrderings = [
        'dateFrom' => QueryInterface::ORDER_ASCENDING,
    ];

    /**
     * @var bool
     */
    protected $showOnlyActiveEntries = true;

    public function setShowOnlyActiveEntries($showOnlyActiveEntries): void
    {
        $this->showOnlyActiveEntries = $showOnlyActiveEntries;
    }
    public function getShowOnlyActiveEntries()
    {
        return $this->showOnlyActiveEntries;
    }

    public function setStoragePid($pid): void
    {
        $querySettings = $this->createQuery()
->getQuerySettings();

        $querySettings->setStoragePageIds([$pid]);

        $this->setDefaultQuerySettings($querySettings);
    }

    /**
     * return events with given search
     */
    public function findBySearchAndSorting(array $search = [], array $sorting = [
        'dateFrom' => 'ASC',
        'timeFrom' => 'ASC',
    ], int $limit = 0)
    {
        $query = $this->createQuery();
        $constraints = [];


        $ignoreToday = $search['ignoreToday'] ?? false;
        $withoutDate = $search['withoutDate'] ?? false;
        
        if (!$ignoreToday && !$withoutDate) {
            // For default, only get the events that are oncoming
            $dateTime = new DateTime();
            $constraints[] = $query->greaterThanOrEqual('dateFrom', $dateTime->format('Y-m-d'));
        }
        
        if ($ignoreToday && !$withoutDate) {
            $dateTime = new DateTime();
            $constraints[] = $query->lessThan('dateFrom', $dateTime->format('Y-m-dT00:00:00'));
            $constraints[] = $query->logicalNot($query->equals('dateFrom', null));
            //$constraints[] = $query->logicalNot($query->equals('dateFrom', ''));
        }
        if ($withoutDate) {
            $constraints[] = $query->equals('dateFrom', null);
        }


        // Handle search if not empty
        // Search by the date from entered in the search form
        if ($search['dateFrom'] ?? false) {
            $dateFrom = null;
            if (is_array(
                $search['dateFrom']
            ) && isset($search['dateFrom']['date']) && $search['dateFrom']['date'] != '') {
                $dateFrom = new DateTime($search['dateFrom']['date']);
            } elseif (!is_array($search['dateFrom']) && $search['dateFrom'] != '') {
                $dateFrom = new DateTime($search['dateFrom']);
            }
            if ($dateFrom) {
                $constraints[] = $query->greaterThanOrEqual('dateFrom', $dateFrom->format('Y-m-d'));
            }
            //$constraints[] = $query->greaterThanOrEqual('dateFrom', $dateFrom->format('Y-m-dT00:00:00'));//TODO Datetime
        }
        /*
            else if (!$ignoreToday && !$withoutDate) {
                // For default, only get upcoming events
                $dateTime = new \DateTime();
                $constraints[] = $query->greaterThanOrEqual('dateFrom', $dateTime->format('Y-m-d'));
            }
        */
        // Search by the date to entered in the search form
        if ($search['dateTo'] ?? false) {
            $dateTo = null;
            if (is_array($search['dateTo']) && isset($search['dateTo']['date']) && $search['dateTo']['date'] != '') {
                $dateTo = new DateTime($search['dateTo']['date']);
            } elseif (!is_array($search['dateTo']) && $search['dateTo'] != '') {
                $dateTo = new DateTime($search['dateTo']);
            }
            if ($dateTo) {
                $constraints[] = $query->lessThanOrEqual('dateFrom', $dateTo->format('Y-m-d'));
            }
            //$constraints[] = $query->lessThanOrEqual('dateFrom', $dateTo->format('Y-m-dT00:00:00'));//TODO Datetime
        }
        if ($search['eventgroup'] ?? false) {
            $constraints[] = $query->equals('eventgroup', $search['eventgroup']);
        }
        // Search by searchword entered in the search form
        if ($search['searchword'] ?? false) {
            $searchwords = array_filter(GeneralUtility::trimExplode(' ', $search['searchword']));
            $searchwordConstraints = [];
            foreach($searchwords as $searchword) {
                $searchwordConstraints[] = $query->logicalOr(
                    $query->like('title', '%' . $searchword . '%'),
                    $query->like('subtitle', '%' . $searchword . '%'),
                    $query->like('description', '%' . $searchword . '%'),
                    $query->like('targetgroup', '%' . $searchword . '%'),
                    $query->like('targets', '%' . $searchword . '%'),
                    $query->like('contents', '%' . $searchword . '%'),
                    $query->like('workingmethods', '%' . $searchword . '%'),
                    $query->like('course_organizer', '%' . $searchword . '%'),
                    $query->like('datetimelabel', '%' . $searchword . '%'),
                    $query->like('duration', '%' . $searchword . '%'),
                    $query->like('place', '%' . $searchword . '%'),
                    $query->like('costs', '%' . $searchword . '%'),
                    $query->like('note', '%' . $searchword . '%'),
                    $query->like('competences', '%' . $searchword . '%'),
                    $query->like('cours_no', '%' . $searchword . '%'),
                    $query->like('teaser', '%' . $searchword . '%'),
                    $query->like('categories.name', '%' . $searchword . '%'),
                    $query->like('qualifications.name', '%' . $searchword . '%'),
                    $query->like('keywords', '%' . $searchword . '%')
                );
            }
            if (!empty($searchwordConstraints)) {
                $constraints[] = $query->logicalAnd(...$searchwordConstraints);
            }
        }
        if ($search['qualification'] ?? false) {
            $constraints[] = $query->contains('qualifications', $search['qualification']);
        }
        if ($search['tag'] ?? false) {
            $constraints[] = $query->equals($search['tag'], 1);
        }
        // Search by diplomiert
        if ($search['diplomiert'] ?? false) {
            $constraints[] = $query->equals('diplomiert', 1);
        }
        // Search by hebamme
        if ($search['hebamme'] ?? false) {
            $constraints[] = $query->equals('hebamme', 1);
        }
        // Search by dni
        if ($search['dni'] ?? false) {
            $constraints[] = $query->equals('dni', 1);
        }
        // Search by fage
        if ($search['fage'] ?? false) {
            $constraints[] = $query->equals('fage', 1);
        }
        // Search by fabe
        if ($search['fabe'] ?? false) {
            $constraints[] = $query->equals('fabe', 1);
        }
        // Search by ags
        if ($search['ags'] ?? false) {
            $constraints[] = $query->equals('ags', 1);
        }
        // Search by assistent
        if ($search['assistent'] ?? false) {
            $constraints[] = $query->equals('assistent', 1);
        }
        // Search by otherJobMed
        if ($search['otherJobMed'] ?? false) {
            $constraints[] = $query->equals('otherJobMed', 1);
        }
        // Search by otherJob
        if ($search['otherJob'] ?? false) {
            $constraints[] = $query->equals('otherJob', 1);
        }
        // Search by category
        if ($search['category'] ?? false) {
            $constraints[] = $query->contains('categories', $search['category']);
        }




        if ($this->showOnlyActiveEntries) {
            $constraints[] = $query->equals('active', true);
        }

        if (!empty($constraints)) {
            $query->matching($query->logicalAnd(...$constraints));
        }
        $query->setOrderings($sorting);

        if ($limit > 0) {
            $query->setLimit($limit);
        }

        return $query->execute();
    }

    /*
     * Function for Physio Team
     */
    public function findCurrentEvent(Eventgroup $eventgroup)
    {
        $query = $this->createQuery();

        if (UserUtility::isAdminLoggedIn()) {
            $inOneHour = new DateTime();
            $inOneHour->modify('-2 month');
        } else {
            $inOneHour = new DateTime();
            $inOneHour->modify('+1 hour');
        }
        $inTwoMonths = new DateTime();
        $inTwoMonths->modify('+2 month');

        $constraints = [];
        $constraints[] = $query->equals('eventgroup', $eventgroup);
        if ($this->showOnlyActiveEntries) {
            $constraints[] = $query->equals('active', true);
        }

        $constraints[] = $query->logicalAnd(
            $query->lessThanOrEqual('dateFrom', $inTwoMonths->format('Y-m-d')),
            $query->logicalOr(
                $query->greaterThan('dateFrom', $inOneHour->format('Y-m-d')),
                $query->logicalAnd(
                    $query->equals('dateFrom', $inOneHour->format('Y-m-d')),
                    $query->greaterThanOrEqual('timeFrom', ($inOneHour->getTimestamp() % 86400))
                )
            )
        );

        $query->matching($query->logicalAnd(...$constraints));
        /*
        if(  $eventgroup->getUid()==18) {
          $q=$query->execute();
          echo('Resultate=='.count($q));
          $f=$q->getFirst();
          echo('a='.count($q));
          exit(0);
        }
        */
        return $query->execute()
->getFirst();
    }


    public function findForShow(Event $event)
    {
        $query = $this->createQuery();


        if (UserUtility::isAdminLoggedIn()) {
            $inOneHour = new DateTime();
            $inOneHour->modify('-2 month');
        } else {
            $inOneHour = new DateTime();
            $inOneHour->modify('+1 hour');
        }
        $inTwoMonths = new DateTime();
        $inTwoMonths->modify('+2 month');

        $constraints = [];
        $constraints[] = $query->equals('title', $event->getTitle());
        //$constraints[] = $query->equals('subtitle', $event->getSubtitle());
        $constraints[] = $query->logicalAnd(
            $query->lessThanOrEqual('dateFrom', $inTwoMonths->format('Y-m-d')),
            $query->logicalOr(
                $query->greaterThan('dateFrom', $inOneHour->format('Y-m-d')),
                $query->logicalAnd(
                    $query->equals('dateFrom', $inOneHour->format('Y-m-d')),
                    $query->greaterThanOrEqual('timeFrom', ($inOneHour->getTimestamp() % 86400))
                )
            )
        );

        $query->matching($query->logicalAnd(...$constraints));

        return $query->execute();
    }


    public function findForReminder()
    {
        $query = $this->createQuery();

        $tomorrow = new DateTime();
        $tomorrow->modify('+1 day');

        $query->matching($query->lessThanOrEqual('dateFrom', $tomorrow->format('Y-m-d')));

        return $query->execute();
    }

    public function findPassedByTitle($title)
    {
        $query = $this->createQuery();

        $today = new DateTime();
        $aYearAgo = clone $today;
        $aYearAgo->modify('-1 year');

        $constraints = [];

        $constraints[] = $query->like('title', '%' . $title . '%');
        $constraints[] = $query->greaterThanOrEqual('dateFrom', $aYearAgo->format('Y-m-d'));
        $constraints[] = $query->lessThanOrEqual('dateFrom', $today->format('Y-m-d'));

        $query->matching($query->logicalAnd(...$constraints));

        return $query->execute();
    }




    public function countEventInNextYear(Eventgroup $eventgroup)
    {
        $now = new DateTime();
        $nowPlusYear = new DateTime();
        $nowPlusYear->modify('+1 year');

        $query = $this->createQuery();

        $query->matching(
            $query->logicalAnd(
                $query->equals('eventgroup', $eventgroup),
                $query->greaterThanOrEqual('dateFrom', $now->format('Y-m-d')),
                $query->lessThanOrEqual('dateFrom', $nowPlusYear->format('Y-m-d'))
            )
        );


        return $query->count();
    }
    public function findEventInNextYear(Eventgroup $eventgroup)
    {
        $now = new DateTime();
        $nowPlusYear = new DateTime();
        $nowPlusYear->modify('+1 year');

        $query = $this->createQuery();

        $query->matching(
            $query->logicalAnd(
                $query->equals('eventgroup', $eventgroup),
                $query->greaterThanOrEqual('dateFrom', $now->format('Y-m-d')),
                $query->lessThanOrEqual('dateFrom', $nowPlusYear->format('Y-m-d'))
            )
        );


        return $query->execute();
    }
}
