<?php

namespace Ig\IgRuckzuckevent\Domain\Validator;

use Ig\IgRuckzuckevent\Domain\Model\FeUser;
use TYPO3\CMS\Core\Crypto\PasswordHashing\PasswordHashFactory;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Validation\Validator\AbstractValidator;

/***
 *
 * This file is part of the "Ruck Zuck Event" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2017 Simon Häsler <sh@internetgalerie.ch>, Internetgalerie AG
 *
 ***/

/**
 * The password confirmation validator validates a password with its confirmation for registration and password update forms
 */
class PasswordChangeValidator extends AbstractValidator
{
    /**
     * Checks if the password is valid with its confirmation
     *
     * @param FeUser $user
     */
    public function isValid($user): void
    {
        $oldPassword = ($GLOBALS['TYPO3_REQUEST']->getParsedBody()['tx_igruckzuckevent_events'] ?? null)['oldPassword'];
        
        if (!$oldPassword) {
            $oldPassword = ($GLOBALS['TYPO3_REQUEST']->getParsedBody()['tx_igruckzuckevent_management'] ?? null)['oldPassword'];
        }
        if (!$oldPassword) {
            $oldPassword = ($GLOBALS['TYPO3_REQUEST']->getParsedBody()['tx_igruckzuckevent_user'] ?? null)['oldPassword'];
        }
        
        $hashFactory = GeneralUtility::makeInstance(PasswordHashFactory::class);
        if (!$hashFactory->get($user->getPassword(), 'FE')->checkPassword($oldPassword, $user->getPassword())) {
            $this->addError('Old password is wrong', 149121114);
        }
    }
}
