<?php

namespace Ig\IgRuckzuckevent\Event;

use Ig\IgRuckzuckevent\Domain\Model\Event;
use Psr\EventDispatcher\StoppableEventInterface;
use TYPO3\CMS\Fluid\View\FluidViewAdapter;
use TYPO3\CMS\Fluid\View\TemplateView;

final class BeforeRenderDetailViewEvent implements StoppableEventInterface
{
    public function __construct(
        private TemplateView|FluidViewAdapter $view,
        private Event $event
    ) {
    }
 
    public function getView(): null|TemplateView|FluidViewAdapter
    {
        return $this->view;
    }

 
    public function setView(TemplateView|FluidViewAdapter $view): void
    {
        $this->view = $view;
    }
    public function isPropagationStopped(): bool
    {
        return false;
        // return !empty($this->data);
    }
 
    public function getEvent(): Event
    {
        return $this->event;
    }

    public function setEvent(Event $event)
    {
        $this->event = $event;

        return $this;
    }
}
