<?php

namespace Ig\IgRuckzuckevent\ViewHelpers;

use Ig\IgRuckzuckevent\Domain\Model\Event;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractConditionViewHelper;

class IsFieldRequiredViewHelper extends AbstractConditionViewHelper
{
    public function initializeArguments(): void
    {
        parent::initializeArguments();

        $this->registerArgument(
            'event',
            Event::class,
            'Event object containing field requirement information',
            true
        );

        $this->registerArgument(
            'field',
            'string',
            'Field name to check for requirement',
            true
        );
    }

    public static function verdict(array $arguments, RenderingContextInterface $renderingContext): bool
    {
        $event = $arguments['event'];
        $field = $arguments['field'];

        if ($event instanceof Event) {
            return $event->isFieldRequired($field);
        }

        return false;
    }
}
