<?php
use TYPO3\CMS\Extbase\Utility\ExtensionUtility;
use TYPO3\CMS\Core\Utility\ExtensionManagementUtility;

defined('TYPO3') or die();

// TYPO3 13: Register plugins with CType instead of list_type
ExtensionUtility::registerPlugin(
    'IgRuckzuckevent',
    'EventManagement',
    'Ruck Zuck Event: Event Management',
    'ig_ruckzuckevent-plugin-management',
    ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
);

ExtensionUtility::registerPlugin(
    'IgRuckzuckevent',
    'EventsInProcessing',
    'Ruck Zuck Event: Kurse in Bearbeitung',
    'ig_ruckzuckevent-plugin-eventsInProcessing',
    ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
);

ExtensionUtility::registerPlugin(
    'IgRuckzuckevent',
    'EventsArchive',
    'Ruck Zuck Event: Abgelaufene Kurse',
    'ig_ruckzuckevent-plugin-eventsArchive',
    ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
);

ExtensionUtility::registerPlugin(
    'IgRuckzuckevent',
    'CategoryManagement',
    'Ruck Zuck Event: Category Management',
    'ig_ruckzuckevent-plugin-management',
    ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
);

ExtensionUtility::registerPlugin(
    'IgRuckzuckevent',
    'SponsorManagement',
    'Ruck Zuck Event: Sponsor Management',
    'ig_ruckzuckevent-plugin-management',
    ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
);

ExtensionUtility::registerPlugin(
    'IgRuckzuckevent',
    'FeedbackManagement',
    'Ruck Zuck Event: Feedback Management',
    'ig_ruckzuckevent-plugin-feedback',
    ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
);

ExtensionUtility::registerPlugin(
    'IgRuckzuckevent',
    'OrganizerManagement',
    'Ruck Zuck Event: Organizer Management',
    'ig_ruckzuckevent-plugin-management',
    ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
);

ExtensionUtility::registerPlugin(
    'IgRuckzuckevent',
    'Events',
    'Ruck Zuck Event: Anzeige und Anmeldung',
    'ig_ruckzuckevent-plugin-events',
    ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
);

ExtensionUtility::registerPlugin(
    'IgRuckzuckevent',
    'EventListFromJson',
    'Ruck Zuck Event: Ausgabe Liste aus JSON',
    'ig_ruckzuckevent-plugin-events',
    ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
);

ExtensionUtility::registerPlugin(
    'IgRuckzuckevent',
    'EventDetailFromJson',
    'Ruck Zuck Event: Ausgabe Detailansicht aus JSON',
    'ig_ruckzuckevent-plugin-events',
    ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
);

$currentEventsCtype = ExtensionUtility::registerPlugin(
    'IgRuckzuckevent',
    'CurrentEvents',
    'Ruck Zuck Event: Aktuelle Events',
    'ig_ruckzuckevent-plugin-events',
    ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
);

$registrationCtype = ExtensionUtility::registerPlugin(
    'IgRuckzuckevent',
    'Registration',
    'Ruck Zuck Event: Anmeldung Event',
    'ig_ruckzuckevent-plugin-events',
    ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
);

ExtensionUtility::registerPlugin(
    'IgRuckzuckevent',
    'ThankYou',
    'Ruck Zuck Event: Danke Seite Event',
    'ig_ruckzuckevent-plugin-events',
    ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
);

ExtensionUtility::registerPlugin(
    'IgRuckzuckevent',
    'Feedback',
    'Ruck Zuck Event: Feedbackliste',
    'ig_ruckzuckevent-plugin-feedback',
    ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
);

ExtensionUtility::registerPlugin(
    'IgRuckzuckevent',
    'SearchForm',
    'Ruck Zuck Event: Suchformular',
    'ig_ruckzuckevent-plugin-events',
    ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
);

ExtensionUtility::registerPlugin(
    'IgRuckzuckevent',
    'Create',
    'Ruck Zuck Event: Event erstellen',
    'ig_ruckzuckevent-plugin-events',
    ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
);

ExtensionUtility::registerPlugin(
    'IgRuckzuckevent',
    'ManagementStatistik',
    'Ruck Zuck Event: Management Registration Statistik',
    'ig_ruckzuckevent-plugin-management',
    ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
);

ExtensionUtility::registerPlugin(
    'IgRuckzuckevent',
    'ManagementUser',
    'Ruck Zuck Event: Management User',
    'ig_ruckzuckevent-plugin-management',
    ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
);

ExtensionUtility::registerPlugin(
    'IgRuckzuckevent',
    'User',
    'Ruck Zuck Event: Benutzerverwaltung',
    'ig_ruckzuckevent-plugin-management',
    ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
);

ExtensionUtility::registerPlugin(
    'IgRuckzuckevent',
    'EventsCalendar',
    'Ruck Zuck Event: Kalender Anzeige und Anmeldung',
    'ig_ruckzuckevent-plugin-events',
    ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
);

ExtensionUtility::registerPlugin(
    'IgRuckzuckevent',
    'Management',
    'Ruck Zuck Event: Kalender Management',
    'ig_ruckzuckevent-plugin-management',
    ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
);

ExtensionUtility::registerPlugin(
    'IgRuckzuckevent',
    'Payment',
    'Ruck Zuck Event: Bezahlung Subscriptions/Abos',
    'ig_ruckzuckevent-plugin-management',
    ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
);

$eventDetailCtype = ExtensionUtility::registerPlugin(
    'IgRuckzuckevent',
    'EventDetail',
    'Ruck Zuck Event: Detailansicht Event',
    'ig_ruckzuckevent-plugin-events',
    ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
);

ExtensionUtility::registerPlugin(
    'IgRuckzuckevent',
    'Resteventlist',
    'Ruck Zuck Event: REST Event List',
    'ig_ruckzuckevent-plugin-events',
    ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
);

ExtensionUtility::registerPlugin(
    'IgRuckzuckevent',
    'Resteventshow',
    'Ruck Zuck Event: REST Event Show',
    'ig_ruckzuckevent-plugin-events',
    ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
);

/*ExtensionUtility::registerPlugin(
    'IgRuckzuckevent',
    'HtmlTitle',
    'Ruck Zuck Event: HTML Title',
    'ig_ruckzuckevent-plugin-events',
    ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
);*/

ExtensionUtility::registerPlugin(
    'IgRuckzuckevent',
    'SlugSuggest',
    'Ruck Zuck Event: Slug Suggest',
    'ig_ruckzuckevent-plugin-events',
    ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
);

// Add FlexForms
$flexformMapping = [
    $currentEventsCtype => 'FILE:EXT:ig_ruckzuckevent/Configuration/FlexForms/events_list_current.xml',
    $registrationCtype => 'FILE:EXT:ig_ruckzuckevent/Configuration/FlexForms/registration.xml',
    $eventDetailCtype => 'FILE:EXT:ig_ruckzuckevent/Configuration/FlexForms/event_detail.xml',
];

foreach($flexformMapping as $ctypeKey => $flexFormPath) {
    ExtensionManagementUtility::addToAllTCAtypes(
        'tt_content',
        '--div--;Plugin,pi_flexform,',
        $ctypeKey,
        'after:subheader',
    );
    ExtensionManagementUtility::addPiFlexFormValue(
        '*',
        $flexFormPath,
        $ctypeKey
    );
}
