document.addEventListener('DOMContentLoaded', function() {
    document.querySelectorAll('.deleteFileReferenceLink').forEach(function(link) {
        link.addEventListener('click', function(e) {
            e.preventDefault();

            var parent = this.parentElement;
            var image = parent.querySelector('img');
            var hiddenField = document.getElementById('imagesToDelete-' + this.dataset.fileReference);

            hiddenField.value = this.dataset.fileReference;
            parent.remove();
        });
    });
});

if (document.querySelectorAll('.dp-form-slug').length) {
    document.querySelectorAll('.dp-form-slug .icon').forEach(function(element) {
        element.addEventListener('click', function(e) {
            var dpFormSlug = element.closest('.dp-form-slug');
            var slugField = dpFormSlug.querySelector('input[type="text"]');
            var slugSuggestUrl = slugField.dataset.slugSuggestUrl
            var form = dpFormSlug.closest('form');

            /*var newPluginName = 'tx_igruckzuckevent_slugsuggest';
            data = data.replace(/tx_igruckzuckevent_eventmanagement/g, newPluginName)
                .replace(/tx_igruckzuckevent_eventsinprocessing/g, newPluginName)
                .replace(/tx_igruckzuckevent_eventsarchive/g, newPluginName)
                .replace(/newEvent/g, 'event');*/
            var identity = '';
            if(document.querySelectorAll('.event-form input[type="hidden"][name*="__identity"]').length) {
                identity = document.querySelector('.event-form input[type="hidden"][name*="__identity"]').value;
            }

            var data = {
                tx_igruckzuckevent_slugsuggest: {
                    event: {
                        title: document.querySelector('.event-form #title').value,
                        coursNo: document.querySelector('.event-form #coursNo').value,
                    },
                    __trustedProperties: document.querySelector('.event-form input[type="hidden"][name*="__trustedProperties"]').value
                }
            };

            if(identity) {
                data.tx_igruckzuckevent_slugsuggest.event.__identity = identity;
            }

            // Create the request options
            var requestOptions = {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded'
                },
                body: data
            };

            // Make the AJAX request using fetch
            fetch(slugSuggestUrl, requestOptions)
                .then(response => response.json()) // Parse the JSON response
                .then(data => {
                    var clickEvent = new MouseEvent('click', {
                        view: window,
                        bubbles: true,
                        cancelable: true
                    });
                    slugField.dispatchEvent(clickEvent);
                    slugField.value = data.slug;
                })
                .catch(error => {
                    console.error('Error:', error);
                });
        });
    });
}

if(document.querySelectorAll('.event-form .dp-form-inline').length) {
    function toggleFormFieldOptionsForElement(element) {
        if(element.value == 'Checkbox' || element.value == 'Radio' || element.value == 'Dropdown') {
            element.closest('.dp-record').querySelector('.formFieldOptionsWrap').classList.add('show');
        } else {
            element.closest('.dp-record').querySelector('.formFieldOptionsWrap').classList.remove('show');
        }
    }
    function toggleFormFieldOptions() {
        [...document.querySelectorAll('.event-form .formFieldTypeSelect')].map(function(element) {
            toggleFormFieldOptionsForElement(element);
        });
    }

    toggleFormFieldOptions();
    document.addEventListener( "change", function(event) {
        var element = event.target;
        if(element.tagName == 'SELECT' && element.classList.contains("formFieldTypeSelect")){
            toggleFormFieldOptionsForElement(element);
        }
    });
}

// Validation Kursanmeldung
if (document.querySelectorAll('.tx-ig-ruckzuckevent #registrationForm').length > 0) {
    // Switch tab in registration form
    function switchTab(tab) {
        document.querySelectorAll('.tx-ig-ruckzuckevent #registrationForm .tabMenu .tabLink').forEach(function(tabLink) {
            tabLink.classList.remove('active');
        });
        document.querySelector('.tx-ig-ruckzuckevent #registrationForm .tabMenu .tabLink.' + tab + '-link').classList.add('active');
        document.querySelectorAll('.tx-ig-ruckzuckevent #registrationForm .tab').forEach(function(tabContent) {
            tabContent.classList.remove('show');
        });
        document.querySelector('.tx-ig-ruckzuckevent #registrationForm .' + tab).classList.add('show');
    }

    // Switch to tab with first error in registration form
    function switchToErrorTab() {
        // Find the first element with the class 'error' within the registration form
        var firstErrorElement = document.querySelector('.tx-ig-ruckzuckevent #registrationForm .error');
        
        if (firstErrorElement) {
            // Find the closest parent element with the class 'tab'
            var tabElement = firstErrorElement.closest('.tab');
            
            if (tabElement) {
                // Get the data-tab attribute value
                var tab = tabElement.dataset.tab;
                
                if (tab) {
                    // Switch to the tab
                    switchTab(tab);
                }
            }
        }
    }

    // Validation of form elements before tab switch and submit
    function validateBeforeTabSwitch(tab, lastTab) {
        var isFormValid = true;
        
        var tabsToCheck = [];
        var tabElements = document.querySelectorAll('.tx-ig-ruckzuckevent #registrationForm .' + tab);

        if(!lastTab && tabElements.length) {
            tabElements.forEach(function(tabElement) {
                // Collect previous siblings
                var sibling = tabElement.previousElementSibling;
                while (sibling) {
                    if (!sibling.classList.contains(tab)) {
                        tabsToCheck.push(sibling);
                    }
                    sibling = sibling.previousElementSibling;
                }
            });
        } else {
            tabsToCheck = tabElements;
        }

        // Check each element with the 'registration-validate' class
        tabsToCheck.forEach(function(element) {
            var validationElements = element.querySelectorAll('.registration-validate');
            validationElements.forEach(function(validationElement) {
                if (validationElement.value !== '') {
                    validationElement.classList.remove('error');
                } else {
                    validationElement.classList.add('error');
                    isFormValid = false;
                }
            });
        });
        tabsToCheck.forEach(function(element) {
            var validationElements = element.querySelectorAll('.registration-validate-inline');
            validationElements.forEach(function(validationElement) {
                if(validationElement.checkVisibility()) {
                    if (validationElement.value !== '') {
                        validationElement.classList.remove('error');
                    } else {
                        validationElement.classList.add('error');
                        isFormValid = false;
                    }
                }
            });
        });
        tabsToCheck.forEach(function(tab) {
            tab.querySelectorAll('.registration-validate-checkbox').forEach(function(checkbox) {
                let isChecked = false;
                if (checkbox.querySelector('input[type="checkbox"]:checked, input[type="radio"]:checked')) {
                    isChecked = true;
                }

                if (!isChecked) {
                    checkbox.classList.add('error');
                    isFormValid = false;
                } else {
                    checkbox.classList.remove('error');
                }
            });

            tab.querySelectorAll('.registration-email').forEach(function(emailField) {
                const emailValue = emailField.value.trim(); // Trimmed to remove leading/trailing whitespace
                if (emailValue !== '') {
                    const emailRegex = /^([a-zA-Z0-9_\.\-])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;

                    if (emailRegex.test(emailValue)) {
                        emailField.classList.remove('error');
                    } else {
                        emailField.classList.add('error');
                        isFormValid = false;
                    }
                } else if (emailField.classList.contains('registration-validate')) {
                    emailField.classList.add('error');
                } else {
                    emailField.classList.remove('error');
                }
            })

        });
        return isFormValid;
    }

    function registrationFormOnSubmit() {
        const lastTab = [...document.querySelectorAll('.tx-ig-ruckzuckevent #registrationForm .tab')].pop();
        if (!lastTab.classList.contains('show')) {
            e.preventDefault(); // Assuming `e` is the event object passed into the function
            return;
        }

        var isFormValid = validateBeforeTabSwitch(lastTab.dataset.tab, true);

        const registrationBill = document.getElementById('registration-bill');
        if (registrationBill) {
            if (registrationBill.value.trim() !== '') {
                registrationBill.classList.remove('error');
            } else {
                registrationBill.classList.add('error');
                isFormValid = false;
            }
        }

        // Check if the element with class 'registration-status' exists inside an element with class 'multiple' and 'validate'
        var parents = document.querySelectorAll('.registration-status');
        parents.forEach(function(parent) {
            if (parent.closest('.multiple.validate')) {
                var checkedCount = parent.querySelectorAll(':checked').length;
                if (checkedCount > 0) {
                    // Remove 'error' class from the parent elements
                    var ancestor = parent.closest('.multiple.validate');
                    ancestor.classList.remove('error');
                } else {
                    // Add 'error' class to the parent elements
                    var ancestor = parent.closest('.multiple.validate');
                    ancestor.classList.add('error');
                    isFormValid = false; // Assuming isFormValid is defined elsewhere
                }
            }
        });

        // Check if element with id 'registration-accept-1' exists
        var registrationAccept1 = document.getElementById('registration-accept-1');
        if (registrationAccept1) {
            // Check if the checkbox is checked
            if (registrationAccept1.checked) {
                // Remove 'error' class from the parent elements
                var ancestor = registrationAccept1.closest('.inputs-list'); // Replace with appropriate selector
                if (ancestor) {
                    ancestor.classList.remove('error');
                }
            } else {
                // Add 'error' class to the parent elements
                var ancestor = registrationAccept1.closest('.inputs-list'); // Replace with appropriate selector
                if (ancestor) {
                    ancestor.classList.add('error');
                    isFormValid = false; // Assuming isFormValid is defined elsewhere
                }
            }
        }

        // Check if element with id 'registration-accept-1' exists
        var registrationTermsConditions1 = document.getElementById('registration-termsConditions-1');
        if (registrationTermsConditions1) {
            // Check if the checkbox is checked
            if (registrationTermsConditions1.checked) {
                // Remove 'error' class from the parent elements
                var ancestor = registrationTermsConditions1.closest('.inputs-list'); // Replace with appropriate selector
                if (ancestor) {
                    ancestor.classList.remove('error');
                }
            } else {
                // Add 'error' class to the parent elements
                var ancestor = registrationTermsConditions1.closest('.inputs-list'); // Replace with appropriate selector
                if (ancestor) {
                    ancestor.classList.add('error');
                    isFormValid = false; // Assuming isFormValid is defined elsewhere
                }
            }
        }

        if (grecaptcha.getResponse() === '') {
            isFormValid = false;
        }


        if (!isFormValid) {
            switchToErrorTab();
            return;
        } else {
            // no captcha
            document.querySelector('.tx-ig-ruckzuckevent #registrationForm').submit();
            return;
        }
    }

    // Handle validation on tab switch
    document.querySelectorAll('.tx-ig-ruckzuckevent #registrationForm .tabLink').forEach(function(tabLink) {
        tabLink.addEventListener('click', function() {
            const tabId = tabLink.dataset.tab;

            if (validateBeforeTabSwitch(tabId)) {
                switchTab(tabId);
            } else {
                switchToErrorTab();
            }
        });
    });

    // Jump to tab with first error on load if errors are in the registration form
    if (document.querySelectorAll('.tx-ig-ruckzuckevent #registrationForm .error').length > 0) {
        switchToErrorTab();
    }
    if (document.querySelectorAll('#registration-bill').length) {
        var registrationBill = document.getElementById('registration-bill');
        if (registrationBill.value == 1) {
            var textInputs = document.querySelectorAll('.tab2 input[type="text"]');
            
            textInputs.forEach(function(input) {
                input.classList.add('registration-validate');
                
                var label = input.previousElementSibling; // Assuming label is the previous sibling
                label.textContent = label.textContent.trim() + ' *';
            });
        }

        registrationBill.addEventListener('change', function(e) {
            var textInputs = document.querySelectorAll('.tab2 input[type="text"]');
            
            if (this.value == 1) {
                textInputs.forEach(function(input) {
                    input.classList.add('registration-validate');
                    
                    var label = input.nextElementSibling; // Assuming label is the next sibling
                    label.textContent = label.textContent.trim() + ' *';
                });
            } else {
                textInputs.forEach(function(input) {
                    input.classList.remove('registration-validate');
                    
                    var label = input.nextElementSibling; // Assuming label is the next sibling
                    var indexOfAsterisk = label.textContent.indexOf('*');
                    label.textContent = label.textContent.substr(0, indexOfAsterisk === -1 ? label.textContent.length : indexOfAsterisk - 1);
                });
            }
        });
    }


}

document.addEventListener('DOMContentLoaded', function() {
    var publicEvents = document.querySelectorAll('.public-event');

    if (publicEvents.length > 0) {
        publicEvents.forEach(function(form) {
            form.addEventListener('submit', function(e) {
                if (!form.checkValidity()) {
                    form.reportValidity();
                    e.preventDefault();
                }
                if (grecaptcha.getResponse() === "") {
                    e.preventDefault();
                }
            });
        });

        function publicEventOnSubmit() {
            publicEvents.forEach(function(form) {
                form.dispatchEvent(new Event('submit', { bubbles: true, cancelable: true }));
            });
        }
    }

    var dpForms = document.querySelectorAll('.dp-form.event-form');

    if (dpForms.length > 0) {
        var errorTabs = document.querySelectorAll('.ig-tabs-tab .error');

        if (errorTabs.length > 0) {
            errorTabs.forEach(function(error) {
                var tabName = error.closest('.ig-tabs-tab').dataset.tabName;
                var menuItem = document.querySelector('.ig-tabs-menu-item[data-tab-name="' + tabName + '"]');
                if (menuItem) {
                    menuItem.classList.add('ig-tabs-tab-error');
                }
            });
        }
    }

    // Save current search form state to LocalStorage when on event list page
    if (document.querySelector('.tx_igruckzuckevent.event-list')) {
        var searchForm = document.querySelector('.tx_igruckzuckevent.event-list .searchForm form');
        if(searchForm && searchForm.dataset.nosearch == '1') {
            localStorage.removeItem('currentSearch');
        }
        try {
            if (searchForm) {
                // Detect plugin namespace dynamically from any form field
                var firstInput = searchForm.querySelector('input[name*="[search]["], select[name*="[search]["]');
                if (!firstInput) return;

                var fieldName = firstInput.getAttribute('name');
                var pluginNamespace = fieldName.split('[')[0];

                var currentSearch = {
                    _plugin: pluginNamespace,
                    fields: {}
                };

                // Only capture search-related fields dynamically
                var searchFields = searchForm.querySelectorAll('[name^="' + pluginNamespace + '[search]["]');
                searchFields.forEach(function(field) {
                    var fullFieldName = field.getAttribute('name');
                    var fieldPath = fullFieldName.substring(pluginNamespace.length);

                    // Skip [dateFormat] fields - they will be added with their [date] field
                    if (fieldPath.indexOf('[dateFormat]') !== -1) {
                        return;
                    }

                    // Handle [date] fields - include [dateFormat] if [date] has value
                    if (fieldPath.indexOf('[date]') !== -1 && field.value) {
                        currentSearch.fields[fieldPath] = field.value;
                        var dateFormatPath = fieldPath.replace('[date]', '[dateFormat]');
                        var dateFormatField = searchForm.querySelector('[name="' + pluginNamespace + dateFormatPath + '"]');
                        if (dateFormatField && dateFormatField.value) {
                            currentSearch.fields[dateFormatPath] = dateFormatField.value;
                        }
                        return;
                    }

                    // Regular fields - just check for value
                    if (field.value) {
                        currentSearch.fields[fieldPath] = field.value;
                    }
                });

                var searchStore = window.btoa(unescape(encodeURIComponent(JSON.stringify(currentSearch))));
                localStorage.setItem('currentSearch', searchStore);
            }
        } catch (e) {
            console.error('Error saving search state:', e);
        }
    }

    // Create dynamic back link on event detail page
    if (document.querySelector('.event-detailview')) {
        try {
            var currentSearch = localStorage.getItem('currentSearch');
            if (currentSearch) {
                var searchData = JSON.parse(decodeURIComponent(escape(window.atob(currentSearch))));
                var backLink = document.querySelector('.backLink a');
                if (backLink && searchData._plugin && searchData.fields) {
                    // Build query parameters from fields object with stored plugin namespace
                    var params = [];
                    for (var fieldPath in searchData.fields) {
                        if (searchData.fields.hasOwnProperty(fieldPath) && searchData.fields[fieldPath]) {
                            // fieldPath is like "[search][dateFrom]" or "[search][dateFrom][date]"
                            params.push(searchData._plugin + fieldPath + '=' + encodeURIComponent(searchData.fields[fieldPath]));
                        }
                    }

                    var baseUrl = backLink.href.split('?')[0];
                    if (params.length > 0) {
                        backLink.href = baseUrl + '?' + params.join('&');
                    }

                    // Remove search from localStorage when back link is clicked
                    backLink.addEventListener('click', function() {
                        localStorage.removeItem('currentSearch');
                    });
                }
            }
        } catch (e) {
            console.error('Error restoring search state:', e);
        }
    }
});
