#
# Table structure for table 'tx_igruckzuckevent_domain_model_event'
#
CREATE TABLE tx_igruckzuckevent_domain_model_event (

	title varchar(255) DEFAULT '' NOT NULL,
	subtitle varchar(255) DEFAULT '' NOT NULL,
	teaser text,
	description text,
	keywords text,
	date_from date DEFAULT NULL,
	time_from time DEFAULT NULL,
	date_to date DEFAULT NULL,
	time_to time DEFAULT NULL,
	street varchar(255) DEFAULT '' NOT NULL,
	address2 varchar(255) DEFAULT '' NOT NULL,
	zip varchar(255) DEFAULT '' NOT NULL,
	city varchar(255) DEFAULT '' NOT NULL,
	country varchar(255) DEFAULT '' NOT NULL,
	latitude varchar(255) NOT NULL DEFAULT '',
	longitude varchar(255) NOT NULL DEFAULT '',
	date_deadline date DEFAULT NULL,
	time_deadline time DEFAULT NULL,
	date_registration_start date DEFAULT NULL,
	time_registration_start time DEFAULT NULL,
	min_registrations int(11) DEFAULT '0' NOT NULL,
	max_registrations int(11) DEFAULT '0' NOT NULL,
	registrations_info varchar(255) DEFAULT '' NOT NULL,
	booked_out smallint(5) unsigned DEFAULT '0' NOT NULL,
	enable_waitlist smallint(5) unsigned DEFAULT '0' NOT NULL,
	postponed smallint(5) unsigned DEFAULT '0' NOT NULL,
	postponed_text varchar(255) DEFAULT '' NOT NULL,
	canceled smallint(5) unsigned DEFAULT '0' NOT NULL,
	canceled_text varchar(255) DEFAULT '' NOT NULL,
	registrations_possible smallint(5) unsigned DEFAULT '0' NOT NULL,
	enable_additional_persons smallint(5) unsigned DEFAULT '0' NOT NULL,
	price decimal(11,2) DEFAULT '0.00' NOT NULL,
	price_member decimal(11,2) DEFAULT '0.00' NOT NULL,
	images int(11) unsigned NOT NULL default '0',
	targetgroup text,
	targets text,
	contents text,
	workingmethods text,
	num_participants int(11) DEFAULT '0' NOT NULL,
	course_organizer text,
	datetimelabel text,
	date_from_label text,
	date_to_label text,
	duration varchar(255) DEFAULT '' NOT NULL,
	place text,
	costs text,
	note text,
	file int(11) unsigned NOT NULL default '0',
	competences text,
	diplomiert smallint(5) unsigned DEFAULT '0' NOT NULL,
	hebamme smallint(5) unsigned DEFAULT '0' NOT NULL,
	dni smallint(5) unsigned DEFAULT '0' NOT NULL,
	fage smallint(5) unsigned DEFAULT '0' NOT NULL,
	fabe smallint(5) unsigned DEFAULT '0' NOT NULL,
	ags smallint(5) unsigned DEFAULT '0' NOT NULL,
	assistent smallint(5) unsigned DEFAULT '0' NOT NULL,
	other_job_med smallint(5) unsigned DEFAULT '0' NOT NULL,
	other_job smallint(5) unsigned DEFAULT '0' NOT NULL,
	cours_no varchar(255) DEFAULT '' NOT NULL,
	logo_sbk smallint(5) unsigned DEFAULT '0' NOT NULL,
	logo_eduqua smallint(5) unsigned DEFAULT '0' NOT NULL,
	phone varchar(255) DEFAULT '' NOT NULL,
	fax varchar(255) DEFAULT '' NOT NULL,
	email varchar(255) DEFAULT '' NOT NULL,
	admin_email varchar(255) DEFAULT '' NOT NULL,
	registration_email varchar(255) DEFAULT '' NOT NULL,
	url varchar(255) DEFAULT '' NOT NULL,
	active smallint(5) unsigned DEFAULT '0' NOT NULL,
	contact_person varchar(255) DEFAULT '' NOT NULL,
	registration_url varchar(255) DEFAULT '' NOT NULL,
	detail_url varchar(255) DEFAULT '' NOT NULL,
	language_code varchar(255) DEFAULT '' NOT NULL,
	objective text,
	company varchar(255) DEFAULT '' NOT NULL,
	registrations int(11) unsigned DEFAULT '0' NOT NULL,
	organizer int(11) unsigned DEFAULT '0',
	organizers int(11) unsigned DEFAULT '0',
	categories int(11) unsigned DEFAULT '0' NOT NULL,
	qualifications int(11) unsigned DEFAULT '0' NOT NULL,
	sponsors int(11) unsigned DEFAULT '0' NOT NULL,
    event_organizer int(11) unsigned DEFAULT '0',
	is_new smallint(5) unsigned DEFAULT '0' NOT NULL,
	path_segment varchar(255) DEFAULT '' NOT NULL,
	additional_form_fields int(11) unsigned DEFAULT '0' NOT NULL,
	meeting smallint(5) unsigned DEFAULT '0' NOT NULL,
	registration_confirmation_text text,
	thank_you_text text,
	registration_visible_fields text,
	registration_required_fields text,

	tstamp int(11) unsigned DEFAULT '0' NOT NULL,
	crdate int(11) unsigned DEFAULT '0' NOT NULL,
	cruser_id int(11) unsigned DEFAULT '0' NOT NULL,
	deleted smallint(5) unsigned DEFAULT '0' NOT NULL,
	hidden smallint(5) unsigned DEFAULT '0' NOT NULL,
	starttime int(11) unsigned DEFAULT '0' NOT NULL,
	endtime int(11) unsigned DEFAULT '0' NOT NULL,
    eventgroup int(11) unsigned DEFAULT '0',


);

#
# Table structure for table 'tx_igruckzuckevent_domain_model_registration'
#
CREATE TABLE tx_igruckzuckevent_domain_model_registration (

	event int(11) unsigned DEFAULT '0' NOT NULL,

	gender varchar(255) DEFAULT '' NOT NULL,
	title varchar(255) DEFAULT '' NOT NULL,
	name varchar(255) DEFAULT '' NOT NULL,
	first_name varchar(255) DEFAULT '' NOT NULL,
	email varchar(255) DEFAULT '' NOT NULL,
	phone varchar(255) DEFAULT '' NOT NULL,
	street varchar(255) DEFAULT '' NOT NULL,
	place varchar(255) DEFAULT '' NOT NULL,
	zip varchar(255) DEFAULT '' NOT NULL,
	city varchar(255) DEFAULT '' NOT NULL,
	phone_work varchar(255) DEFAULT '' NOT NULL,
	function varchar(255) DEFAULT '' NOT NULL,
	deputy varchar(255) DEFAULT '' NOT NULL,
	comment text,
	company varchar(255) DEFAULT '' NOT NULL,
	company_street varchar(255) DEFAULT '' NOT NULL,
	company_zip varchar(255) DEFAULT '' NOT NULL,
	company_city varchar(255) DEFAULT '' NOT NULL,
	bill varchar(255) DEFAULT '' NOT NULL,
	accept smallint(5) unsigned DEFAULT '0' NOT NULL,
	terms_conditions smallint(5) unsigned DEFAULT '0' NOT NULL,
	infos_membership smallint(5) unsigned DEFAULT '0' NOT NULL,
	apprenticeship varchar(255) DEFAULT '' NOT NULL,
	workspace varchar(255) DEFAULT '' NOT NULL,
	phone_mobile varchar(255) DEFAULT '' NOT NULL,
	discount varchar(255) DEFAULT '' NOT NULL,
	voucher varchar(255) DEFAULT '' NOT NULL,
	attention int(11) unsigned DEFAULT '0',
	status int(11) unsigned DEFAULT '0' NOT NULL,
	additional_fields text,
    notification text,
    valid_from date,
    reminded tinyint(1) unsigned DEFAULT '0' NOT NULL,
    fe_user int(11) unsigned DEFAULT '0',
    payment_method varchar(255) DEFAULT '' NOT NULL,
    subscription int(11) unsigned DEFAULT '0' NOT NULL,
    workarea int(11) unsigned DEFAULT '0' NOT NULL,
    additional_persons int(11) unsigned NOT NULL default '0',
    bill_email varchar(255) DEFAULT '' NOT NULL,
    used_spaces int(11) NOT NULL default '1',
    waitlist smallint(5) unsigned DEFAULT '0' NOT NULL,
    waitlist_promotion_token varchar(255) DEFAULT '' NOT NULL,
    waitlist_promotion_status smallint(5) unsigned DEFAULT '0' NOT NULL,
    waitlist_promotion_sent_at datetime DEFAULT NULL,
    waitlist_promotion_deadline datetime DEFAULT NULL,
	language int(11) DEFAULT '0' NOT NULL,
);

CREATE TABLE tx_igruckzuckevent_domain_model_person (
	gender int(11) unsigned NOT NULL default '0',
	first_name varchar(255) DEFAULT '' NOT NULL,
	last_name varchar(255) DEFAULT '' NOT NULL,
	email varchar(255) DEFAULT '' NOT NULL,
	registration int(11) unsigned NOT NULL default '0',
);



#

CREATE TABLE tx_igruckzuckevent_domain_model_subscription (

    days_left int(11) unsigned DEFAULT '0' NOT NULL,
    start_date date DEFAULT '0000-00-00',
    expiration_date date DEFAULT '0000-00-00',
    subscription_offer int(11) unsigned DEFAULT '0' NOT NULL,
    fe_user int(11) unsigned DEFAULT '0' NOT NULL,
    payment_method varchar(255) DEFAULT '' NOT NULL,
    transaction_id varchar(255) DEFAULT '' NOT NULL,
    transaction_amount varchar(255) DEFAULT '' NOT NULL,
    transaction_currency varchar(255) DEFAULT '' NOT NULL,

);

CREATE TABLE tx_igruckzuckevent_domain_model_subscriptionoffer (
    name varchar(255) DEFAULT '' NOT NULL,
    description text NOT NULL,
    price varchar(255) DEFAULT '' NOT NULL,
    days int(11) unsigned DEFAULT '0' NOT NULL,
    duration int(11) unsigned DEFAULT '0' NOT NULL,
);


#
# Table structure for table 'tx_igruckzuckevent_domain_model_category'
#
CREATE TABLE tx_igruckzuckevent_domain_model_category (

	name varchar(255) DEFAULT '' NOT NULL,
	parent int(11) unsigned DEFAULT '0',


);

#
# Table structure for table 'tx_igruckzuckevent_domain_model_attention'
#
CREATE TABLE tx_igruckzuckevent_domain_model_attention (

	attention varchar(255) DEFAULT '' NOT NULL,


);

#
# Table structure for table 'tx_igruckzuckevent_domain_model_qualification'
#
CREATE TABLE tx_igruckzuckevent_domain_model_qualification (

	name varchar(255) DEFAULT '' NOT NULL,


);

#
# Table structure for table 'tx_igruckzuckevent_domain_model_status'
#
CREATE TABLE tx_igruckzuckevent_domain_model_status (

	status varchar(255) DEFAULT '' NOT NULL,

);

#
# Table structure for table 'tx_igruckzuckevent_domain_model_feedback'
#
CREATE TABLE tx_igruckzuckevent_domain_model_feedback (
	feedback text,
);

#
# Table structure for table 'tx_igruckzuckevent_domain_model_sponsor'
#
CREATE TABLE tx_igruckzuckevent_domain_model_sponsor (
	title varchar(255) DEFAULT '' NOT NULL,
	link varchar(255) DEFAULT '' NOT NULL,
	logo int(11) unsigned NOT NULL default '0',
);

#
# Table structure for table 'tx_igruckzuckevent_domain_model_organizer'
#
CREATE TABLE tx_igruckzuckevent_domain_model_organizer (

    name varchar(255) DEFAULT '' NOT NULL,
    address varchar(255) DEFAULT '' NOT NULL,
    zip varchar(255) DEFAULT '' NOT NULL,
    city varchar(255) DEFAULT '' NOT NULL,
    phone varchar(255) DEFAULT '' NOT NULL,
	fax varchar(255) DEFAULT '' NOT NULL,
    email varchar(255) DEFAULT '' NOT NULL,
	admin_email varchar(255) DEFAULT '' NOT NULL,
    url varchar(255) DEFAULT '' NOT NULL,
	logo int(11) unsigned NOT NULL default '0',

);

#
# Table structure for table 'tx_igruckzuckevent_domain_model_formfield'
#
CREATE TABLE tx_igruckzuckevent_domain_model_formfield (

	event int(11) unsigned DEFAULT '0' NOT NULL,

	title varchar(255) DEFAULT '' NOT NULL,
	description text,
	name varchar(255) DEFAULT '' NOT NULL,
	type varchar(255) DEFAULT '' NOT NULL,
	required smallint(5) unsigned DEFAULT '0' NOT NULL,
	options text,
	depends_on varchar(255) DEFAULT '' NOT NULL,
	depends_value text,
	depends_operator varchar(255) DEFAULT 'equal' NOT NULL,


);

#
# Table structure for table 'tx_igruckzuckevent_domain_model_workarea'
#
CREATE TABLE tx_igruckzuckevent_domain_model_workarea (

	name varchar(255) DEFAULT '' NOT NULL,


);

#
# Table structure for table 'tx_igruckzuckevent_domain_model_registration'
#
CREATE TABLE tx_igruckzuckevent_domain_model_registration (

	event int(11) unsigned DEFAULT '0' NOT NULL,

);

#
# Table structure for table 'tx_igruckzuckevent_domain_model_formfield'
#
CREATE TABLE tx_igruckzuckevent_domain_model_formfield (

	event int(11) unsigned DEFAULT '0' NOT NULL,

);

#
# Table structure for table 'tx_igruckzuckevent_event_category_mm'
#
CREATE TABLE tx_igruckzuckevent_event_category_mm (
	uid_local int(11) unsigned DEFAULT '0' NOT NULL,
	uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
	sorting int(11) unsigned DEFAULT '0' NOT NULL,
	sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

	PRIMARY KEY (uid_local,uid_foreign),
	KEY uid_local (uid_local),
	KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_igruckzuckevent_event_sponsor_mm'
#
CREATE TABLE tx_igruckzuckevent_event_sponsor_mm (
	uid_local int(11) unsigned DEFAULT '0' NOT NULL,
	uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
	sorting int(11) unsigned DEFAULT '0' NOT NULL,
	sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

	PRIMARY KEY (uid_local,uid_foreign),
	KEY uid_local (uid_local),
	KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_igruckzuckevent_event_qualification_mm'
#
CREATE TABLE tx_igruckzuckevent_event_qualification_mm (
	uid_local int(11) unsigned DEFAULT '0' NOT NULL,
	uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
	sorting int(11) unsigned DEFAULT '0' NOT NULL,
	sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

	PRIMARY KEY (uid_local,uid_foreign),
	KEY uid_local (uid_local),
	KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_igruckzuckevent_registration_status_mm'
#
CREATE TABLE tx_igruckzuckevent_registration_status_mm (
	uid_local int(11) unsigned DEFAULT '0' NOT NULL,
	uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
	sorting int(11) unsigned DEFAULT '0' NOT NULL,
	sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

	PRIMARY KEY (uid_local,uid_foreign),
	KEY uid_local (uid_local),
	KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_igruckzuckevent_event_organizer_mm'
#
CREATE TABLE tx_igruckzuckevent_event_organizer_mm (
	uid_local int(11) unsigned DEFAULT '0' NOT NULL,
	uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
	sorting int(11) unsigned DEFAULT '0' NOT NULL,
	sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

	PRIMARY KEY (uid_local,uid_foreign),
	KEY uid_local (uid_local),
	KEY uid_foreign (uid_foreign)
);

CREATE TABLE fe_users (
    subscriptions int(11) unsigned DEFAULT '0' NOT NULL,
    registrations int(11) unsigned DEFAULT '0' NOT NULL,
    hash varchar(255) DEFAULT '' NOT NULL,
);
