<?php

namespace Ig\IgRuckzuckevent\Controller;

use Ig\IgRuckzuckevent\Controller\TYPO3\CMS\Extbase\Annotation\IgnoreValidation;
use Ig\IgRuckzuckevent\Controller\TYPO3\CMS\Extbase\Annotation\Validate;
use Ig\IgRuckzuckevent\Domain\Model\Feedback;
use Ig\IgRuckzuckevent\Domain\Repository\FeedbackRepository;
use Internetgalerie\IgDynval\Controller\DynamicValidationActionController;
use Internetgalerie\IgDynval\Validation\Validator\DynamicValidator;
use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Extbase\Annotation\IgnoreValidation as AnnotationIgnoreValidation;
use TYPO3\CMS\Extbase\Annotation\Validate as AnnotationValidate;

class FeedbackController extends \Internetgalerie\IgDatapoolFe\Controller\ActionController
{
    use DynamicValidationActionController;

    /**
     * The repository for feedbacks
     *
     * @var FeedbackRepository
     */
    protected $feedbackRepository = null;

    public function injectFeedbackRepository(FeedbackRepository $feedbackRepository): void
    {
        $this->feedbackRepository = $feedbackRepository;
    }

    public function initializeView($view): void
    {
        $this->view->assign('controller', 'Feedback');
        $this->view->assign('pageUid', $this->request->getAttribute('frontend.page.information')?->getId());
    }

    /**
     * Liast all events with possibility to sort and filter them
     */
    public function listAction(): ResponseInterface
    {
        $feedbacks = $this->feedbackRepository->findAll();
        $this->view->assign('feedbacks', $feedbacks);

        return $this->htmlResponse();
    }

    /**
     * Liast all events with possibility to sort and filter them
     */
    public function organizerListAction(): ResponseInterface
    {
        $feedbacks = $this->feedbackRepository->findAll();
        $this->view->assign('feedbacks', $feedbacks);

        return $this->htmlResponse();
    }

    /**
     * New action
     */
    public function newAction(): ResponseInterface
    {
        return $this->htmlResponse();
    }

    /**
     * Create action
     */
    #[AnnotationValidate([
        'validator' => DynamicValidator::class,
        'param' => 'newFeedback',
    ])]
    public function createAction(Feedback $newFeedback): ResponseInterface
    {
        $this->feedbackRepository->add($newFeedback);
        return $this->redirect('list');
    }

    /**
     * Edit action
     */
    #[AnnotationIgnoreValidation([])] // $feedback
    public function editAction(Feedback $feedback): ResponseInterface
    {
        $this->view->assign('feedback', $feedback);

        return $this->htmlResponse();
    }

    /**
     * Update action
     */
    #[AnnotationValidate([
        'validator' => DynamicValidator::class,
        'param' => 'feedback',
    ])]
    public function updateAction(Feedback $feedback): ResponseInterface
    {
        $this->feedbackRepository->update($feedback);
        return $this->redirect('list');
    }

    /**
     * Delete action
     */
    public function deleteAction(Feedback $feedback): ResponseInterface
    {
        $this->feedbackRepository->remove($feedback);
        return $this->redirect('list');
    }
}
