<?php

namespace Ig\IgRuckzuckevent\Domain\Model;

use Ig\IgRuckzuckevent\Domain\Model\TYPO3\CMS\Extbase\Annotation\Validate;
use Ig\IgRuckzuckevent\Utility\JsonUtility;
use TYPO3\CMS\Extbase\Annotation\Validate as AnnotationValidate;
use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;

/***
 *
 * This file is part of the "Ruck Zuck Event" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2018 Simon Häsler <sh@internetgalerie.ch>, Internetgalerie AG
 *
 ***/


class Feedback extends AbstractEntity
{
    /**
     * feedback
     *
     * @var string
     */
    #[AnnotationValidate([
        'validator' => 'NotEmpty',
    ])]
    protected $feedback = '';

    /**
     * Returns the feedback
     *
     * @return string
     */
    public function getFeedback()
    {
        return $this->feedback;
    }

    /**
     * Sets the feedback
     *
     * @param string $feedback
     */
    public function setFeedback($feedback): void
    {
        $this->feedback = $feedback;
    }

    public function getJson()
    {
        return JsonUtility::getJsonForProperties($this->_getProperties());
    }
}
