<?php

namespace Ig\IgRuckzuckevent\Domain\Model;

use DateTime;
use Ig\IgRuckzuckevent\Domain\Model\WaitlistPromotionStatus;
use Ig\IgRuckzuckevent\Utility\JsonUtility;
use Ig\IgRuckzuckevent\Utility\UserUtility;
use TYPO3\CMS\Backend\Utility\BackendUtility;
use TYPO3\CMS\Core\Imaging\Icon;
use TYPO3\CMS\Core\Imaging\IconFactory;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;

/**
 * The Registration model represents entities of the table tx_igruckzuckevent_domain_model_registration.
 */
class Registration extends AbstractEntity
{
    /**
     * @var bool
     */
    protected bool $hidden = false;
    /**
     * crdate
     * @var DateTime
     */
    protected $crdate = null;

    /**
     * language
     * @var int
     */
    protected int $language = 0;

    /**
     * The gender of the registrant
     *
     * @var string
     */
    protected $gender = '';

    /**
     * The title of the registrant
     *
     * @var string
     */
    protected $title = '';

    /**
     * The name of the registratant
     *
     * @var string
     */
    protected $name = '';

    /**
     * First name of the registrant
     *
     * @var string
     */
    protected $firstName = '';

    /**
     * E-Mail address of the registrant
     *
     * @var string
     */
    protected $email = '';

    /**
     * Phone number of the registrant
     *
     * @var string
     */
    protected $phone = '';

    /**
     * street
     *
     * @var string
     */
    protected $street = '';

    /**
     * zip
     *
     * @var string
     */
    protected $zip = '';

    /**
     * city
     *
     * @var string
     */
    protected $city = '';

    /**
     * phoneWork
     *
     * @var string
     */
    protected $phoneWork = '';

    /**
     * function
     *
     * @var string
     */
    protected $function = '';

    /**
     * deputy
     *
     * @var string
     */
    protected $deputy = '';

    /**
     * comment
     *
     * @var string
     */
    protected $comment = '';

    /**
     * company
     *
     * @var string
     */
    protected $company = '';

    /**
     * companyStreet
     *
     * @var string
     */
    protected $companyStreet = '';

    /**
     * companyZip
     *
     * @var string
     */
    protected $companyZip = '';

    /**
     * companyCity
     *
     * @var string
     */
    protected $companyCity = '';

    /**
     * bill
     *
     * @var string
     */
    protected $bill = '';

    /**
     * accept
     *
     * @var bool
     */
    protected $accept = false;

    /**
     * termsConditions
     *
     * @var bool
     */
    protected $termsConditions = false;

    /**
     * infosMembership
     *
     * @var bool
     */
    protected $infosMembership = false;

    /**
     * apprenticeship
     *
     * @var string
     */
    protected $apprenticeship = '';

    /**
     * workspace
     *
     * @var string
     */
    protected $workspace = '';

    /**
     * phoneMobile
     *
     * @var string
     */
    protected $phoneMobile = '';

    /**
     * discount
     *
     * @var string
     */
    protected $discount = '';

    /**
     * voucher
     *
     * @var string
     */
    protected $voucher = '';

    /**
     * The event the registration is for
     *
     * @var Event
     */
    protected $event = null;

    /**
     * feUser
     *
     * @var FeUser
     */
    protected $feUser = null;

    /**
     * subscription
     *
     * @var Subscription
     */
    protected $subscription = null;

    /**
     * @var string
     */
    protected $paymentMethod = '';

    /**
     * attention
     *
     * @var Attention
     */
    protected $attention = null;

    /**
     * workarea
     *
     * @var Workarea
     */
    protected $workarea = null;

    /**
     * status
     *
     * @var ObjectStorage<Status>
     */
    protected $status = null;

    /**
     * additionalFields
     *
     * @var string
     */
    protected $additionalFields = '';

    /**
     * @var ObjectStorage<Person>
     */
    protected $additionalPersons = null;

    protected int $usedSpaces = 1;

    protected string $billEmail = '';

    /**
     * waitlist
     *
     * @var bool
     */
    protected $waitlist = false;

    /**
     * Token for accepting/declining waitlist promotion
     *
     * @var string
     */
    protected $waitlistPromotionToken = '';

    /**
     * Status of waitlist promotion
     * @see WaitlistPromotionStatus
     *
     * @var int
     */
    protected $waitlistPromotionStatus = 0;

    /**
     * Timestamp when promotion email was sent
     *
     * @var \DateTime|null
     */
    protected $waitlistPromotionSentAt = null;

    /**
     * Timestamp deadline for accepting promotion
     *
     * @var \DateTime|null
     */
    protected $waitlistPromotionDeadline = null;

    /**
     * captcha
     *
     * @var string
     */
    protected $captcha = '';


    /**
     * __construct
     */
    public function __construct()
    {
        //Do not remove the next line: It would break the functionality
        $this->initStorageObjects();
    }

    public function getSysLanguageUid(): int
    {
        return $this->language;
    }

    public function getHidden(): bool
    {
        return $this->hidden;
    }

    /**
     * Returns the gender
     *
     * @return string
     */
    public function getGender()
    {
        return $this->gender;
    }

    /**
     * Sets the gender
     *
     * @param string $gender
     */
    public function setGender($gender): void
    {
        $this->gender = $gender;
    }

    /**
     * Returns the title
     *
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Sets the title
     *
     * @param string $title
     */
    public function setTitle($title): void
    {
        $this->title = $title;
    }

    /**
     * Returns the name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Sets the name
     *
     * @param string $name
     */
    public function setName($name): void
    {
        $this->name = $name;
    }

    /**
     * Returns the firstName
     *
     * @return string
     */
    public function getFirstName()
    {
        return $this->firstName;
    }

    /**
     * Sets the firstName
     *
     * @param string $firstName
     */
    public function setFirstName($firstName): void
    {
        $this->firstName = $firstName;
    }

    /**
     * Returns the email
     *
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * Sets the email
     *
     * @param string $email
     */
    public function setEmail($email): void
    {
        $this->email = $email;
    }

    /**
     * Returns the phone
     *
     * @return string
     */
    public function getPhone()
    {
        return $this->phone;
    }

    /**
     * Sets the phone
     *
     * @param string $phone
     */
    public function setPhone($phone): void
    {
        $this->phone = $phone;
    }

    /**
     * Returns the event
     *
     * @return Event
     */
    public function getEvent()
    {
        return $this->event;
    }

    /**
     * Sets the event
     */
    public function setEvent(Event $event): void
    {
        $this->event = $event;
    }

    /**
     * Returns the feUser
     *
     * @return FeUser
     */
    public function getFeUser()
    {
        return $this->feUser;
    }

    /**
     * Sets the feUser
     */
    public function setFeUser(FeUser $feUser): void
    {
        $this->feUser = $feUser;
    }

    /**
     * Returns the subscription
     *
     * @return Subscription
     */
    public function getSubscription()
    {
        return $this->subscription;
    }

    /**
     * Sets the subscription
     */
    public function setSubscription(Subscription $subscription): void
    {
        $this->subscription = $subscription;
    }

    /**
     * @return string
     */
    public function getPaymentMethod()
    {
        return $this->paymentMethod;
    }

    /**
     * @param string $paymentMethod
     */
    public function setPaymentMethod($paymentMethod): void
    {
        $this->paymentMethod = $paymentMethod;
    }

    /**
     * Returns the street
     *
     * @return string
     */
    public function getStreet()
    {
        return $this->street;
    }

    /**
     * Sets the street
     *
     * @param string $street
     */
    public function setStreet($street): void
    {
        $this->street = $street;
    }

    /**
     * Returns the zip
     *
     * @return string
     */
    public function getZip()
    {
        return $this->zip;
    }

    /**
     * Sets the zip
     *
     * @param string $zip
     */
    public function setZip($zip): void
    {
        $this->zip = $zip;
    }

    /**
     * Returns the city
     *
     * @return string
     */
    public function getCity()
    {
        return $this->city;
    }

    /**
     * Sets the city
     *
     * @param string $city
     */
    public function setCity($city): void
    {
        $this->city = $city;
    }

    /**
     * Returns the phoneWork
     *
     * @return string
     */
    public function getPhoneWork()
    {
        return $this->phoneWork;
    }

    /**
     * Sets the phoneWork
     *
     * @param string $phoneWork
     */
    public function setPhoneWork($phoneWork): void
    {
        $this->phoneWork = $phoneWork;
    }

    /**
     * Returns the function
     *
     * @return string
     */
    public function getFunction()
    {
        return $this->function;
    }

    /**
     * Sets the function
     *
     * @param string $function
     */
    public function setFunction($function): void
    {
        $this->function = $function;
    }

    /**
     * Returns the comment
     *
     * @return string
     */
    public function getComment()
    {
        return $this->comment;
    }

    /**
     * Sets the comment
     *
     * @param string $comment
     */
    public function setComment($comment): void
    {
        $this->comment = $comment;
    }

    /**
     * Returns the company
     *
     * @return string
     */
    public function getCompany()
    {
        return $this->company;
    }

    /**
     * Sets the company
     *
     * @param string $company
     */
    public function setCompany($company): void
    {
        $this->company = $company;
    }

    /**
     * Returns the companyStreet
     *
     * @return string
     */
    public function getCompanyStreet()
    {
        return $this->companyStreet;
    }

    /**
     * Sets the companyStreet
     *
     * @param string $companyStreet
     */
    public function setCompanyStreet($companyStreet): void
    {
        $this->companyStreet = $companyStreet;
    }

    /**
     * Returns the companyZip
     *
     * @return string
     */
    public function getCompanyZip()
    {
        return $this->companyZip;
    }

    /**
     * Sets the companyZip
     *
     * @param string $companyZip
     */
    public function setCompanyZip($companyZip): void
    {
        $this->companyZip = $companyZip;
    }

    /**
     * Returns the companyCity
     *
     * @return string
     */
    public function getCompanyCity()
    {
        return $this->companyCity;
    }

    /**
     * Sets the companyCity
     *
     * @param string $companyCity
     */
    public function setCompanyCity($companyCity): void
    {
        $this->companyCity = $companyCity;
    }

    /**
     * Returns the bill
     *
     * @return string
     */
    public function getBill()
    {
        return $this->bill;
    }

    /**
     * Sets the bill
     *
     * @param string $bill
     */
    public function setBill($bill): void
    {
        $this->bill = $bill;
    }

    /**
     * Returns the accept
     *
     * @return bool
     */
    public function getAccept()
    {
        return $this->accept;
    }

    /**
     * Sets the accept
     *
     * @param bool $accept
     */
    public function setAccept($accept): void
    {
        $this->accept = $accept;
    }

    /**
     * Returns the termsConditions
     *
     * @return bool
     */
    public function getTermsConditions()
    {
        return $this->termsConditions;
    }

    /**
     * Sets the termsConditions
     *
     * @param bool $termsConditions
     */
    public function setTermsConditions($termsConditions): void
    {
        $this->termsConditions = $termsConditions;
    }

    /**
     * Returns the boolean state of accept
     *
     * @return bool
     */
    public function isAccept()
    {
        return $this->accept;
    }

    /**
     * Returns the infosMembership
     *
     * @return bool
     */
    public function getInfosMembership()
    {
        return $this->infosMembership;
    }

    /**
     * Sets the infosMembership
     *
     * @param bool $infosMembership
     */
    public function setInfosMembership($infosMembership): void
    {
        $this->infosMembership = $infosMembership;
    }

    /**
     * Returns the boolean state of infosMembership
     *
     * @return bool
     */
    public function isInfosMembership()
    {
        return $this->infosMembership;
    }

    /**
     * Returns the apprenticeship
     *
     * @return string
     */
    public function getApprenticeship()
    {
        return $this->apprenticeship;
    }

    /**
     * Sets the apprenticeship
     *
     * @param string $apprenticeship
     */
    public function setApprenticeship($apprenticeship): void
    {
        $this->apprenticeship = $apprenticeship;
    }

    /**
     * Returns the workspace
     *
     * @return string
     */
    public function getWorkspace()
    {
        return $this->workspace;
    }

    /**
     * Sets the workspace
     *
     * @param string $workspace
     */
    public function setWorkspace($workspace): void
    {
        $this->workspace = $workspace;
    }

    /**
     * Returns the phoneMobile
     *
     * @return string
     */
    public function getPhoneMobile()
    {
        return $this->phoneMobile;
    }

    /**
     * Sets the phoneMobile
     *
     * @param string $phoneMobile
     */
    public function setPhoneMobile($phoneMobile): void
    {
        $this->phoneMobile = $phoneMobile;
    }

    /**
     * Returns the discount
     *
     * @return string
     */
    public function getDiscount()
    {
        return $this->discount;
    }

    /**
     * Sets the discount
     *
     * @param string $discount
     */
    public function setDiscount($discount): void
    {
        $this->discount = $discount;
    }

    /**
     * Returns the voucher
     *
     * @return string
     */
    public function getVoucher()
    {
        return $this->voucher;
    }

    /**
     * Sets the voucher
     *
     * @param string $voucher
     */
    public function setVoucher($voucher): void
    {
        $this->voucher = $voucher;
    }

    /**
     * Returns the attention
     *
     * @return Attention
     */
    public function getAttention()
    {
        return $this->attention;
    }

    /**
     * Sets the attention
     */
    public function setAttention(?Attention $attention = null): void
    {
        $this->attention = $attention;
    }

    /**
     * Adds a Status
     */
    public function addStatus(Status $status): void
    {
        $this->status->attach($status);
    }

    /**
     * Removes a Status
     *
     * @param Status $statusToRemove The Status to be removed
     */
    public function removeStatus(Status $statusToRemove): void
    {
        $this->status->detach($statusToRemove);
    }

    /**
     * Returns the status
     *
     * @return ObjectStorage<Status> $status
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Sets the status
     *
     * @param ObjectStorage<Status> $status
     */
    public function setStatus(ObjectStorage $status): void
    {
        $this->status = $status;
    }

    /**
     * Returns the captcha
     *
     * @return string
     */
    public function getCaptcha()
    {
        return $this->captcha;
    }

    /**
     * Sets the captcha
     *
     * @param string $captcha
     */
    public function setCaptcha($captcha): void
    {
        $this->captcha = $captcha;
    }

    /**
     * Returns the additionalFields
     *
     * @return array
     */
    public function getAdditionalFields()
    {
        if (!$this->additionalFields) {
            return [];
        }
        return unserialize($this->additionalFields);
    }

    /**
     * Sets the additionalFields
     *
     * @param array $additionalFields
     */
    public function setAdditionalFields($additionalFields): void
    {
        $this->additionalFields = serialize($additionalFields);
    }

    public function getIconWithLink()
    {
        $tableName = 'tx_igruckzuckevent_domain_model_registration';
        $entry = [
            'uid' => $this->getUid(),
            'hidden' => $this->getHidden(),
        ];
        $iconFactory = GeneralUtility::makeInstance(IconFactory::class);
        $icon = $iconFactory->getIconForRecord($tableName, $entry, Icon::SIZE_SMALL);
        $iconHtml = $icon->render();
        return BackendUtility::wrapClickMenuOnIcon($iconHtml, $tableName, $entry['uid']);
    }

    /**
     * Get the value of crdate
     *
     * @return DateTime
     */
    public function getCrdate()
    {
        //TODO HERE var_dump($this->crdate);die();
        return $this->crdate;
    }

    /**
     * Set the value of crdate
     *
     * @return self
     */
    public function setCrdate(DateTime $crdate)
    {
        $this->crdate = $crdate;

        return $this;
    }

    /**
     * Get the value of language
     *
     * @return int
     */
    public function getLanguage(): int
    {
        return $this->language;
    }

    /**
     * Set the value of language
     *
     * @return void
     */
    public function setLanguage(int $language): void
    {
        $this->language = $language;
    }

    /**
     * Returns the canDelete
     *
     * @return boolean
     */
    public function getCanDelete()
    {
        $now = new DateTime();
        if (UserUtility::isAdminLoggedIn()) {
            $now->modify('-2 month');
        } else {
            $now->modify('+ 24 hour');
        }
        if ($this->event->getDatetimeFrom() > $now) {
            return true;
        }
        return false;
    }


    /**
     * Returns the canDeleteUser
     *
     * @return boolean
     */
    public function getCanDeleteUser()
    {
        $now = new DateTime();
        $now->modify('+ 24 hour');
        if ($this->event->getDatetimeFrom() > $now) {
            return true;
        }
        return false;
    }

    /**
     * Get the value of deputy
     *
     * @return string
     */
    public function getDeputy()
    {
        return $this->deputy;
    }

    /**
     * Set the value of deputy
     *
     * @param string $deputy
     *
     * @return self
     */
    public function setDeputy($deputy)
    {
        $this->deputy = $deputy;

        return $this;
    }


    /**
     * Get the value of workarea
     *
     * @return Workarea
     */
    public function getWorkarea()
    {
        return $this->workarea;
    }

    /**
     * Set the value of workarea
     *
     * @return self
     */
    public function setWorkarea(Workarea $workarea)
    {
        $this->workarea = $workarea;

        return $this;
    }

    public function getJson()
    {
        return JsonUtility::getJsonForProperties($this->_getProperties());
    }

    /**
     * Returns the additionalPersons
     *
     * @return ObjectStorage<Person> $additionalPerson
     */
    public function getAdditionalPersons()
    {
        return $this->additionalPersons;
    }
    public function getAdditionalPersonsCount(): int
    {
        return $this->additionalPersons->count();
    }
    public function getAdditionalPersonsNames(): array
    {
        $names = [];
        foreach ($this->additionalPersons as $person) {
            $names[] = trim($person->getLastName() . ' ' . $person->getFirstName());
        }
        return $names;
    }

    /**
     * Sets the additionalPersons
     *
     * @param ObjectStorage<Person> $additionalPersons
     */
    public function setAdditionalPersons(ObjectStorage $additionalPersons): void
    {
        $this->additionalPersons = $additionalPersons;
    }

    /**
     * Adds an additionalPerson
     */
    public function addAdditionalPerson(Person $additionalPerson): void
    {
        $this->additionalPersons->attach($additionalPerson);
    }

    /**
     * Removes an fiadditionalPersonle
     *
     * @param Person $additionalPersonToRemove The additionalPerson to be removed
     */
    public function removeAdditionalPerson(Person $additionalPersonToRemove): void
    {
        $this->additionalPersons->detach($additionalPersonToRemove);
    }
    public function getRegistrationCount(): int
    {
        return (1 + $this->getAdditionalPersonsCount()) * $this->usedSpaces;
    }
    
    public function getUsedSpaces(): int
    {
        return $this->usedSpaces;
    }

    public function setUsedSpaces(int $usedSpaces): void
    {
        $this->usedSpaces = $usedSpaces;
    }

    public function getBillEmail(): string
    {
        return $this->billEmail;
    }

    public function setBillEmail(string $billEmail): void
    {
        $this->billEmail = $billEmail;
    }

    /**
     * Returns the waitlist
     *
     * @return bool
     */
    public function getWaitlist()
    {
        return $this->waitlist;
    }

    /**
     * Sets the waitlist
     *
     * @param bool $waitlist
     */
    public function setWaitlist($waitlist): void
    {
        $this->waitlist = $waitlist;
    }

    /**
     * Returns the boolean state of waitlist
     *
     * @return bool
     */
    public function isWaitlist()
    {
        return $this->waitlist;
    }

    /**
     * Gets the waitlist promotion token
     *
     * @return string
     */
    public function getWaitlistPromotionToken(): string
    {
        return $this->waitlistPromotionToken;
    }

    /**
     * Sets the waitlist promotion token
     *
     * @param string $waitlistPromotionToken
     */
    public function setWaitlistPromotionToken(string $waitlistPromotionToken): void
    {
        $this->waitlistPromotionToken = $waitlistPromotionToken;
    }

    /**
     * Gets the waitlist promotion status (raw integer value)
     *
     * @return int
     */
    public function getWaitlistPromotionStatus(): int
    {
        return $this->waitlistPromotionStatus;
    }

    /**
     * Gets the waitlist promotion status as enum
     *
     * @return WaitlistPromotionStatus
     */
    public function getWaitlistPromotionStatusEnum(): WaitlistPromotionStatus
    {
        return WaitlistPromotionStatus::from($this->waitlistPromotionStatus);
    }

    /**
     * Sets the waitlist promotion status
     *
     * @param int|WaitlistPromotionStatus $waitlistPromotionStatus
     */
    public function setWaitlistPromotionStatus(int|WaitlistPromotionStatus $waitlistPromotionStatus): void
    {
        $this->waitlistPromotionStatus = $waitlistPromotionStatus instanceof WaitlistPromotionStatus
            ? $waitlistPromotionStatus->value
            : $waitlistPromotionStatus;
    }

    /**
     * Gets the waitlist promotion sent at timestamp
     *
     * @return \DateTime|null
     */
    public function getWaitlistPromotionSentAt(): ?\DateTime
    {
        return $this->waitlistPromotionSentAt;
    }

    /**
     * Sets the waitlist promotion sent at timestamp
     *
     * @param \DateTime|null $waitlistPromotionSentAt
     */
    public function setWaitlistPromotionSentAt(?\DateTime $waitlistPromotionSentAt): void
    {
        $this->waitlistPromotionSentAt = $waitlistPromotionSentAt;
    }

    /**
     * Gets the waitlist promotion deadline
     *
     * @return \DateTime|null
     */
    public function getWaitlistPromotionDeadline(): ?\DateTime
    {
        return $this->waitlistPromotionDeadline;
    }

    /**
     * Sets the waitlist promotion deadline
     *
     * @param \DateTime|null $waitlistPromotionDeadline
     */
    public function setWaitlistPromotionDeadline(?\DateTime $waitlistPromotionDeadline): void
    {
        $this->waitlistPromotionDeadline = $waitlistPromotionDeadline;
    }

    /**
     * Checks if the promotion is pending acceptance
     *
     * @return bool
     */
    public function isWaitlistPromotionPending(): bool
    {
        return $this->waitlistPromotionStatus === WaitlistPromotionStatus::PENDING->value && !empty($this->waitlistPromotionToken);
    }

    /**
     * Checks if the promotion deadline has passed
     *
     * @return bool
     */
    public function isWaitlistPromotionExpired(): bool
    {
        if ($this->waitlistPromotionDeadline === null) {
            return false;
        }
        return $this->waitlistPromotionDeadline < new \DateTime();
    }

    /**
     * Checks if this registration can be promoted from the waitlist
     * A registration is promotable if:
     * - It's on the waitlist
     * - It doesn't have a pending promotion
     * - It hasn't been declined (status 2)
     * - It hasn't been cancelled (status 3)
     *
     * @return bool
     */
    public function isPromotable(): bool
    {
        // Must be on waitlist
        if (!$this->waitlist) {
            return false;
        }

        // Cannot promote if already has pending promotion
        if ($this->isWaitlistPromotionPending()) {
            return false;
        }

        // Cannot promote if declined or cancelled
        if ($this->waitlistPromotionStatus === WaitlistPromotionStatus::DECLINED->value ||
            $this->waitlistPromotionStatus === WaitlistPromotionStatus::CANCELLED->value) {
            return false;
        }

        return true;
    }

    /**
     * Initializes all ObjectStorage properties
     * Do not modify this method!
     * It will be rewritten on each save in the extension builder
     * You may modify the constructor of this class instead
     */
    protected function initStorageObjects()
    {
        $this->status = new ObjectStorage();
        $this->additionalPersons = new ObjectStorage();
    }
}
