<?php

namespace Ig\IgRuckzuckevent\Domain\Model;

use DateTime;
use Ig\IgRuckzuckevent\Utility\JsonUtility;
use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;

/***
 *
 * This file is part of the "IG Payment" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2017 Simon Häsler <sh@internetgalerie.ch>, Internetgalerie AG
 *
 ***/

/**
 * Product
 */
class Subscription extends AbstractEntity
{
    /**
     * crdate
     *
     * @var int
     */
    protected $crdate;

    /**
     * daysLeft
     *
     * @var int
     */
    protected $daysLeft = 0;

    /**
     * The start date
     *
     * @var DateTime
     */
    protected $startDate = null;

    /**
     * The expiration date
     *
     * @var DateTime
     */
    protected $expirationDate = null;

    /**
     * subscriptionOffer
     *
     * @var SubscriptionOffer
     */
    protected $subscriptionOffer = null;

    /**
     * feUser
     *
     * @var FeUser
     */
    protected $feUser = null;

    /**
     * @var string
     */
    protected $paymentMethod = '';

    /**
     * @var string
     */
    protected $transactionId = '';
    /**
     * @var string
     */
    protected $transactionAmount = '';
    /**
     * @var string
     */
    protected $transactionCurrency = '';

    /**
     * Returns the crdate
     *
     * @return int
     */
    public function getCrdate()
    {
        return $this->crdate;
    }

    /**
     * Sets the crdate
     *
     * @param int $crdate
     */
    public function setCrdate($crdate): void
    {
        $this->crdate = $crdate;
    }


    /**
     * Returns the daysLeft
     *
     * @return int
     */
    public function getDaysLeft()
    {
        return $this->daysLeft;
    }
    public function getGuthabenOffen()
    {
        return $this->getDaysLeft();
    }

    /**
     * Sets the daysLeft
     *
     * @param int $daysLeft
     */
    public function setDaysLeft($daysLeft): void
    {
        $this->daysLeft = $daysLeft;
    }

    /**
     * Returns the startDate
     *
     * @return DateTime
     */
    public function getStartDate()
    {
        return $this->startDate;
    }

    /**
     * Sets the startDate
     *
     * @param DateTime $startDate
     */
    public function setStartDate($startDate): void
    {
        $this->startDate = $startDate;
    }

    /**
     * Returns the expirationDate
     *
     * @return DateTime
     */
    public function getExpirationDate()
    {
        return $this->expirationDate;
    }

    /**
     * Sets the expirationDate
     *
     * @param DateTime $expirationDate
     */
    public function setExpirationDate($expirationDate): void
    {
        $this->expirationDate = $expirationDate;
    }

    /**
     * Returns the subscriptionOffer
     *
     * @return SubscriptionOffer
     */
    public function getSubscriptionOffer()
    {
        return $this->subscriptionOffer;
    }

    /**
     * Sets the subscriptionOffer
     */
    public function setSubscriptionOffer(SubscriptionOffer $subscriptionOffer): void
    {
        $this->subscriptionOffer = $subscriptionOffer;
    }

    /**
     * Returns the feUser
     *
     * @return FeUser
     */
    public function getFeUser()
    {
        return $this->feUser;
    }

    /**
     * Sets the feUser
     */
    public function setFeUser(FeUser $feUser): void
    {
        $this->feUser = $feUser;
    }

    /**
     * @return string
     */
    public function getPaymentMethod()
    {
        return $this->paymentMethod;
    }

    /**
     * @param string $paymentMethod
     */
    public function setPaymentMethod($paymentMethod): void
    {
        $this->paymentMethod = $paymentMethod;
    }

    /**
     * @return string
     */
    public function getTransactionId()
    {
        return $this->transactionId;
    }

    /**
     * @param string $transactionId
     */
    public function setTransactionId($transactionId): void
    {
        $this->transactionId = $transactionId;
    }


    /**
     * @return string
     */
    public function getTransactionAmount()
    {
        return $this->transactionAmount;
    }

    /**
     * @param string $transactionAmount
     */
    public function setTransactionAmount($transactionAmount): void
    {
        $this->transactionAmount = $transactionAmount;
    }


    /**
     * @return string
     */
    public function getTransactionCurrency()
    {
        return $this->transactionCurrency;
    }

    /**
     * @param string $transactionCurrency
     */
    public function setTransactionCurrency($transactionCurrency): void
    {
        $this->transactionCurrency = $transactionCurrency;
    }
    public function getActive()
    {
        $now = new DateTime();
        return $this->daysLeft > 0 && $this->expirationDate >= $now;
    }

    public function getJson()
    {
        return JsonUtility::getJsonForProperties($this->_getProperties());
    }
}
