<?php

namespace Ig\IgRuckzuckevent\Domain\Model;

use Ig\IgRuckzuckevent\Domain\Model\TYPO3\CMS\Extbase\Annotation\ORM\Cascade;
use Ig\IgRuckzuckevent\Utility\JsonUtility;
use TYPO3\CMS\Extbase\Annotation\ORM\Cascade as ORMCascade;
use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;

/***
 *
 * This file is part of the "IG Payment" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2017 Simon Häsler <sh@internetgalerie.ch>, Internetgalerie AG
 *
 ***/

/**
 * Product
 */
class SubscriptionOffer extends AbstractEntity
{
    /**
     * name
     *
     * @var string
     */
    protected $name = '';

    /**
     * description
     *
     * @var string
     */
    protected $description = '';

    /**
     * price
     *
     * @var string
     */
    protected $price = '';

    /**
     * days
     *
     * @var int
     */
    protected $days = 0;

    /**
     * duration
     *
     * @var int
     */
    protected $duration = 0;

    /**
     * @var ObjectStorage<Subscription> $subscriptions
     */
    #[ORMCascade([
        'value' => 'remove',
    ])] // remove
    protected $subscriptions = 0;

    
    public function __construct()
    {
        //Do not remove the next line: It would break the functionality
        $this -> initStorageObjects();
    }

    /**
     * Returns the days
     *
     * @return int
     */
    public function getDays()
    {
        return $this->days;
    }
    public function getGuthabenTotal()
    {
        return $this->days;
    }

    /**
     * Sets the days
     *
     * @param int $days
     */
    public function setDays($days): void
    {
        $this->days = $days;
    }

    /**
     * Returns the duration
     *
     * @return int
     */
    public function getDuration()
    {
        return $this->duration;
    }

    /**
     * Sets the duration
     *
     * @param int $duration
     */
    public function setDuration($duration): void
    {
        $this->duration = $duration;
    }

    /**
     * Returns the subscriptions
     *
     * @return ObjectStorage<Subscription> $subscriptions
     */
    public function getSubscriptions()
    {
        return $this->subscriptions;
    }

    /**
     * Sets the subscriptions
     *
     * @param ObjectStorage<Subscription> $subscriptions
     */
    public function setSubscriptions(ObjectStorage $subscriptions): void
    {
        $this->subscriptions = $subscriptions;
    }

    /**
     * Adds an subscription
     */
    public function addSubscription(Subscription $subscription): void
    {
        $this -> subscriptions -> attach($subscription);
    }

    /**
     * Removes an subscription
     */
    public function removeSubscription(Subscription $subscription): void
    {
        $this -> subscriptions -> detach($subscription);
    }

    /**
     * Returns the name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Sets the name
     *
     * @param string $name
     */
    public function setName($name): void
    {
        $this->name = $name;
    }

    /**
     * Returns the description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Sets the description
     *
     * @param string $description
     */
    public function setDescription($description): void
    {
        $this->description = $description;
    }

    /**
     * Returns the price
     *
     * @return string
     */
    public function getPrice()
    {
        return $this->price;
    }

    /**
     * Sets the price
     *
     * @param string $price
     */
    public function setPrice($price): void
    {
        $this->price = $price;
    }

    public function getJson()
    {
        return JsonUtility::getJsonForProperties($this->_getProperties());
    }

    /**
     * Initializes all ObjectStorage properties
     */
    protected function initStorageObjects()
    {
        $this -> subscriptions = new ObjectStorage();
    }
}
