<?php

namespace Ig\IgRuckzuckevent\Domain\Validator;

use Ig\IgRuckzuckevent\Utility\UserUtility;
use TYPO3\CMS\Extbase\Validation\Validator\AbstractValidator;

/***
 *
 * This file is part of the "Ruck Zuck Event" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2017 Simon Häsler <sh@internetgalerie.ch>, Internetgalerie AG
 *
 ***/

/**
 * The password confirmation validator validates a password with its confirmation for registration and password update forms
 */
class PasswordConfirmationValidator extends AbstractValidator
{
    /**
     * Checks if the password is valid with its confirmation
     *
     * @param string $password
     */
    public function isValid($password): void
    {
        $passwordConfirmation = ($GLOBALS['TYPO3_REQUEST']->getParsedBody()['tx_igruckzuckevent_events'] ?? null)['passwordConfirmation'];
        
        if (!$passwordConfirmation) {
            $passwordConfirmation = ($GLOBALS['TYPO3_REQUEST']->getParsedBody()['tx_igruckzuckevent_management'] ?? null)['passwordConfirmation'];
        }
        if (!$passwordConfirmation) {
            $passwordConfirmation = ($GLOBALS['TYPO3_REQUEST']->getParsedBody()['tx_igruckzuckevent_managementuser'] ?? null)['passwordConfirmation'];
        }

        if (!$passwordConfirmation) {
            $passwordConfirmation = ($GLOBALS['TYPO3_REQUEST']->getParsedBody()['tx_igruckzuckevent_user'] ?? null)['passwordConfirmation'];
        }
        if (!$passwordConfirmation) {
            $passwordConfirmation = ($GLOBALS['TYPO3_REQUEST']->getParsedBody()['tx_igruckzuckevent_eventscalendar'] ?? null)['passwordConfirmation'];
        }

        if ($password == '') {
            $this->addError('No password entered', 1496759314);
        }
        if (UserUtility::isAdminLoggedIn() && $password = ' ') {
            // no password test
        } else {
            /*if($passwordConfirmation == '') {
                $this->addError('No password confirmation entered', 1496759315);
            }*/
            if ($password != $passwordConfirmation) {
                $this->addError('Passwords don\'t match', 1496759313);
            }
        }
    }
}
